precision highp float;
uniform sampler2D mixerTex;
uniform float iGlobalTime;
uniform vec2 iResolution;
vec2 iMouse = vec2(sin(iGlobalTime*0.1),0.7);
float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}


float smin( float a, float b, float k ){
    float res = exp( -k*a ) + exp( -k*b );
    return -log( res )/k;
}
mat3 rotY(in float a) {
    return mat3( cos(a), 0.0, sin(a),
                 0.0,    1.0, 0.0,
                -sin(a), 0.0, cos(a)
                );
}
float udRoundBox( vec3 p, vec3 b, float r ){
  return length(max(abs(p)-b,0.0))-r;
}
float sdSphere( vec3 p, float s ){
  return length(p)-s;
}
float udBox( vec3 p, vec3 b ){
  return length(max(abs(p)-b,0.0));
}
float sdBox( vec3 p, vec3 b ){
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}

float sdCapsule( vec3 p, vec3 a, vec3 b, float r ){
    vec3 pa = p - a , ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}
float sdPlane( vec3 p, vec4 n )
{
  return dot(p,n.xyz) + n.w;
}

float palkki(in vec3 p){
    
    float finalDistance = 10000000.;
    
    finalDistance = min(finalDistance, sdBox( p/(1.0+p.y/12.), vec3(2.0,6.0,2.0) ) );
    vec3 p2 = p;
    vec3 p3 = p;
    vec3 p4 = p;
    
    p3.zyx *= rotY(3.14145*0.5);
    p3.yxz *= rotY(3.14145*0.25);
    p.zyx *= rotY(3.14145*0.5);
    finalDistance = min(finalDistance, udRoundBox( (p3-vec3(2.0,0.0,0.0)), vec3(0.2,1.0,1.0) , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p3-vec3(2.0,0.0,0.0)), vec3(0.4,0.8,0.8) , 0.1 ) );
    finalDistance = min(finalDistance, udRoundBox( (p-vec3(2.0,-2.8,0.0)), vec3(0.4,3.0,0.8) , 0.1 ) );
    
    
    return finalDistance;
}
void objectGroup0(in vec3 p, out vec3 color, out float reflectiveValue, out float finalDistance){
    

    float dist1 = 1e9;
    for(float i=-2.; i<2.; i++) {
        vec3 p0=p;
        p0.xzy*=rotY(i+iGlobalTime/5.);
        p0.z*=0.7;
        dist1 =min(dist1,sdBox( (p0-vec3((cos(i+iGlobalTime/8.)-0.5)/2.,(sin(i+iGlobalTime/8.)-2.)/2.,mod(7.+i*3.5+iGlobalTime/2.,22.)-11.)), vec3(2.0) ));
    }
    finalDistance = dist1;
    color = vec3(1.2, 1.0, 0.8);
    
    vec3 p2 = vec3(abs(p.x),p.y,abs(p.z*0.6));
    finalDistance = min(finalDistance,palkki(p2-vec3(5.0,3.0,7.0+rand(vec2(floor(p.yx*3.)))/16.)));
    
    float dist2 = 1e9;
    dist2 = min(dist2, udRoundBox( (p-vec3(0.0,10.,0.0)), vec3(12.,1.0+rand(vec2(floor(p.xz*3.)))/24.,12.) , 0.1 ) );
    vec3 p3 = vec3(mod(p.x,4.)-2.,p.y,mod(p.z,4.)-2.);
    dist2 = max(dist2, -udRoundBox( p3, vec3(0.6,5.,0.6), 0.1));
    reflectiveValue = 0.8;
}


float calculateDistance(in vec3 p, out vec3 color, out float reflectiveValue) {
    float finalDistance = 10000000.;
    
    objectGroup0(p,color,reflectiveValue,finalDistance);
    return finalDistance;
}

float traceToLight(vec3 rayPosition, vec3 normalVector, vec3 lightSource){
    vec3 ro = rayPosition + normalVector*0.01;
    vec3 rd = normalize(lightSource - rayPosition);
    float t = 0.01;
    float k = 1.6;
    float res = 1.0;
    for( int i=0; i<28; i++ )
    {
        vec3 C;
        float dummy;
        float h = calculateDistance(ro + rd*t, C, dummy);
        h = max( h, 0.0 );
        res = min( res, k*h/t );
        t += clamp( h, 0.001, 0.9 );
        if( h<0.001 && length(ro + rd*t)>10.8) break;
    }
    return clamp(res,0.01,9.0);
}
vec3 tracer(vec3 rayStartPosition, vec3 rayDirection) {
    const float epsilon = 0.005;
    
    vec3 rayPosition = rayStartPosition;

    vec3 normalVector;
    float dist = 0.0;
    vec3 returnColor = vec3(0.0);
    vec3 finalColor = vec3(0.0);
    vec3 lightSource = vec3(-6.,12.+iGlobalTime/3.,-3.) ;
    float reflectiveValue = 1.0;
    float reflectionNow = 1.0;
    float finalLight = 1.0;
    
    float possibleFogLight = 1.0;
    
    for(float k=0.; k<2.; k++) {
        for(float i=0.; i<33.; i++) {
            vec3 color;
            float stepable = calculateDistance(rayPosition, color, reflectiveValue);
            dist += stepable;
            rayPosition = rayStartPosition + dist * rayDirection;
            
           
            if( length(rayPosition)>15.){


                vec3 lightDir = (lightSource-rayStartPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(rayDirection, lightDir);
                returnColor+=min(max( pow(directLight,17.1) * vec3(1.7,1.1,.9) * 0.4, 0.01),1.);
                
                
                return returnColor;
            }
            if( abs(stepable) <= epsilon){
                vec3 C;
                float dummy = 0.0;
                normalVector = vec3(    calculateDistance(rayPosition+vec3(epsilon,0,0),C,dummy)-calculateDistance(rayPosition+vec3(-epsilon,0,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,epsilon,0),C,dummy)-calculateDistance(rayPosition+vec3(0,-epsilon,0),C,dummy),
                                        calculateDistance(rayPosition+vec3(0,0,epsilon),C,dummy)-calculateDistance(rayPosition+vec3(0,0,-epsilon),C,dummy));
                normalVector = normalize(normalVector);
                float light = traceToLight(rayPosition, normalVector, lightSource);
                finalLight = min(finalLight, light);
                float lightDistance = distance(rayStartPosition,lightSource);
                
                finalColor = color * vec3(dot(normalVector, -rayDirection));
                
                
                vec3 lightDir = (lightSource-rayPosition);
                lightDir = normalize(lightDir);
                float directLight = dot(normalVector, lightDir);
                reflectionNow = max(reflectionNow,reflectiveValue);
                
                
                returnColor += ( vec3(finalLight*max(1.5*directLight*vec3(1.7,1.1,0.9),0.01)) / (k*4.8/reflectionNow + 1.0)) * finalColor;
  
                    
                break;
                
            }
        }
        dist = 0.01;
        rayStartPosition = rayPosition + normalVector;
        rayPosition = rayStartPosition;
        rayDirection = reflect(rayDirection, normalVector);
    } 
    vec3 lightDir = (lightSource-rayStartPosition);
    lightDir = normalize(lightDir);
    float directLight = dot(rayDirection, lightDir);
    returnColor+=min(max( pow(directLight,17.1) * vec3(1.7,1.1,.9) * 0.08, 0.01),1.);
               
    return returnColor;
}

vec3 piip() {
    vec3 cameraPosition = vec3( 0., 6.+iGlobalTime/24., -13.+iGlobalTime/3.);
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    
    float aspect = iResolution.x / iResolution.y;
    vec3 direction = normalize(vec3(.5 * uv * vec2(aspect, 1.0), 1. ));
    direction.yxz *= rotY(-0.2 - iGlobalTime/48.);
    cameraPosition *= rotY(-3.141/2.);
    direction *= rotY(-3.141/2.);
    direction.xzy *= rotY(-.1);
    direction *= rotY(.3+iGlobalTime/48.);
    return tracer(cameraPosition, direction);
}











void main( ){
    
    vec2 uv = 2.0 * gl_FragCoord.xy / iResolution.xy - 1.0;
    float aspect = iResolution.x / iResolution.y;
    gl_FragColor = vec4(min(iGlobalTime/8.,1.)*pow(piip(),vec3(1.2))*4.5,1.);
}