import ddf.minim.*;

public interface Effect {
  public void setup(PGraphics pg);
  public void draw(PGraphics pg); 
}

static Effect[] effects;
static float partTimes[] = {25000, 35000};
  
Minim minim;
AudioPlayer player;

float startTime = -1;
int activePart = 0, lastPart = -1;

PGraphics pg;

void setup() {
    pg = createGraphics(displayWidth, displayHeight);
    pg.background(0);
    pg.setSize(displayWidth, displayHeight);
    size(displayWidth, displayHeight);
    println("Tried to create graphics at size " + displayWidth + "x" + displayHeight + ", got " + pg.width + "x" + pg.height);
    pg.smooth();
    frameRate(25);
    frame.setResizable(true);
    frame.setSize(displayWidth, displayHeight);
    sketchFullScreen();
    minim = new Minim(this);
    //print(dataPath("kiva_valtakunta_Siel2.mp3"));
    player = minim.loadFile(dataPath("kiva_valtakunta_Siel2.mp3"));
    effects = new Effect[2];
    effects[0] = new Drip();
    effects[1] = new Drip2();
    for (Effect fx: effects) {
      fx.setup(pg);
    }
    player.play();
}  

  void draw()
  {
    if (startTime == -1)
      startTime = millis();
    lastPart = activePart;
    float pastParts = 0;
    for (int i = 0; i < activePart; i++)
      pastParts += partTimes[i];
    if (millis() - pastParts - startTime > partTimes[activePart]) {
      println(millis()-pastParts-startTime + " greater than " + partTimes[activePart] + ", moving on to next part...");
      lastPart = activePart++;
    }
    if (activePart < effects.length)
      effects[activePart].draw(pg);
    else
      exit();
    image(((PImage)pg), 0, 0);
  }
  
  void mouseClicked()
  {
    lastPart = activePart++;  
  }
  
  void stop()
  {
    player.close();
    minim.stop();
    super.stop();
  }
