import moonlander.library.*;

// Minim must be imported when using Moonlander with soundtrack.
import ddf.minim.*;

Moonlander moonlander;

float xmag, ymag = 0;
float newXmag, newYmag = 0; 

// VARS  ==================================================
PVector P1;
PVector P2;
float angle=0.3;
boolean bPaint=false;
boolean bFill=true;
int depthMAX=3;

PFont font;
PShape rekt;


PShape asteroid;
PShape dino;

int w = 1280;
int h = 720;

int ptsW, ptsH;

PImage img;

int numPointsW;
int numPointsH_2pi; 
int numPointsH;

double time;

float[] coorX;
float[] coorY;
float[] coorZ;
float[] multXZ;

void setup() {
  size(w, h, P3D); 
  rectMode(CENTER);        
  P1 = new PVector(0, 0, 0);
  P2 = new PVector(-200, -200, 0);
  rekt = loadShape("trect_compact.obj");
  font = loadFont("ARDESTINE-48.vlw");
   asteroid = loadShape("asteroid.obj");
   dino = loadShape("dino_tiny.obj");
   moonlander = Moonlander.initWithSoundtrack(this, "watfak.mp3", 120, 4);
   moonlander.start();
   earthInit();
}
void draw() {
  background(0); 
  moonlander.update(); 
  int scene = moonlander.getIntValue("scene");
 // pushMatrix();
  if(scene == 1) {
    noStroke();
    drawSpheres();
  }
  else if(scene == 2) {
    noStroke();
    earth();
  }
  else if(scene == 3) {
    noStroke();
    fuckingBoxs();
  }
  else if(scene == 4) {
    stroke(204, 102, 0);
    shit();
  }
  //popMatrix();  
}

void drawCircle(int x, int y, float radius) {
  ellipse(x, y, radius, radius);
  if(radius > 2) {
    radius *= 0.75f;
//The drawCircle() function is calling itself recursively.
    drawCircle(x, y, radius);
  }
}

void DrawMyBox (PVector P1, float size1, int depth1, float xmag, float ymag) {
  rotateX(-ymag); 
  rotateY(-xmag);
  float size13=size1/3;
  for (int x = 0; x < 3; x = x+1) {
    for (int y = 0; y < 3; y = y+1) {
      for (int z = 0; z < 3; z = z+1) {
        if (depth1==depthMAX) {
          if (bFill) {
            //fill(2,2,230);
            //fill ((y+2)*50,(z+2)*50,(x+2)*50);
            fill (Z*3, (y+2)*50, (x+1)*8);
          }
          else {
            stroke(200,200,200);
            noFill();
          }
          pushMatrix();
          translate(P1.x+x*size13,P1.y+y*size13,P1.z+z*size13);
          if ((x==1)&&(y==1)) {
            noFill();
          }
          else if ((z==1)&&(x==1)) {
            noFill();
          }
          else if ((z==1)&&(y==1)) {
            noFill();
          }              
          box(size13);
          popMatrix();
 
        }         
        else {
          bPaint=true;  
          if ((x==1)&&(y==1)) {
            bPaint=false;
          }
          else if ((z==1)&&(x==1)) {
            bPaint=false;
          }
          else if ((z==1)&&(y==1)) {
            bPaint=false;
          }              
          if (bPaint) {
            PVector P_New1 = new PVector(P1.x+x*size13,P1.y+y*size13,P1.z+z*size13);
            //xmag=0;
            //ymag=0;
            DrawMyBox ( P_New1,size13,depth1+1, xmag, ymag);
          }
        }
      }
    }
  }
}

void drawSphere() {
 // background(0);
  //translate(100, 100, 0);
  //noStroke();
  fill(255);
  sphere(50);
}

void drawRekt() {
 // background(0);
  //translate(100, 100, 0);
  //noStroke();
  //ambientLight(51, 102, 126);
  lights();
  rotateX(PI);
  scale(5);
  shape(rekt);
}

void shit() {
    // Handles communication with Rocket. In player mode
    // does nothing. Must be called at the beginning of draw().
    //moonlander.update();
    
    // This shows how you can query value of a track.
    // If track doesn't exist in Rocket, it's automatically
    // created.
    
    double bg_red = moonlander.getValue("background_red");
    // All values in Rocket are floats; however, there's 
    // a shortcut for querying integer value (getIntValue)
    // so you don't need to cast.
    int bg_green = moonlander.getIntValue("background_green");
    int bg_blue = moonlander.getIntValue("background_blue");
    
    //int x = moonlander.getIntValue("x");
    //int y = moonlander.getIntValue("y");
    //int r = moonlander.getIntValue("r");
    
    int px = moonlander.getIntValue("px");
    int py = moonlander.getIntValue("py");
    int pz = moonlander.getIntValue("pz");
    P2 = new PVector(px, py, pz);
    
    // Use values to control anything (in this case, background color).
    background((int)bg_red, bg_blue, bg_green);
    //drawCircle(x,y,r);
    
    int eyeX = moonlander.getIntValue("ex");
    int eyeY = moonlander.getIntValue("ey");
    int eyeZ = moonlander.getIntValue("ez");
    int centerX = moonlander.getIntValue("cx");
    int centerY = moonlander.getIntValue("cy");
    int centerZ = moonlander.getIntValue("cz");
    int upX = moonlander.getIntValue("ux");
    int upY = moonlander.getIntValue("uy");
    int upZ = moonlander.getIntValue("uz");
    camera(eyeX, eyeY, eyeZ, centerX, centerY, centerZ, upX, upY, upZ);
    
    // You can also ask current time and row from Moonlander if you
      // want to do something custom in code based on time.
    //textSize(50);
    //text("TTTTTTTTTTTT", 0, 0, -300);
    //text("Time: " + String.format("%.2f", moonlander.getCurrentTime()), 50, 300);
    //text("Row: " + String.format("%.2f", moonlander.getCurrentRow()), 10, 60);
    //text("Color values: (" + (int)bg_red + ", " + bg_green + ", " + bg_blue + ")", 10, 90);

    //pushMatrix(); 
    //translate(0, 0, 0); 
    
    float newXmag = (float) moonlander.getValue("xmag");
    float newYmag = (float) moonlander.getValue("ymag");
    int scene2 = moonlander.getIntValue("scene2");
    //newXmag = (float)(moonlander.getCurrentTime())*(width)*0.05/(float)(width) * TWO_PI;
    //newYmag = (float)(moonlander.getCurrentTime())*(height)*0.05/(float)(height) * TWO_PI;
    
    float diff = xmag-newXmag;
    if (abs(diff) >  0.01) { 
      xmag -= diff/4.0; 
    }
    
    diff = ymag-newYmag;
    if (abs(diff) >  0.01) { 
      ymag -= diff/4.0; 
    }
    
    rotateX(-ymag); 
    rotateY(-xmag);
    
    if (scene2==1) {
      DrawMyBox ( P2,200, 2, 0, 0);
    //rotateX(-ymag*100); 
    //rotateY(-xmag*100);
    }
    else if (scene2==3){
      //drawRekt();
      DrawMyBox ( P2,200,1, 0, 0);
    }
    else if (scene2==4){
       drawRekt();
       DrawMyBox ( P2,200,2, xmag, ymag);
     }
    else if (scene2==10){
      drawRekt();
      //DrawMyBox ( P2,200,1, 0, 0);
    }
    else {
      //drawRekt();
      DrawMyBox ( P2,200,2, xmag, ymag);
    }
    if (scene2==2) {
    pushMatrix();
    rotate(-HALF_PI, 0, 1, 0);
    textFont(font, 32);
    textSize(150);
    text("t-", -170, 0, 0);
    text("ekt", 270, 0, 0);
    //text("R", 0, 0, 0);
    popMatrix();      
    }
}
void explode() {
  

}

void fuckingBoxs() {
 int row = (int)moonlander.getCurrentRow();
 float time=(float) moonlander.getCurrentRow()*0.1;
 background(0);
 noStroke();
 lights();
 
 
 int space = (int)moonlander.getValue("space");
 int NUM = (int)moonlander.getValue("boxNum");
 float pos = -NUM/2.0*space;
 
 
 
 translate((int)pos, (int)pos, (int)pos);
 
 for(int i=0; i<NUM; i++) {
   translate(0, 0, space);
   pushMatrix();
   for(int j=0; j<NUM; j++) {
     translate(0, space, 0);
     pushMatrix();
     

     for(int k=0; k<NUM; k++) {
       float c = sin(time + sqrt(pow(i, 2) + pow(j, 2) + pow(k, 2)));
       fill(0, 190+(int)(60*c), 0);
       translate(space, 0, 0);
       pushMatrix();
       if((int)moonlander.getValue("boxRow") > 8) {
         rotate(time); 
       }
       
       double a = moonlander.getValue("size");
       
       int b = 6 + (int)a + (int)c*6;
       box(b);
       popMatrix();
     }
     popMatrix();
   }
   popMatrix(); 
 }
 
  
  camera(cos(time)*800, 0, sin(time)*800, 
          1, 0, 0,
          0, 1, 0
        );  
}

void earthInit() {
  img=loadImage("map.jpg");
  ptsW=30;
  ptsH=30;
  initializeSphere(ptsW, ptsH);  
}

void circle(int r, int a) {
  
  float step = TWO_PI/a;
  
  for(int i=0; i < a; i++) {
     pushMatrix();
     translate(sin(i*step)*r, cos(i*step)*r, 0);
     sphere(1);
     popMatrix();
  }
}

void earth() {
 int row = (int)moonlander.getCurrentRow();
 time = moonlander.getCurrentTime();
 pointLight(255, 247, 200, -2000, -2000, 1500);
 randomSeed(1337);
 for(int i=0; i < 200; i++) {
   fill(255, 255, 255);
   pushMatrix();
   translate(random(-2*w, 2*w), random(-2*h, 2*h), random(-400, -800));
   sphere(1);
   popMatrix();
 }
  pushMatrix();
  rotateX(-0.4);
  rotateY((float)time*0.1);

  //rotate((float)time*0.5, 1, 1, 0);
  color c = color(36, 160, 255, 70);
  fill(c);
  
  int R = moonlander.getIntValue("earthR");
  int airSize = moonlander.getIntValue("airSize");
  textureSphere(R, R, R, img);
  sphere(R+airSize);
  popMatrix();
  
  //sin(millis()*0.001)*200c
  camera(0, 0, 1000, 
          0, 0, 0,
          0, 1, 0
        );
        
  double asteroidDist = moonlander.getValue("asteroidDist");
  
  float r = (float) asteroidDist;
  rotateY(radians(60));
  pushMatrix();

  translate(cos((float) time)*r, sin((float) time)*r, 0);
  
  rotateX(millis()*0.001);
  
  scale(2);
  shape(asteroid, 0, 0);
  popMatrix();
  
  translate(0, 0, 400);
  int hit = moonlander.getIntValue("asteroidHit");
  if(hit > 0) {
    color h = color(255-hit, 255-hit, 255-hit);
   fill(h);
   background(h);
  }
}

void initializeSphere(int numPtsW, int numPtsH_2pi) {
  // The number of points around the width and height
  numPointsW=numPtsW+1;
  numPointsH_2pi=numPtsH_2pi;  // How many actual pts around the sphere (not just from top to bottom)
  numPointsH=ceil((float)numPointsH_2pi/2)+1;  // How many pts from top to bottom (abs(....) b/c of the possibility of an odd numPointsH_2pi)

  coorX=new float[numPointsW];   // All the x-coor in a horizontal circle radius 1
  coorY=new float[numPointsH];   // All the y-coor in a vertical circle radius 1
  coorZ=new float[numPointsW];   // All the z-coor in a horizontal circle radius 1
  multXZ=new float[numPointsH];  // The radius of each horizontal circle (that you will multiply with coorX and coorZ)

  for (int i=0; i<numPointsW ;i++) {  // For all the points around the width
    float thetaW=i*2*PI/(numPointsW-1);
    coorX[i]=sin(thetaW);
    coorZ[i]=cos(thetaW);
  }
  
  for (int i=0; i<numPointsH; i++) {  // For all points from top to bottom
    if (int(numPointsH_2pi/2) != (float)numPointsH_2pi/2 && i==numPointsH-1) {  // If the numPointsH_2pi is odd and it is at the last pt
      float thetaH=(i-1)*2*PI/(numPointsH_2pi);
      coorY[i]=cos(PI+thetaH); 
      multXZ[i]=0;
    } 
    else {
      //The numPointsH_2pi and 2 below allows there to be a flat bottom if the numPointsH is odd
      float thetaH=i*2*PI/(numPointsH_2pi);

      //PI+ below makes the top always the point instead of the bottom.
      coorY[i]=cos(PI+thetaH); 
      multXZ[i]=sin(thetaH);
    }
  }  
}

void drawSpheres() {
    lights();
    int box_size = moonlander.getIntValue("box_size");
    int dc = moonlander.getIntValue("distance_center");
    int cubes = moonlander.getIntValue("cubes");
    float time = (float)(moonlander.getCurrentTime()*1000);
    int midbox_size = moonlander.getIntValue("midSize");
    int pallor = moonlander.getIntValue("palloR");
    int pallog = moonlander.getIntValue("palloG");
    int pallob = moonlander.getIntValue("palloB");
    rectMode(CENTER);
    //background(200,200,200);
    camera(cos(time*0.001)*400, 0, sin(time*0.001)*400, 0, 0, 0, 0.0, 1.0, 0.0);
    noStroke();
    fill(0,0,255);
    sphere(midbox_size*0.8);
    noStroke();
    int count1 = 0;
    int count2 = 0;
    for (int i = 0; i < cubes; i = i+1) {
      pushMatrix();
      int boxOrig = box_size;
      if(cubes == 8)  box_size = (int)(box_size/1.5);
      if(cubes == 16) box_size = (int)(box_size/2); 
      if(cubes == 32) box_size = (int)(box_size/2.6);
      if(cubes == 74) box_size = (int)(box_size/3.2);
      if(cubes == 100)box_size = (int)(box_size*2);
      float angle = TWO_PI / cubes;
      float angle4 = TWO_PI / 4;
      float angle6 = TWO_PI / 6;
      float angle8 = TWO_PI / 8;
      float angle12 = TWO_PI / 12;
      if(cubes > 16) angle = TWO_PI / 16;
      int r = 150;
      int r2 = (int)(sqrt(r*r-(r/2)*(r/2))); 
      int r3 = (int)(sqrt(r*r-(r/4)*(r/4)));
      int r4 = (int)(sqrt(r*r-(r/4*3)*(r/4*3)));
      if(cubes < 54) {
        if(i < 16) translate(cos(time*0.001+angle*i)*r*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle*i)*r*sin(TWO_PI*0.25*dc/100),0);
        if(i > 15) {
          if (count1 < 8)     translate(cos(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),((r/2))*sin(TWO_PI*0.25*dc/100));
          else if(count1 > 7) translate(cos(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),-((r/2))*sin(TWO_PI*0.25*dc/100));
          count1 += 1;
        }
      }
      else if(cubes == 74) {
        //16 keskirinkula
        if(i < 16) translate(cos(time*0.001+angle*i)*r*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle*i)*r*sin(TWO_PI*0.25*dc/100),0);
        //12 ja 12 rinkulat
        if(i > 15 && i < 40) {
          if (count2 < 12)     translate(cos(time*0.001+angle12*i)*r3*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle12*i)*r3*sin(TWO_PI*0.25*dc/100),((r/4))*sin(TWO_PI*0.25*dc/100));
          else if(count2 > 11) translate(cos(time*0.001+angle12*i)*r3*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle12*i)*r3*sin(TWO_PI*0.25*dc/100),-((r/4))*sin(TWO_PI*0.25*dc/100));
          count2 += 1;
        }
        
        if(i > 39 && i < 56) {
          //8 ja 8 rinkulat
          //count == 24
          if(count2 < 31) translate(cos(time*0.001+angle8*i)*r2*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle8*i)*r2*sin(TWO_PI*0.25*dc/100),((r/2))*sin(TWO_PI*0.25*dc/100));
          else if (count2 > 30) translate(cos(time*0.001+angle8*i)*r2*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle8*i)*r2*sin(TWO_PI*0.25*dc/100),-((r/2))*sin(TWO_PI*0.25*dc/100));
          count2 += 1;
        }
        if(i > 55 && i < 72) {
          //8 ja 8 rinkulat
          //count == 40
          if(count2 < 48) translate(cos(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),((r/4*3))*sin(TWO_PI*0.25*dc/100));
          else if (count2 > 47) translate(cos(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),sin(time*0.001+angle8*i)*r4*sin(TWO_PI*0.25*dc/100),-((r/4*3))*sin(TWO_PI*0.25*dc/100));
          count2++;
        }
        if(i > 71) {
          if(i == 72) translate(0,0,r*sin(TWO_PI*0.25*dc/100));
          if(i == 73) translate(0,0,-r*sin(TWO_PI*0.25*dc/100));
        }
      }
      fill(pallor,pallog,pallob);
      sphere(box_size*0.6);
      
      box_size=boxOrig;
      popMatrix();
    }
}

void textureSphere(float rx, float ry, float rz, PImage t) { 
  // These are so we can map certain parts of the image on to the shape 
  float changeU=t.width/(float)(numPointsW-1); 
  float changeV=t.height/(float)(numPointsH-1); 
  float u=0;  // Width variable for the texture
  float v=0;  // Height variable for the texture

  beginShape(TRIANGLE_STRIP);
  texture(t);
  for (int i=0; i<(numPointsH-1); i++) {  // For all the rings but top and bottom
    // Goes into the array here instead of loop to save time
    float coory=coorY[i];
    float cooryPlus=coorY[i+1];

    float multxz=multXZ[i];
    float multxzPlus=multXZ[i+1];

    for (int j=0; j<numPointsW; j++) {  // For all the pts in the ring
      normal(coorX[j]*multxz, coory, coorZ[j]*multxz);
      vertex(coorX[j]*multxz*rx, coory*ry, coorZ[j]*multxz*rz, u, v);
      normal(coorX[j]*multxzPlus, cooryPlus, coorZ[j]*multxzPlus);
      vertex(coorX[j]*multxzPlus*rx, cooryPlus*ry, coorZ[j]*multxzPlus*rz, u, v+changeV);
      u+=changeU;
    }
    v+=changeV;
    u=0;
  }
  endShape();
}
