/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;

public class trekt
extends PApplet {
    Moonlander moonlander;
    float xmag;
    float ymag = 0.0f;
    float newXmag;
    float newYmag = 0.0f;
    PVector P1;
    PVector P2;
    float angle = 0.3f;
    boolean bPaint = false;
    boolean bFill = true;
    int depthMAX = 3;
    PFont font;
    PShape rekt;
    PShape asteroid;
    PShape dino;
    int w = 1280;
    int h = 720;
    int ptsW;
    int ptsH;
    PImage img;
    int numPointsW;
    int numPointsH_2pi;
    int numPointsH;
    double time;
    float[] coorX;
    float[] coorY;
    float[] coorZ;
    float[] multXZ;

    public void setup() {
        this.size(this.w, this.h, "processing.opengl.PGraphics3D");
        this.rectMode(3);
        this.P1 = new PVector(0.0f, 0.0f, 0.0f);
        this.P2 = new PVector(-200.0f, -200.0f, 0.0f);
        this.rekt = this.loadShape("trect_compact.obj");
        this.font = this.loadFont("ARDESTINE-48.vlw");
        this.asteroid = this.loadShape("asteroid.obj");
        this.dino = this.loadShape("dino_tiny.obj");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"watfak.mp3", (int)120, (int)4);
        this.moonlander.start();
        this.earthInit();
    }

    public void draw() {
        this.background(0);
        this.moonlander.update();
        int n = this.moonlander.getIntValue("scene");
        if (n == 1) {
            this.noStroke();
            this.drawSpheres();
        } else if (n == 2) {
            this.noStroke();
            this.earth();
        } else if (n == 3) {
            this.noStroke();
            this.fuckingBoxs();
        } else if (n == 4) {
            this.stroke(204.0f, 102.0f, 0.0f);
            this.shit();
        }
    }

    public void drawCircle(int n, int n2, float f) {
        this.ellipse(n, n2, f, f);
        if (f > 2.0f) {
            this.drawCircle(n, n2, f *= 0.75f);
        }
    }

    public void DrawMyBox(PVector pVector, float f, int n, float f2, float f3) {
        this.rotateX(-f3);
        this.rotateY(-f2);
        float f4 = f / 3.0f;
        int n2 = 0;
        while (n2 < 3) {
            int n3 = 0;
            while (n3 < 3) {
                int n4 = 0;
                while (n4 < 3) {
                    if (n == this.depthMAX) {
                        if (this.bFill) {
                            this.fill(6.0f, (n3 + 2) * 50, (n2 + 1) * 8);
                        } else {
                            this.stroke(200.0f, 200.0f, 200.0f);
                            this.noFill();
                        }
                        this.pushMatrix();
                        this.translate(pVector.x + (float)n2 * f4, pVector.y + (float)n3 * f4, pVector.z + (float)n4 * f4);
                        if (n2 == 1 && n3 == 1) {
                            this.noFill();
                        } else if (n4 == 1 && n2 == 1) {
                            this.noFill();
                        } else if (n4 == 1 && n3 == 1) {
                            this.noFill();
                        }
                        this.box(f4);
                        this.popMatrix();
                    } else {
                        this.bPaint = true;
                        if (n2 == 1 && n3 == 1) {
                            this.bPaint = false;
                        } else if (n4 == 1 && n2 == 1) {
                            this.bPaint = false;
                        } else if (n4 == 1 && n3 == 1) {
                            this.bPaint = false;
                        }
                        if (this.bPaint) {
                            PVector pVector2 = new PVector(pVector.x + (float)n2 * f4, pVector.y + (float)n3 * f4, pVector.z + (float)n4 * f4);
                            this.DrawMyBox(pVector2, f4, n + 1, f2, f3);
                        }
                    }
                    ++n4;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void drawSphere() {
        this.fill(255);
        this.sphere(50.0f);
    }

    public void drawRekt() {
        this.lights();
        this.rotateX((float)Math.PI);
        this.scale(5.0f);
        this.shape(this.rekt);
    }

    public void shit() {
        double d = this.moonlander.getValue("background_red");
        int n = this.moonlander.getIntValue("background_green");
        int n2 = this.moonlander.getIntValue("background_blue");
        int n3 = this.moonlander.getIntValue("px");
        int n4 = this.moonlander.getIntValue("py");
        int n5 = this.moonlander.getIntValue("pz");
        this.P2 = new PVector((float)n3, (float)n4, (float)n5);
        this.background((int)d, n2, n);
        int n6 = this.moonlander.getIntValue("ex");
        int n7 = this.moonlander.getIntValue("ey");
        int n8 = this.moonlander.getIntValue("ez");
        int n9 = this.moonlander.getIntValue("cx");
        int n10 = this.moonlander.getIntValue("cy");
        int n11 = this.moonlander.getIntValue("cz");
        int n12 = this.moonlander.getIntValue("ux");
        int n13 = this.moonlander.getIntValue("uy");
        int n14 = this.moonlander.getIntValue("uz");
        this.camera(n6, n7, n8, n9, n10, n11, n12, n13, n14);
        float f = (float)this.moonlander.getValue("xmag");
        float f2 = (float)this.moonlander.getValue("ymag");
        int n15 = this.moonlander.getIntValue("scene2");
        float f3 = this.xmag - f;
        if (trekt.abs((float)f3) > 0.01f) {
            this.xmag -= f3 / 4.0f;
        }
        if (trekt.abs((float)(f3 = this.ymag - f2)) > 0.01f) {
            this.ymag -= f3 / 4.0f;
        }
        this.rotateX(-this.ymag);
        this.rotateY(-this.xmag);
        if (n15 == 1) {
            this.DrawMyBox(this.P2, 200.0f, 2, 0.0f, 0.0f);
        } else if (n15 == 3) {
            this.DrawMyBox(this.P2, 200.0f, 1, 0.0f, 0.0f);
        } else if (n15 == 4) {
            this.drawRekt();
            this.DrawMyBox(this.P2, 200.0f, 2, this.xmag, this.ymag);
        } else if (n15 == 10) {
            this.drawRekt();
        } else {
            this.DrawMyBox(this.P2, 200.0f, 2, this.xmag, this.ymag);
        }
        if (n15 == 2) {
            this.pushMatrix();
            this.rotate(-1.5707964f, 0.0f, 1.0f, 0.0f);
            this.textFont(this.font, 32.0f);
            this.textSize(150.0f);
            this.text("t-", -170.0f, 0.0f, 0.0f);
            this.text("ekt", 270.0f, 0.0f, 0.0f);
            this.popMatrix();
        }
    }

    public void explode() {
    }

    public void fuckingBoxs() {
        this.moonlander.getCurrentRow();
        float f = (float)this.moonlander.getCurrentRow() * 0.1f;
        this.background(0);
        this.noStroke();
        this.lights();
        int n = (int)this.moonlander.getValue("space");
        int n2 = (int)this.moonlander.getValue("boxNum");
        float f2 = (float)(-n2) / 2.0f * (float)n;
        this.translate((int)f2, (int)f2, (int)f2);
        int n3 = 0;
        while (n3 < n2) {
            this.translate(0.0f, 0.0f, n);
            this.pushMatrix();
            int n4 = 0;
            while (n4 < n2) {
                this.translate(0.0f, n, 0.0f);
                this.pushMatrix();
                int n5 = 0;
                while (n5 < n2) {
                    float f3 = trekt.sin((float)(f + trekt.sqrt((float)(trekt.pow((float)n3, (float)2.0f) + trekt.pow((float)n4, (float)2.0f) + trekt.pow((float)n5, (float)2.0f)))));
                    this.fill(0.0f, 190 + (int)(60.0f * f3), 0.0f);
                    this.translate(n, 0.0f, 0.0f);
                    this.pushMatrix();
                    if ((int)this.moonlander.getValue("boxRow") > 8) {
                        this.rotate(f);
                    }
                    double d = this.moonlander.getValue("size");
                    int n6 = 6 + (int)d + (int)f3 * 6;
                    this.box(n6);
                    this.popMatrix();
                    ++n5;
                }
                this.popMatrix();
                ++n4;
            }
            this.popMatrix();
            ++n3;
        }
        this.camera(trekt.cos((float)f) * 800.0f, 0.0f, trekt.sin((float)f) * 800.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    public void earthInit() {
        this.img = this.loadImage("map.jpg");
        this.ptsW = 30;
        this.ptsH = 30;
        this.initializeSphere(this.ptsW, this.ptsH);
    }

    public void circle(int n, int n2) {
        float f = (float)Math.PI * 2 / (float)n2;
        int n3 = 0;
        while (n3 < n2) {
            this.pushMatrix();
            this.translate(trekt.sin((float)((float)n3 * f)) * (float)n, trekt.cos((float)((float)n3 * f)) * (float)n, 0.0f);
            this.sphere(1.0f);
            this.popMatrix();
            ++n3;
        }
    }

    public void earth() {
        this.moonlander.getCurrentRow();
        this.time = this.moonlander.getCurrentTime();
        this.pointLight(255.0f, 247.0f, 200.0f, -2000.0f, -2000.0f, 1500.0f);
        this.randomSeed(1337L);
        int n = 0;
        while (n < 200) {
            this.fill(255.0f, 255.0f, 255.0f);
            this.pushMatrix();
            this.translate(this.random(-2 * this.w, 2 * this.w), this.random(-2 * this.h, 2 * this.h), this.random(-400.0f, -800.0f));
            this.sphere(1.0f);
            this.popMatrix();
            ++n;
        }
        this.pushMatrix();
        this.rotateX(-0.4f);
        this.rotateY((float)this.time * 0.1f);
        n = this.color(36, 160, 255, 70);
        this.fill(n);
        int n2 = this.moonlander.getIntValue("earthR");
        int n3 = this.moonlander.getIntValue("airSize");
        this.textureSphere(n2, n2, n2, this.img);
        this.sphere(n2 + n3);
        this.popMatrix();
        this.camera(0.0f, 0.0f, 1000.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        double d = this.moonlander.getValue("asteroidDist");
        float f = (float)d;
        this.rotateY(trekt.radians((float)60.0f));
        this.pushMatrix();
        this.translate(trekt.cos((float)((float)this.time)) * f, trekt.sin((float)((float)this.time)) * f, 0.0f);
        this.rotateX((float)this.millis() * 0.001f);
        this.scale(2.0f);
        this.shape(this.asteroid, 0.0f, 0.0f);
        this.popMatrix();
        this.translate(0.0f, 0.0f, 400.0f);
        int n4 = this.moonlander.getIntValue("asteroidHit");
        if (n4 > 0) {
            int n5 = this.color(255 - n4, 255 - n4, 255 - n4);
            this.fill(n5);
            this.background(n5);
        }
    }

    public void initializeSphere(int n, int n2) {
        float f;
        this.numPointsW = n + 1;
        this.numPointsH_2pi = n2;
        this.numPointsH = trekt.ceil((float)((float)this.numPointsH_2pi / 2.0f)) + 1;
        this.coorX = new float[this.numPointsW];
        this.coorY = new float[this.numPointsH];
        this.coorZ = new float[this.numPointsW];
        this.multXZ = new float[this.numPointsH];
        int n3 = 0;
        while (n3 < this.numPointsW) {
            f = (float)(n3 * 2) * (float)Math.PI / (float)(this.numPointsW - 1);
            this.coorX[n3] = trekt.sin((float)f);
            this.coorZ[n3] = trekt.cos((float)f);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.numPointsH) {
            if ((float)PApplet.parseInt((float)(this.numPointsH_2pi / 2)) != (float)this.numPointsH_2pi / 2.0f && n3 == this.numPointsH - 1) {
                f = (float)((n3 - 1) * 2) * (float)Math.PI / (float)this.numPointsH_2pi;
                this.coorY[n3] = trekt.cos((float)((float)Math.PI + f));
                this.multXZ[n3] = 0.0f;
            } else {
                f = (float)(n3 * 2) * (float)Math.PI / (float)this.numPointsH_2pi;
                this.coorY[n3] = trekt.cos((float)((float)Math.PI + f));
                this.multXZ[n3] = trekt.sin((float)f);
            }
            ++n3;
        }
    }

    public void drawSpheres() {
        this.lights();
        int n = this.moonlander.getIntValue("box_size");
        int n2 = this.moonlander.getIntValue("distance_center");
        int n3 = this.moonlander.getIntValue("cubes");
        float f = (float)(this.moonlander.getCurrentTime() * 1000.0);
        int n4 = this.moonlander.getIntValue("midSize");
        int n5 = this.moonlander.getIntValue("palloR");
        int n6 = this.moonlander.getIntValue("palloG");
        int n7 = this.moonlander.getIntValue("palloB");
        this.rectMode(3);
        this.camera(trekt.cos((float)(f * 0.001f)) * 400.0f, 0.0f, trekt.sin((float)(f * 0.001f)) * 400.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.noStroke();
        this.fill(0.0f, 0.0f, 255.0f);
        this.sphere((float)n4 * 0.8f);
        this.noStroke();
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < n3) {
            this.pushMatrix();
            int n11 = n;
            if (n3 == 8) {
                n = (int)((float)n / 1.5f);
            }
            if (n3 == 16) {
                n /= 2;
            }
            if (n3 == 32) {
                n = (int)((float)n / 2.6f);
            }
            if (n3 == 74) {
                n = (int)((float)n / 3.2f);
            }
            if (n3 == 100) {
                n *= 2;
            }
            float f2 = (float)Math.PI * 2 / (float)n3;
            float f3 = 0.7853982f;
            float f4 = 0.5235988f;
            if (n3 > 16) {
                f2 = 0.3926991f;
            }
            int n12 = 150;
            int n13 = (int)trekt.sqrt((float)(n12 * n12 - n12 / 2 * (n12 / 2)));
            int n14 = (int)trekt.sqrt((float)(n12 * n12 - n12 / 4 * (n12 / 4)));
            int n15 = (int)trekt.sqrt((float)(n12 * n12 - n12 / 4 * 3 * (n12 / 4 * 3)));
            if (n3 < 54) {
                if (n10 < 16) {
                    this.translate(trekt.cos((float)(f * 0.001f + f2 * (float)n10)) * (float)n12 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f2 * (float)n10)) * (float)n12 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), 0.0f);
                }
                if (n10 > 15) {
                    if (n8 < 8) {
                        this.translate(trekt.cos((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(n12 / 2) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    } else if (n8 > 7) {
                        this.translate(trekt.cos((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(-(n12 / 2)) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    }
                    ++n8;
                }
            } else if (n3 == 74) {
                if (n10 < 16) {
                    this.translate(trekt.cos((float)(f * 0.001f + f2 * (float)n10)) * (float)n12 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f2 * (float)n10)) * (float)n12 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), 0.0f);
                }
                if (n10 > 15 && n10 < 40) {
                    if (n9 < 12) {
                        this.translate(trekt.cos((float)(f * 0.001f + f4 * (float)n10)) * (float)n14 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f4 * (float)n10)) * (float)n14 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(n12 / 4) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    } else if (n9 > 11) {
                        this.translate(trekt.cos((float)(f * 0.001f + f4 * (float)n10)) * (float)n14 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f4 * (float)n10)) * (float)n14 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(-(n12 / 4)) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    }
                    ++n9;
                }
                if (n10 > 39 && n10 < 56) {
                    if (n9 < 31) {
                        this.translate(trekt.cos((float)(f * 0.001f + f3 * (float)n10)) * (float)n13 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f3 * (float)n10)) * (float)n13 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(n12 / 2) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    } else if (n9 > 30) {
                        this.translate(trekt.cos((float)(f * 0.001f + f3 * (float)n10)) * (float)n13 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f3 * (float)n10)) * (float)n13 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(-(n12 / 2)) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    }
                    ++n9;
                }
                if (n10 > 55 && n10 < 72) {
                    if (n9 < 48) {
                        this.translate(trekt.cos((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(n12 / 4 * 3) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    } else if (n9 > 47) {
                        this.translate(trekt.cos((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), trekt.sin((float)(f * 0.001f + f3 * (float)n10)) * (float)n15 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)), (float)(-(n12 / 4 * 3)) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    }
                    ++n9;
                }
                if (n10 > 71) {
                    if (n10 == 72) {
                        this.translate(0.0f, 0.0f, (float)n12 * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    }
                    if (n10 == 73) {
                        this.translate(0.0f, 0.0f, (float)(-n12) * trekt.sin((float)(1.5707964f * (float)n2 / 100.0f)));
                    }
                }
            }
            this.fill(n5, n6, n7);
            this.sphere((float)n * 0.6f);
            n = n11;
            this.popMatrix();
            ++n10;
        }
    }

    public void textureSphere(float f, float f2, float f3, PImage pImage) {
        float f4 = (float)pImage.width / (float)(this.numPointsW - 1);
        float f5 = (float)pImage.height / (float)(this.numPointsH - 1);
        float f6 = 0.0f;
        float f7 = 0.0f;
        this.beginShape(10);
        this.texture(pImage);
        int n = 0;
        while (n < this.numPointsH - 1) {
            float f8 = this.coorY[n];
            float f9 = this.coorY[n + 1];
            float f10 = this.multXZ[n];
            float f11 = this.multXZ[n + 1];
            int n2 = 0;
            while (n2 < this.numPointsW) {
                this.normal(this.coorX[n2] * f10, f8, this.coorZ[n2] * f10);
                this.vertex(this.coorX[n2] * f10 * f, f8 * f2, this.coorZ[n2] * f10 * f3, f6, f7);
                this.normal(this.coorX[n2] * f11, f9, this.coorZ[n2] * f11);
                this.vertex(this.coorX[n2] * f11 * f, f9 * f2, this.coorZ[n2] * f11 * f3, f6, f7 + f5);
                f6 += f4;
                ++n2;
            }
            f7 += f5;
            f6 = 0.0f;
            ++n;
        }
        this.endShape();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "trekt"};
        if (stringArray != null) {
            PApplet.main((String[])trekt.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }
}

