/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.javasound;

import ddf.minim.AudioEffect;
import ddf.minim.AudioListener;
import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.javasound.FloatSampleBuffer;
import ddf.minim.spi.AudioOut;
import ddf.minim.spi.AudioStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.SourceDataLine;

final class JSAudioOutput
extends Thread
implements AudioOut {
    private AudioListener listener;
    private AudioStream stream;
    private AudioSignal signal;
    private AudioEffect effect;
    private SourceDataLine line;
    private AudioFormat format;
    private FloatSampleBuffer buffer;
    private MultiChannelBuffer mcBuffer;
    private int bufferSize;
    private boolean finished;
    private byte[] outBytes;

    JSAudioOutput(SourceDataLine sourceDataLine, int n) {
        this.bufferSize = n;
        this.format = sourceDataLine.getFormat();
        this.buffer = new FloatSampleBuffer(this.format.getChannels(), n, this.format.getSampleRate());
        this.mcBuffer = new MultiChannelBuffer(n, this.format.getChannels());
        this.outBytes = new byte[this.buffer.getByteArrayBufferSize(this.format)];
        this.finished = false;
        this.line = sourceDataLine;
    }

    @Override
    public void run() {
        this.line.start();
        while (!this.finished) {
            this.buffer.makeSilence();
            if (this.signal != null) {
                this.readSignal();
            } else if (this.stream != null) {
                this.readStream();
            }
            if (this.line.getFormat().getChannels() == 1) {
                this.effect.process(this.buffer.getChannel(0));
                this.listener.samples(this.buffer.getChannel(0));
            } else {
                this.effect.process(this.buffer.getChannel(0), this.buffer.getChannel(1));
                this.listener.samples(this.buffer.getChannel(0), this.buffer.getChannel(1));
            }
            this.buffer.convertToByteArray(this.outBytes, 0, this.format);
            if (this.line.available() == this.line.getBufferSize()) {
                Minim.debug((String)"Likely buffer underrun in AudioOutput.");
            }
            this.line.write(this.outBytes, 0, this.outBytes.length);
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.line.drain();
        this.line.stop();
        this.line.close();
        this.line = null;
    }

    private void readSignal() {
        if (this.line.getFormat().getChannels() == 1) {
            this.signal.generate(this.buffer.getChannel(0));
        } else {
            this.signal.generate(this.buffer.getChannel(0), this.buffer.getChannel(1));
        }
    }

    private void readStream() {
        this.stream.read(this.mcBuffer);
        for (int i = 0; i < this.mcBuffer.getChannelCount(); ++i) {
            System.arraycopy(this.mcBuffer.getChannel(i), 0, this.buffer.getChannel(i), 0, this.buffer.getSampleCount());
        }
    }

    public void open() {
        this.start();
    }

    public void close() {
        this.finished = true;
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public void setAudioEffect(AudioEffect audioEffect) {
        this.effect = audioEffect;
    }

    public void setAudioSignal(AudioSignal audioSignal) {
        this.signal = audioSignal;
    }

    public void setAudioListener(AudioListener audioListener) {
        this.listener = audioListener;
    }

    public Control[] getControls() {
        return this.line.getControls();
    }

    public void setAudioStream(AudioStream audioStream) {
        this.stream = audioStream;
    }
}

