/*
 * Decompiled with CFR 0.152.
 */
package sun.org.mozilla.javascript.internal;

import java.lang.reflect.Method;
import sun.org.mozilla.javascript.internal.Callable;
import sun.org.mozilla.javascript.internal.Context;
import sun.org.mozilla.javascript.internal.ContextAction;
import sun.org.mozilla.javascript.internal.ContextFactory;
import sun.org.mozilla.javascript.internal.Function;
import sun.org.mozilla.javascript.internal.ScriptRuntime;
import sun.org.mozilla.javascript.internal.Scriptable;
import sun.org.mozilla.javascript.internal.ScriptableObject;
import sun.org.mozilla.javascript.internal.VMBridge;
import sun.org.mozilla.javascript.internal.WrapFactory;
import sun.org.mozilla.javascript.internal.Wrapper;

public class InterfaceAdapter {
    private final Object proxyHelper;

    static Object create(Context context, Class<?> clazz, Callable callable) {
        Object object;
        Object object2;
        boolean bl;
        Method[] methodArray;
        block9: {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException();
            }
            methodArray = clazz.getMethods();
            if (methodArray.length == 0) {
                throw Context.reportRuntimeError2("msg.no.empty.interface.conversion", String.valueOf(callable), clazz.getClass().getName());
            }
            bl = false;
            object2 = methodArray[0].getParameterTypes();
            for (int i = 1; i != methodArray.length; ++i) {
                object = methodArray[i].getParameterTypes();
                if (((Class<?>[])object).length != ((Class<?>[])object2).length) break block9;
                for (int j = 0; j != ((Class<?>[])object2).length; ++j) {
                    if (object[j] == object2[j]) {
                        continue;
                    }
                    break block9;
                }
            }
            bl = true;
        }
        if (!bl) {
            throw Context.reportRuntimeError2("msg.no.function.interface.conversion", String.valueOf(callable), clazz.getClass().getName());
        }
        object2 = ScriptRuntime.getTopCallScope(context);
        Object object3 = ScriptableObject.getProperty(object2, "JavaAdapter");
        if (object3 != Scriptable.NOT_FOUND) {
            Object object4;
            object = (Function)object3;
            Scriptable scriptable = ScriptRuntime.newObject(context, object2, "Object", new Object[0]);
            for (int i = 0; i < methodArray.length; ++i) {
                object4 = methodArray[i].getName();
                ScriptableObject.putProperty(scriptable, (String)object4, (Object)callable);
            }
            Object[] objectArray = new Object[]{clazz, scriptable};
            object4 = object.construct(context, (Scriptable)object2, objectArray);
            if (object4 instanceof Wrapper) {
                object4 = ((Wrapper)object4).unwrap();
            }
            return object4;
        }
        throw Context.reportRuntimeError2("msg.conversion.not.allowed", String.valueOf(callable), clazz.getName());
    }

    private InterfaceAdapter(ContextFactory contextFactory, Class<?> clazz) {
        this.proxyHelper = VMBridge.instance.getInterfaceProxyHelper(contextFactory, new Class[]{clazz});
    }

    public Object invoke(ContextFactory contextFactory, final Object object, final Scriptable scriptable, final Method method, final Object[] objectArray) {
        ContextAction contextAction = new ContextAction(){

            @Override
            public Object run(Context context) {
                return InterfaceAdapter.this.invokeImpl(context, object, scriptable, method, objectArray);
            }
        };
        return contextFactory.call(contextAction);
    }

    Object invokeImpl(Context context, Object object, Scriptable scriptable, Method method, Object[] objectArray) {
        Object object2;
        int n = objectArray == null ? 0 : objectArray.length;
        Callable callable = (Callable)object;
        Scriptable scriptable2 = scriptable;
        Object[] objectArray2 = new Object[n + 1];
        objectArray2[n] = method.getName();
        if (n != 0) {
            object2 = context.getWrapFactory();
            for (int i = 0; i != n; ++i) {
                objectArray2[i] = ((WrapFactory)object2).wrap(context, scriptable, objectArray[i], null);
            }
        }
        object2 = callable.call(context, scriptable, scriptable2, objectArray2);
        Class<?> clazz = method.getReturnType();
        object2 = clazz == Void.TYPE ? null : Context.jsToJava(object2, clazz);
        return object2;
    }
}

