import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.spi.*; 
import ddf.minim.signals.*; 
import ddf.minim.*; 
import ddf.minim.analysis.*; 
import ddf.minim.ugens.*; 
import ddf.minim.effects.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class odyssey extends PApplet {










int CANVAS_WIDTH = 1280;
int CANVAS_HEIGHT = 720;

Moonlander moonlander;
AudioPlayer song;

PImage skeletor;
PImage texmap;
PShader blur;

Intro intro;
Sperm sperm;
Tree tree;
Camera camera;
Black_hole black_hole;


int phase;
int beat;

public void setup() 
{
  
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
  blur = loadShader("blurts.glsl"); 
  frameRate(50);
  
  intro = new Intro();
  tree = new Tree();
  sperm = new Sperm();
  camera = new Camera();
  black_hole = new Black_hole();
  
  skeletor = loadImage("Skeletor.png");
  
  moonlander = Moonlander.initWithSoundtrack(this, "skeletor.mp3", 140, 4);
  moonlander.start();
  
}

public void draw() 
{
  moonlander.update();
  phase = moonlander.getIntValue("phase");
  beat = moonlander.getIntValue("beat");
  
  noStroke();
  if(phase == 1) 
  {
    intro.play();
  }
  
  if(phase >= 2 && phase < 10)
  {
    camera.orbit();
    sperm.play();
  }
  if(phase == 99)
  {
    tint(50);
    background(0);
    
  }
  if(phase == 10)
  {
      camera.zoom();
      pointLight(255,255,255, 0,500,500);
      black_hole.play(); 
  }
  if(phase == 20)
  {
    camera.zoom();
    tree.play();
  }
  if(phase == 100)
  {
    exit();
  }
  lights();

}
class Black_hole
{
  
  Black_hole()
  {  
    
  } 
  public void play()
  {
    background(0);
    pushMatrix();
    for (float r=1; r < 100;r += 2)
    {
      fill(r*20,5);
      if (beat==3)
      {
        noFill();
        stroke(180);
      }
      sphere(r);
      translate(0,0,r/20);
    }
    //filter(BLUR,2);
    popMatrix();
    
  }
}

class Camera 
{
  float rotation= 0;
  float ypos= 0;
  float xpos= 0;
  float zpos= 0;
  float count = 0;
  float zoom = 0;
    
  Camera()
  {
  }
  
  public void orbit()
  {
    float orbitRadius= 300;
    float ypos= 0;
    float xpos= cos(radians(rotation))*orbitRadius;
    float zpos= sin(radians(rotation))*orbitRadius;
    
    camera(xpos, ypos, zpos, 0, 0, 0, 0, -1, 0);
    rotation++;
  }
  public void stay()
  {
    float orbitRadius= 300;
    float ypos= 0;
    float xpos= 0;
    float zpos= orbitRadius;
    
    camera(xpos, ypos, zpos, 0, 0, 0, 0, -1, 0);
  }
  public void zorbit()
  {
    float orbitRadius= 200;
    float ypos= 0;
    float xpos= cos(radians(rotation))*(orbitRadius-count);
    float zpos= sin(radians(rotation))*(orbitRadius-count);
    count++;
    camera(xpos, ypos, zpos, 0, 0, 0, 0, rotation, 0);
    rotation++;
  }
   public void zoom()
  {
    float orbitRadius= 300;
    float ypos= 0;
    float xpos= 0;
    float zpos= orbitRadius-zoom;
    camera(xpos, ypos, zpos, 0, 0, 0, 0, -rotation, 0);
    zoom++;
    rotation++;

  }
}
class Intro
{
  float counter = 2;
  float vallue = 1;
  
  
  Intro()
  {
  }
  public void play()
  {
     background(0);

   vallue += counter;
   pushMatrix();
   
   tint(vallue);
   image(skeletor, CANVAS_WIDTH/2-436/4, CANVAS_HEIGHT/2-522/4,436/2, 522/2);
   filter(GRAY);
   if(vallue==255)
   counter = -2;
   if(vallue==0)
   counter = 0;
   popMatrix();
    
  }
}

class Sperm
{
  float[] coord = new float[200*3];
  Sperm()
  {
     for(int i = 0; i < coord.length; i++)
     {
       coord[i] = 0;
       background(0);
     }
  }
public void grow(float clr)
{
  pushMatrix();
  for(int i = 0; i < coord.length; i += 3)
  {
    pushMatrix();
    
    fill(10+(i%50));
    if (clr == 1)
      fill(100+(i%50));
    if (clr == 2)
    fill(150+(i%50));
    if (clr == 3)
      fill(200+(i%50));
    
    for(int j = 0; j < 3; j++)
    {
      //if (coord[i+j] > 50)
       // coord[i+j] = 0;
      
      coord[i+j] += random(-1,1);
    }
    translate(coord[i],coord[i+1],coord[i+2]);
    
    if (beat == 2)
        fill(30); 
    sphere(1); 
    popMatrix();
  }
  popMatrix();

}
public void explode()
{
  pushMatrix();
  for(int i = 0; i < coord.length; i += 3)
  {
    for(int j = 0; j < 3; j++)
    {
      coord[i+j] += coord[i+j] /50;
    }
     translate(coord[i],coord[i+1],coord[i+2]);
  }
  popMatrix();
}

public void play()
{
  if (phase == 2 || phase == 3)
  {
    grow(0);
    if (phase == 3)
     explode();
  }
  if(phase == 4)//clear
  {
    //background(0); 
    for(int i = 0; i < coord.length; i++)
    
       coord[i] = 0;
  }
  if(phase == 8)//clear
  {
    background(0); 
    for(int i = 0; i < coord.length; i++)
    
       coord[i] = 0;
  }
  if (phase == 5)
  {
    grow(1);
    explode();
  }
  if (phase == 6)
  {
    grow(2);
    explode();
  }
  if (phase == 7)
  {
    pushMatrix();
    translate(-100,0,0);
    grow(1);
    explode();
    popMatrix();
    pushMatrix();
    translate(100,0,0);
    grow(2);
    explode();
    popMatrix();
  }
  
  if (phase == 9)
  {
    pushMatrix();
    translate(0,100,0);
    grow(1);
    explode();
    popMatrix();
    
    pushMatrix();
    translate(0,0,100);
    grow(2);
    explode();
    popMatrix();
    
    pushMatrix();
    translate(100,0,0);
    grow(3);
    explode();
    popMatrix();
    
  }
  
  
}
}


class Tree
{
  float h = 180;
  float c = 0;
  float d = 255;
  float[] coord = new float[600*3];
  Tree()
  {
    for(int i = 0; i < coord.length; i++)
     {
       coord[i] = 0;
       background(0);
     }
  }
  
  public void grow(float clr)
{
  noStroke();
  pushMatrix();
  for(int i = 0; i < coord.length; i += 3)
  {
    pushMatrix();
    
    fill(100+(i%50));
    for(int j = 0; j < 3; j++)
        coord[i+j] += random(-2,2);
    for(int x = 0; x < 3; x++)
      coord[i+x] += (coord[i+x] % 3);
    translate(coord[i],coord[i+1],coord[i+2]);
    sphere(1);
    
    popMatrix();
  }
  popMatrix();

}
  
  public void play()
  {
    //background(0);
    if (h == 180)
      c = -3;
    if (h == 0)
       c = 0;
    h += c;
    fill(h);
    sphere(65);
    grow(0);
  }
}


  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--hide-stop", "odyssey" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
