/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PShape;

public class NoHome
extends PApplet {
    Moonlander moonlander;
    public int WIDTH = 1280;
    public int HEIGHT = 720;
    public int horizonBonus = 0;
    public Random rand = new Random();
    public Ball B0 = new Ball(0);
    public Cloud Cl0 = new Cloud(0);
    public Road R0 = new Road(0);
    public Road R1 = new Road(1);
    public Road R2 = new Road(2);
    public Road R3 = new Road(3);
    public Road R4 = new Road(4);
    public Road R5 = new Road(5);
    public Road R6 = new Road(6);
    public Road R7 = new Road(7);
    public Road R8 = new Road(8);
    public Road R9 = new Road(9);
    public Road R10 = new Road(10);
    public Road R11 = new Road(11);
    public Road R12 = new Road(12);
    public Road R13 = new Road(13);
    public Road R14 = new Road(14);
    public Road R15 = new Road(15);
    public Road R16 = new Road(16);
    public Road R17 = new Road(17);
    public Road R18 = new Road(18);
    public Road R19 = new Road(19);
    public Cactus C1 = new Cactus(6);
    public Cactus C2 = new Cactus(13);
    public Cactus C3 = new Cactus(18);

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"Cullah_-_No_Home.mp3", (int)51, (int)8);
        this.size(this.WIDTH, this.HEIGHT, "processing.opengl.PGraphics2D");
        this.moonlander.start();
    }

    public void drawGround() {
        this.rectMode(1);
        this.stroke(220.0f, 100.0f, 45.0f);
        this.fill(220.0f, 100.0f, 45.0f);
        this.rect(0.0f, this.HEIGHT / 2 + this.horizonBonus, this.WIDTH, this.HEIGHT);
        this.stroke(200.0f, 80.0f, 25.0f);
        this.fill(200.0f, 80.0f, 25.0f);
        this.quad(this.WIDTH / 2 - 10, this.HEIGHT / 2 + this.horizonBonus, this.WIDTH / 2 + 10, this.HEIGHT / 2 + this.horizonBonus, this.WIDTH / 2 + 20, this.HEIGHT, this.WIDTH / 2 - 20, this.HEIGHT);
        Iterator<Road> iterator = this.roadList().iterator();
        while (iterator.hasNext()) {
            iterator.next().draw();
        }
    }

    public void drawCity() {
        double d = 0.0;
        if (this.dayTime() >= (double)0.7f) {
            d += 1.0;
        }
        if (this.dayTime() >= (double)0.7f) {
            this.beginShape();
            this.fill(249.0f, 249.0f, 115.0f);
            this.vertex(100.0f, this.HEIGHT / 2 + 250);
            this.fill(this.bColor());
            this.vertex((int)d + 150, 0.0f);
            this.vertex((int)d + 230, 0.0f);
            this.endShape();
            this.beginShape();
            this.fill(249.0f, 249.0f, 80.0f);
            this.vertex(200.0f, this.HEIGHT / 2 + 250);
            this.fill(this.bColor());
            this.vertex((int)d + 350, 0.0f);
            this.vertex((int)d + 430, 0.0f);
            this.endShape();
            this.beginShape();
            this.fill(249.0f, 249.0f, 115.0f);
            this.vertex(20.0f, this.HEIGHT / 2 + 250);
            this.fill(this.bColor());
            this.vertex((int)d + 810, 0.0f);
            this.vertex((int)d + 930, 0.0f);
            this.endShape();
        }
        this.noStroke();
        this.fill(104.0f, 9.0f, 12.0f);
        this.rect(10.0f, this.HEIGHT / 2 - 20, 50.0f, 50.0f);
        this.fill(7.0f, 87.0f, 79.0f);
        this.rect(63.0f, this.HEIGHT / 2 - 30, 70.0f, 50.0f);
        this.fill(87.0f, 47.0f, 7.0f);
        this.rect(136.0f, this.HEIGHT / 2 - 15, 40.0f, 50.0f);
        this.fill(58.0f, 2.0f, 49.0f);
        this.rect(180.0f, this.HEIGHT / 2 - 40, 30.0f, 50.0f);
        this.fill(36.0f, 90.0f, 30.0f);
        this.rect(213.0f, this.HEIGHT / 2 - 10, 70.0f, 50.0f);
        this.fill(177.0f, 181.0f, 85.0f);
        this.rect(285.0f, this.HEIGHT / 2 - 100, 20.0f, 150.0f);
        this.fill(215.0f, 123.0f, 243.0f);
        this.rect(310.0f, this.HEIGHT / 2 - 35, 50.0f, 50.0f);
        this.fill(243.0f, 123.0f, 159.0f);
        this.rect(362.0f, this.HEIGHT / 2 - 45, 75.0f, 50.0f);
        this.fill(198.0f, 255.0f, 217.0f);
        this.rect(820.0f, this.HEIGHT / 2 - 25, 50.0f, 50.0f);
        this.fill(252.0f, 241.0f, 204.0f);
        this.rect(873.0f, this.HEIGHT / 2 - 35, 40.0f, 50.0f);
        this.fill(204.0f, 252.0f, 234.0f);
        this.rect(920.0f, this.HEIGHT / 2 - 55, 40.0f, 70.0f);
        this.fill(252.0f, 204.0f, 204.0f);
        this.rect(963.0f, this.HEIGHT / 2 - 15, 70.0f, 50.0f);
        this.fill(236.0f, 252.0f, 204.0f);
        this.rect(1035.0f, this.HEIGHT / 2 - 65, 20.0f, 90.0f);
        this.fill(204.0f, 207.0f, 252.0f);
        this.rect(1060.0f, this.HEIGHT / 2 - 25, 40.0f, 50.0f);
        this.fill(230.0f, 204.0f, 252.0f);
        this.rect(1105.0f, this.HEIGHT / 2 - 30, 30.0f, 50.0f);
        this.fill(195.0f, 255.0f, 155.0f);
        this.rect(1139.0f, this.HEIGHT / 2 - 45, 65.0f, 50.0f);
        this.fill(255.0f, 216.0f, 155.0f);
        this.rect(1207.0f, this.HEIGHT / 2 - 30, 55.0f, 50.0f);
        this.stroke(180.0f, 255.0f, 255.0f);
        this.fill(180.0f, 255.0f, 255.0f);
        this.ellipse(25.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(45.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(80.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(100.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(120.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(80.0f, this.HEIGHT / 2 - 18, 5.0f, 3.0f);
        this.ellipse(100.0f, this.HEIGHT / 2 - 18, 5.0f, 3.0f);
        this.ellipse(120.0f, this.HEIGHT / 2 - 18, 5.0f, 3.0f);
        this.ellipse(145.0f, this.HEIGHT / 2 - 5, 5.0f, 3.0f);
        this.ellipse(165.0f, this.HEIGHT / 2 - 5, 5.0f, 3.0f);
        this.ellipse(187.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(203.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(187.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(203.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(225.0f, this.HEIGHT / 2 - 5, 5.0f, 3.0f);
        this.ellipse(240.0f, this.HEIGHT / 2 - 5, 5.0f, 3.0f);
        this.ellipse(255.0f, this.HEIGHT / 2 - 5, 5.0f, 3.0f);
        this.ellipse(270.0f, this.HEIGHT / 2 - 5, 5.0f, 3.0f);
        this.ellipse(290.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(300.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(290.0f, this.HEIGHT / 2 - 25, 5.0f, 3.0f);
        this.ellipse(300.0f, this.HEIGHT / 2 - 25, 5.0f, 3.0f);
        this.ellipse(290.0f, this.HEIGHT / 2 - 40, 5.0f, 3.0f);
        this.ellipse(300.0f, this.HEIGHT / 2 - 40, 5.0f, 3.0f);
        this.ellipse(290.0f, this.HEIGHT / 2 - 55, 5.0f, 3.0f);
        this.ellipse(300.0f, this.HEIGHT / 2 - 55, 5.0f, 3.0f);
        this.ellipse(290.0f, this.HEIGHT / 2 - 70, 5.0f, 3.0f);
        this.ellipse(300.0f, this.HEIGHT / 2 - 70, 5.0f, 3.0f);
        this.ellipse(290.0f, this.HEIGHT / 2 - 85, 5.0f, 3.0f);
        this.ellipse(300.0f, this.HEIGHT / 2 - 85, 5.0f, 3.0f);
        this.ellipse(320.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(335.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(350.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(320.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(335.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(350.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(375.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(390.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(405.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(420.0f, this.HEIGHT / 2 - 10, 5.0f, 3.0f);
        this.ellipse(375.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(390.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(405.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(420.0f, this.HEIGHT / 2 - 20, 5.0f, 3.0f);
        this.ellipse(375.0f, this.HEIGHT / 2 - 30, 5.0f, 3.0f);
        this.ellipse(390.0f, this.HEIGHT / 2 - 30, 5.0f, 3.0f);
        this.ellipse(405.0f, this.HEIGHT / 2 - 30, 5.0f, 3.0f);
        this.ellipse(420.0f, this.HEIGHT / 2 - 30, 5.0f, 3.0f);
    }

    public void drawCactuses() {
        Iterator<Cactus> iterator = this.cactusList().iterator();
        while (iterator.hasNext()) {
            iterator.next().draw();
        }
    }

    public void drawBall() {
        this.B0.draw();
    }

    public void drawClouds() {
        this.Cl0.draw();
    }

    public int bColor() {
        return this.lerpColor(this.color(150, 235, 235), this.color(15, 30, 75), (float)this.dayTime());
    }

    public void drawSky() {
        this.background(this.bColor());
        float f = 0.0f;
        float f2 = 0.0f;
        this.resetMatrix();
        this.translate(this.WIDTH / 2, this.HEIGHT / 2);
        float f3 = (float)(-this.moonlander.getCurrentTime() / 10.0 + 4.71238899230957);
        this.fill(255.0f, 255.0f, 0.0f);
        f = NoHome.cos((float)f3) * (float)this.WIDTH / 3.0f;
        f2 = NoHome.sin((float)f3) * (float)this.HEIGHT / 3.0f;
        this.ellipse(f, f2, 100.0f, 100.0f);
        f3 = (float)(-this.moonlander.getCurrentTime() / 10.0 + 1.5707963705062866);
        this.fill(255.0f, 255.0f, 200.0f);
        f = NoHome.cos((float)f3) * (float)this.WIDTH / 3.0f;
        f2 = NoHome.sin((float)f3) * (float)this.HEIGHT / 3.0f;
        this.ellipse(f, f2, 50.0f, 50.0f);
        this.fill(this.bColor());
        this.ellipse(f - 8.0f, f2 - 5.0f, 52.0f, 52.0f);
        this.resetMatrix();
    }

    public double dayTime() {
        double d = this.moonlander.getCurrentTime() % 60.0;
        if (d <= 30.0) {
            return d / 30.0;
        }
        return (60.0 - d) / 30.0;
    }

    public void draw() {
        this.moonlander.update();
        this.horizonBonus = this.moonlander.getIntValue("horizonBonus") - 10;
        this.drawSky();
        this.drawCity();
        this.drawGround();
        this.drawBall();
        this.drawCactuses();
        this.drawClouds();
    }

    public List<Cactus> cactusList() {
        ArrayList<Cactus> arrayList = new ArrayList<Cactus>();
        arrayList.add(this.C1);
        arrayList.add(this.C2);
        arrayList.add(this.C3);
        Collections.sort(arrayList);
        return arrayList;
    }

    public List<Road> roadList() {
        ArrayList<Road> arrayList = new ArrayList<Road>();
        arrayList.add(this.R0);
        arrayList.add(this.R1);
        arrayList.add(this.R2);
        arrayList.add(this.R3);
        arrayList.add(this.R4);
        arrayList.add(this.R5);
        arrayList.add(this.R6);
        arrayList.add(this.R7);
        arrayList.add(this.R8);
        arrayList.add(this.R9);
        arrayList.add(this.R10);
        arrayList.add(this.R11);
        arrayList.add(this.R12);
        arrayList.add(this.R13);
        arrayList.add(this.R14);
        arrayList.add(this.R15);
        arrayList.add(this.R16);
        arrayList.add(this.R17);
        arrayList.add(this.R18);
        arrayList.add(this.R19);
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "NoHome"};
        if (stringArray != null) {
            PApplet.main((String[])NoHome.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    public class Ball {
        int x = 0;
        int oldy;
        double newy;
        int radius;

        public Ball(int n) {
            this.oldy = NoHome.this.HEIGHT * 3 / 4;
            this.newy = this.oldy;
            this.radius = 50;
        }

        public void draw() {
            if (this.x < NoHome.this.WIDTH + this.radius) {
                ++this.x;
                this.newy += 0.25;
            } else {
                this.x = -this.radius / 2;
                this.newy = this.newy >= (double)(NoHome.this.HEIGHT - 80) ? (double)(NoHome.this.HEIGHT / 2 + 100) : (this.newy += 50.0);
            }
            NoHome.this.fill(184.0f, 171.0f, 3.0f);
            NoHome.this.ellipse(this.x, (float)((int)this.newy) - NoHome.abs((float)NoHome.sin((float)((float)NoHome.this.millis() * (0.005f * NoHome.sin((float)15.0f))))) * 10.0f, this.radius, this.radius);
        }
    }

    public class Cactus
    implements Comparator<Cactus>,
    Comparable<Cactus> {
        PShape c;
        int x;
        int y;
        int size;
        int oldY;
        int bx;
        int leftBonus;
        int rightBonus;
        public int startY;
        boolean right;
        int co;
        float sizeBonus;

        public Cactus(int n) {
            this.right = NoHome.this.rand.nextBoolean();
            this.x = 0;
            this.y = 0;
            this.size = 0;
            this.oldY = this.y;
            this.startY = n;
            this.bx = 100 + NoHome.this.rand.nextInt(200);
            this.co = this.randColor();
            this.sizeBonus = 0.8f + NoHome.this.rand.nextFloat() * 0.4f;
            this.leftBonus = NoHome.this.rand.nextInt(21) - 10;
            this.rightBonus = NoHome.this.rand.nextInt(21) - 10;
        }

        public int randColor() {
            int n = NoHome.this.rand.nextInt(100);
            return NoHome.this.color(NoHome.this.rand.nextInt(50) + n, NoHome.this.rand.nextInt(100) + n + 55, NoHome.this.rand.nextInt(50) + n);
        }

        public int getY() {
            return (int)(((double)this.startY + NoHome.this.moonlander.getCurrentTime()) % 20.0 * 20.0);
        }

        public int getX() {
            int n = (int)(40.0 * (((double)this.startY + NoHome.this.moonlander.getCurrentTime()) % 20.0) + (double)this.bx);
            if (this.right) {
                return n;
            }
            return -n;
        }

        @Override
        public int compareTo(Cactus cactus) {
            return Integer.compare(this.getY(), cactus.getY());
        }

        @Override
        public int compare(Cactus cactus, Cactus cactus2) {
            return cactus.getY() - cactus2.getY();
        }

        public void draw() {
            if (this.oldY > this.getY()) {
                this.right = NoHome.this.rand.nextBoolean();
                this.co = this.randColor();
                this.bx = 100 + NoHome.this.rand.nextInt(200);
                this.sizeBonus = 0.8f + NoHome.this.rand.nextFloat() * 0.4f;
                this.leftBonus = NoHome.this.rand.nextInt(21) - 10;
                this.rightBonus = NoHome.this.rand.nextInt(21) - 10;
            }
            this.oldY = this.getY();
            NoHome.this.resetMatrix();
            NoHome.this.translate(0 + NoHome.this.WIDTH / 2 + this.getX(), this.getY() + NoHome.this.HEIGHT / 2 + NoHome.this.horizonBonus);
            NoHome.this.scale((float)(((double)this.startY + NoHome.this.moonlander.getCurrentTime()) % 20.0) * this.sizeBonus / 5.0f);
            NoHome.this.stroke(0.0f, 0.0f, 0.0f);
            NoHome.this.fill(this.co);
            NoHome.this.beginShape();
            NoHome.this.curveVertex(this.x, this.y);
            NoHome.this.curveVertex(this.x - 10, this.y);
            NoHome.this.curveVertex(this.x - 15, this.y - 40 + this.leftBonus);
            NoHome.this.curveVertex(this.x - 55, this.y - 50 + this.leftBonus);
            NoHome.this.curveVertex(this.x - 60, this.y - 85 + this.leftBonus);
            NoHome.this.curveVertex(this.x - 40, this.y - 90 + this.leftBonus);
            NoHome.this.curveVertex(this.x - 35, this.y - 65 + this.leftBonus);
            NoHome.this.curveVertex(this.x - 15, this.y - 70 + this.leftBonus);
            NoHome.this.curveVertex(this.x - 10, this.y - 130);
            NoHome.this.curveVertex(this.x + 10, this.y - 130);
            NoHome.this.curveVertex(this.x + 15, this.y - 70 + this.rightBonus);
            NoHome.this.curveVertex(this.x + 35, this.y - 65 + this.rightBonus);
            NoHome.this.curveVertex(this.x + 40, this.y - 90 + this.rightBonus);
            NoHome.this.curveVertex(this.x + 60, this.y - 85 + this.rightBonus);
            NoHome.this.curveVertex(this.x + 55, this.y - 50 + this.rightBonus);
            NoHome.this.curveVertex(this.x + 15, this.y - 40 + this.rightBonus);
            NoHome.this.curveVertex(this.x + 10, this.y);
            NoHome.this.curveVertex(this.x, this.y);
            NoHome.this.endShape();
            NoHome.this.resetMatrix();
        }
    }

    public class Cloud {
        double x = 0.0;
        int cloudy;
        int newcloudy = this.cloudy = 100;
        int size1;
        int size2;
        int size3;

        public Cloud(int n) {
        }

        public void draw() {
            if (this.x < (double)(NoHome.this.WIDTH + 800)) {
                this.x += (double)0.15f;
            } else {
                this.x = 0.0;
                this.size1 = NoHome.this.rand.nextInt(10) + 15;
                this.size2 = NoHome.this.rand.nextInt(10) + 10;
                this.size3 = NoHome.this.rand.nextInt(10) + 25;
            }
            NoHome.this.noStroke();
            NoHome.this.fill(255.0f, 255.0f, 255.0f);
            NoHome.this.ellipse((int)this.x, this.cloudy, 130.0f, 80.0f);
            NoHome.this.ellipse((int)this.x + 20, this.cloudy + this.size1, 110.0f, 60.0f);
            NoHome.this.ellipse((int)this.x - 30, this.cloudy - this.size1, 160.0f, 80.0f);
            NoHome.this.ellipse((int)this.x - 330, this.cloudy, 160.0f, 50.0f);
            NoHome.this.ellipse((int)this.x - 350, this.cloudy + this.size2, 110.0f, 70.0f);
            NoHome.this.ellipse((int)this.x - 360, this.cloudy - this.size2, 170.0f, 40.0f);
            NoHome.this.ellipse((int)this.x - 760, this.cloudy, 100.0f, 50.0f);
            NoHome.this.ellipse((int)this.x - 770, this.cloudy + this.size3, 170.0f, 40.0f);
            NoHome.this.ellipse((int)this.x - 780, this.cloudy - this.size3, 130.0f, 60.0f);
        }
    }

    public class Road {
        int x;
        int y;
        int width;
        int oldY;
        int c1;
        int c2;
        int c3;
        int c4;

        public Road(int n) {
            this.x = NoHome.this.rand.nextInt(10);
            this.y = n;
            this.width = NoHome.this.rand.nextInt(5) + 30;
            this.c1 = NoHome.this.rand.nextInt(20) + 25;
            this.c2 = NoHome.this.rand.nextInt(20) + 25;
            this.c3 = NoHome.this.rand.nextInt(20) + 25;
            this.c4 = NoHome.this.rand.nextInt(20) + 25;
        }

        public int getWidth() {
            return (int)((double)this.width * ((NoHome.this.moonlander.getCurrentTime() + (double)this.y) / 20.0 % 1.0) * 20.0);
        }

        public int getY() {
            return (int)((double)(NoHome.this.HEIGHT / 2) * ((NoHome.this.moonlander.getCurrentTime() + (double)this.y) / 20.0 % 1.0));
        }

        public void draw() {
            if (this.oldY > this.getY()) {
                this.x = NoHome.this.rand.nextInt(7);
                this.width = NoHome.this.rand.nextInt(5) + 30;
                this.c1 = NoHome.this.rand.nextInt(20) + 25;
                this.c2 = NoHome.this.rand.nextInt(20) + 25;
                this.c3 = NoHome.this.rand.nextInt(20) + 25;
                this.c4 = NoHome.this.rand.nextInt(20) + 25;
            }
            this.oldY = this.getY();
            NoHome.this.rectMode(0);
            NoHome.this.stroke(200.0f, 80.0f, 25.0f);
            NoHome.this.fill(200.0f, 80.0f, 25.0f);
            NoHome.this.rect(NoHome.this.WIDTH / 2 + this.x - 3 - this.getWidth() / 2, NoHome.this.HEIGHT / 2 + NoHome.this.horizonBonus + this.getY(), this.getWidth(), 50.0f, this.c1, this.c2, this.c3, this.c4);
        }
    }
}

