/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.data.FloatList;

public class ineiros
extends PApplet {
    Moonlander moonlander;
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    float magicX = 935.5f;
    float ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
    PGraphics titleSurface;
    PFont mono;
    String[] textLines;
    int textHeight = 36;
    int spacing = this.textHeight + 26;
    int magic = 20;
    static final int singStart = 516;
    float row = 0.0f;
    float alpha = 1.0f;
    float rho = 28.0f;
    float sigma = 10.0f;
    float beta = 2.67f;
    float scale = 5.0f;
    float previousT = 0.0f;
    int nParticles = 4096;
    float[][] pos;
    ArrayList lines;
    int age = 0;
    float lastReset = 0.0f;
    int scroll = 0;
    float textScroll = 0.0f;

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"kuroshio-hacked-nasty-cut.mp3", (int)130, (int)8);
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.frameRate(60.0f);
        this.rectMode(3);
        this.mono = this.loadFont("AndaleMono-36.vlw");
        this.initPos();
        this.titleSurface = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.g.textFont(this.mono);
        this.textLines = this.loadStrings("scroller.txt");
        this.moonlander.start();
    }

    public void drawTitle(PGraphics pGraphics) {
        if (this.g != pGraphics) {
            pGraphics.beginDraw();
        }
        pGraphics.textSize((float)this.textHeight);
        pGraphics.pushMatrix();
        pGraphics.resetMatrix();
        pGraphics.translate(0.0f, 0.0f, -this.magicX);
        pGraphics.fill(255);
        pGraphics.text("Music by Kuroshio: Hacked (Nasty Cut)", (float)(-this.width) / 2.0f, (float)(this.height / 2 - this.spacing), 0.0f);
        pGraphics.popMatrix();
        if (this.g != pGraphics) {
            pGraphics.endDraw();
        }
    }

    public void draw() {
        this.moonlander.update();
        this.background(0.0f, 0.0f, 0.0f);
        this.moonlander.getValue("beat");
        float f = (float)this.moonlander.getValue("camera");
        float f2 = (float)this.moonlander.getValue("jitter");
        this.row = (float)this.moonlander.getCurrentRow();
        if (this.row < 3100.0f) {
            this.camera(f, f, f, 0.0f + this.randomValue2(f2), 0.0f + this.randomValue2(f2), 150.0f + this.randomValue2(f2), 0.0f, 1.0f, 0.0f);
            if (this.row < 200.0f) {
                this.drawTitle(this.g);
            }
            this.attractor();
            if (this.row > 1900.0f) {
                if (this.row == 1901.0f) {
                    this.textScroll = 0.0f;
                }
                this.drawTextScroll(this.g);
            }
            this.alpha = (float)this.moonlander.getValue("alpha");
        } else if (this.row < 3496.0f) {
            this.lights();
            this.camera(f, -f, f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            this.drawCube(this.g);
        } else {
            this.exit();
        }
    }

    public float t() {
        return (float)this.moonlander.getCurrentTime();
    }

    public void initPos() {
        this.pos = new float[this.nParticles][4];
        int n = 0;
        while (n < this.nParticles) {
            this.initParticle(n);
            ++n;
        }
        this.precalc();
        this.lines = new ArrayList();
    }

    public void precalc() {
        float f = 0.005f;
        int n = 0;
        while (n < 100) {
            int n2 = 0;
            while (n2 < this.pos.length) {
                float f2 = this.pos[n2][0];
                float f3 = this.pos[n2][1];
                float f4 = this.pos[n2][2];
                float[] fArray = this.pos[n2];
                fArray[0] = fArray[0] + f * (this.sigma * (f3 - f2));
                float[] fArray2 = this.pos[n2];
                fArray2[1] = fArray2[1] + f * (f2 * (this.rho - f4) - f3);
                float[] fArray3 = this.pos[n2];
                fArray3[2] = fArray3[2] + f * (f2 * f3 - this.beta * f4);
                float[] fArray4 = this.pos[n2];
                fArray4[3] = fArray4[3] - 1.0f;
                if (this.pos[n2][3] <= 0.0f) {
                    this.initParticle(n2);
                }
                ++n2;
            }
            ++n;
        }
    }

    public void initParticle(int n) {
        this.pos[n][0] = this.randomValue();
        this.pos[n][1] = this.randomValue();
        this.pos[n][2] = this.randomValue();
        this.pos[n][3] = this.timeToLive();
    }

    public float timeToLive() {
        return 500.0f * ineiros.abs((float)this.randomGaussian());
    }

    public float randomValue() {
        return this.randomGaussian() / this.alpha;
    }

    public float randomValue2(float f) {
        return f * this.randomGaussian();
    }

    public void attractor() {
        this.rho = (float)this.moonlander.getValue("rho");
        this.sigma = (float)this.moonlander.getValue("sigma");
        this.beta = (float)this.moonlander.getValue("beta");
        this.fill(255.0f, 0.0f, 255.0f);
        float f = this.millis();
        float f2 = (f - this.previousT) / 10000.0f;
        this.previousT = f;
        this.sphereDetail(3);
        this.pushMatrix();
        this.translate(0.0f, -50.0f, 0.0f);
        this.scale(10.0f, 10.0f, 10.0f);
        int n = this.pos.length;
        if (this.row > 2400.0f) {
            n = (int)ineiros.lerp((float)this.pos.length, (float)0.0f, (float)((this.row - 2400.0f) / 650.0f));
        }
        int n2 = 0;
        while (n2 < this.pos.length) {
            if (n2 >= n) break;
            float f3 = this.pos[n2][0];
            float f4 = this.pos[n2][1];
            float f5 = this.pos[n2][2];
            float[] fArray = this.pos[n2];
            fArray[0] = fArray[0] + f2 * (this.sigma * (f4 - f3));
            float[] fArray2 = this.pos[n2];
            fArray2[1] = fArray2[1] + f2 * (f3 * (this.rho - f5) - f4);
            float[] fArray3 = this.pos[n2];
            fArray3[2] = fArray3[2] + f2 * (f3 * f4 - this.beta * f5);
            float[] fArray4 = this.pos[n2];
            fArray4[3] = fArray4[3] - 1.0f;
            this.pushMatrix();
            this.translate(this.pos[n2][0], this.pos[n2][1], this.pos[n2][2]);
            if (n2 == 0 && this.frameCount % 60 == 0) {
                System.out.println(String.valueOf(f2) + ": " + this.pos[n2][0] + "," + this.pos[n2][1] + "," + this.pos[n2][2]);
            }
            this.noStroke();
            this.sphere(0.05f);
            if (this.row >= 260.0f && this.row % 260.0f < 130.0f && this.row <= 596.0f) {
                this.stroke(255.0f, 0.0f, 0.0f);
                this.strokeWeight(0.05f);
                this.line(this.pos[n2][0], this.pos[n2][1], this.pos[n2][2], f3, f4, f5);
            } else if (n2 < 256 && this.row > 596.0f && this.row < 2100.0f) {
                FloatList floatList = new FloatList();
                floatList.append(this.pos[n2][0]);
                floatList.append(this.pos[n2][1]);
                floatList.append(this.pos[n2][2]);
                floatList.append(f3);
                floatList.append(f4);
                floatList.append(f5);
                floatList.append(this.row);
                this.lines.add(floatList);
            }
            this.popMatrix();
            if (this.pos[n2][3] <= 0.0f || Float.isNaN(this.pos[n2][0])) {
                this.initParticle(n2);
            }
            ++n2;
        }
        if (this.row > 1827.0f) {
            this.lines.clear();
        }
        if (this.row < 1284.0f || this.row > 1540.0f) {
            this.stroke(255.0f, 255.0f, 255.0f);
        } else {
            this.stroke(this.row % 255.0f, this.row * 74.0f % 128.0f, 5.0f * this.row % 255.0f);
        }
        this.strokeWeight(0.05f);
        n2 = 0;
        while (n2 < this.lines.size()) {
            FloatList floatList = (FloatList)this.lines.get(n2);
            if (floatList.get(6) < this.row - 300.0f) {
                this.lines.remove(n2);
            } else {
                this.line(floatList.get(0), floatList.get(1), floatList.get(2), floatList.get(3), floatList.get(4), floatList.get(5));
            }
            ++n2;
        }
        if (this.row < 596.0f) {
            this.lines.clear();
        }
        if (this.row > 1555.0f && this.row > this.lastReset - 35.0f && (int)this.row % 35 == 0) {
            ineiros.println((String)("CLEAR! " + this.row + " " + this.lastReset));
            this.lastReset = this.row;
            this.lines.clear();
        }
        this.popMatrix();
    }

    public void drawCube(PGraphics pGraphics) {
        ineiros.println((float)this.row);
        if (this.row == 3100.0f) {
            this.scroll = 0;
        }
        pGraphics.pushMatrix();
        pGraphics.stroke(0);
        pGraphics.strokeWeight(1.0f);
        pGraphics.fill(255.0f, 255.0f, 255.0f);
        pGraphics.rotateX((float)this.millis() / 1000.0f);
        pGraphics.rotateY((float)this.millis() / 1000.0f);
        pGraphics.box(50.0f);
        pGraphics.pushMatrix();
        pGraphics.resetMatrix();
        pGraphics.translate((float)(-this.width / 2), (float)(-this.height / 2), -this.magicX);
        pGraphics.stroke(255);
        pGraphics.fill(255.0f, 120.0f, 255.0f);
        pGraphics.hint(2);
        pGraphics.scale(0.7f);
        pGraphics.textSize((float)this.textHeight);
        pGraphics.text("Obligatory cube!", (float)(this.width / 2 - 150), (float)(this.height / 2 - 200), 0.0f);
        pGraphics.fill(255.0f, 255.0f, 255.0f);
        pGraphics.textSize((float)(2 * this.textHeight));
        pGraphics.text("You have been watching:\n\nControl\nby ineiros / The Bayesian Conspiracy\n", 50.0f, (float)(this.height - this.scroll++), 0.0f);
        pGraphics.hint(-2);
        pGraphics.popMatrix();
        pGraphics.popMatrix();
    }

    public void drawTextScroll(PGraphics pGraphics) {
        if (this.textScroll == 0.0f) {
            this.textScroll = this.row;
        }
        pGraphics.pushMatrix();
        pGraphics.resetMatrix();
        pGraphics.translate((float)(-this.width / 2), (float)(-this.height / 2), -this.magicX);
        pGraphics.scale(0.7f);
        pGraphics.stroke(255);
        pGraphics.fill(255.0f, 255.0f, 255.0f);
        pGraphics.hint(2);
        pGraphics.textSize((float)(2 * this.textHeight));
        int n = 0;
        while (n < this.textLines.length) {
            pGraphics.text(this.textLines[n], 30.0f, (float)this.height + 1.5f * (float)n * (float)this.spacing - 5.0f * (this.row - this.textScroll), 0.0f);
            ++n;
        }
        pGraphics.hint(-2);
        pGraphics.popMatrix();
    }

    public void drawDebug(PGraphics pGraphics) {
        pGraphics.pushMatrix();
        pGraphics.resetMatrix();
        pGraphics.translate((float)(-this.width / 2), (float)(-this.height / 2), -this.magicX);
        pGraphics.fill(255.0f, 0.0f, 0.0f);
        pGraphics.textSize(24.0f);
        pGraphics.text("Track Time: " + String.format("%.2f", this.moonlander.getCurrentTime()), 0.0f, 20.0f, 0.0f);
        pGraphics.text("Run Time: " + String.format("%.2f", Float.valueOf((float)this.millis() / 1000.0f)), 0.0f, 50.0f, 0.0f);
        pGraphics.text("Row: " + String.format("%.0f", this.moonlander.getCurrentRow()), 0.0f, 80.0f, 0.0f);
        pGraphics.popMatrix();
    }

    public void draw3DAxes(PGraphics pGraphics) {
        pGraphics.pushMatrix();
        pGraphics.strokeWeight(1.0f);
        pGraphics.stroke(255.0f, 0.0f, 0.0f);
        pGraphics.line(0.0f, 0.0f, 0.0f, 1000.0f, 0.0f, 0.0f);
        pGraphics.stroke(0.0f, 255.0f, 0.0f);
        pGraphics.line(0.0f, 0.0f, 0.0f, 0.0f, 1000.0f, 0.0f);
        pGraphics.stroke(0.0f, 0.0f, 255.0f);
        pGraphics.line(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1000.0f);
        pGraphics.popMatrix();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "ineiros"};
        if (stringArray != null) {
            PApplet.main((String[])ineiros.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }
}

