import moonlander.library.*;
import ddf.minim.*;

/*
 * An example of how to use
 * Processing's 3D features.
 *
 * Features:
 * - Setting up a 3D viewport
 * - Drawing plane and sphere primitives
 * - 3D-transformations
 */

// Setup Variables
int CANVAS_WIDTH = 1280;
int CANVAS_HEIGHT = 720;
double dt = 0.0;
double lastTime = 0.0;
Engine engine = new Engine();
Moonlander moonlander;
double beat;
double red;
double green;
double blue;
double flash;
double beatState;
PGraphics pg;
TV tv;
PImage bluescreen;
double sf2;
float carx;
float carz;

void setup() {
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
  frameRate(50);
  pg = createGraphics(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
  pg.rectMode(CENTER);
  noStroke();
  tv = new TV();
  
  bluescreen = loadImage("bluescreen.png");
  
  moonlander = Moonlander.initWithSoundtrack(this, "music.wav", 122, 12);
  moonlander.start();
  engine.init();
}

void draw() {
  moonlander.update();
  beat = moonlander.getValue("beat");
  beatState = moonlander.getValue("beatState");
  red = moonlander.getValue("red");
  green = moonlander.getValue("green");
  blue = moonlander.getValue("blue");
  flash = moonlander.getValue("flash");
  sf2 = moonlander.getValue("snow");

  dt = (millis() - lastTime) / 1000.0;
  engine.update(dt);
  engine.paint();
  lastTime = millis();

  if (flash > 0.0) {
    background(255, (float)(flash * 255));
  }
  tv.paint();
}

