class TV {

  int CANVAS_DEPTH = 500;
  int rotation = 1;
  float ASPECT_RATIO = (float)CANVAS_WIDTH/CANVAS_HEIGHT;
  int status;
  int status2;

  void paint() {
    status = moonlander.getIntValue("tvstatus");
    status2 = moonlander.getIntValue("status");
    float cameraZ = (float)moonlander.getValue("tvcamera");
    float cameraX = (float)moonlander.getValue("tvcameraX");
    float centerX = (float)moonlander.getValue("tvcenterX");

    if (status > 0) {
      camera(CANVAS_WIDTH/2.0 -cameraX, CANVAS_HEIGHT/2.0, (CANVAS_HEIGHT/2.0) / tan(PI*30.0 / 180.0) - cameraZ, CANVAS_WIDTH/2.0 - centerX, CANVAS_HEIGHT/2.0, 0, 0, 1, 0);
    }
    resolution();
  }


  void resolution() {
    float xPoint = (CANVAS_WIDTH - 0.25*CANVAS_WIDTH);
    float yPoint = (CANVAS_HEIGHT - 0.25*CANVAS_HEIGHT);
    double times = moonlander.getValue("tvtimes");
    float x1 = xPoint - (float)times*xPoint;
    float x2 = xPoint + (float)times*(0.25*CANVAS_WIDTH);
    float y1 = yPoint - (float)times*yPoint;
    float y2 = yPoint + (float)times*(0.25*CANVAS_HEIGHT);
    int textColor = moonlander.getIntValue("tvcolor");

    background(255, 255, 255, 0);


    pushMatrix();
    translate(0, 0, -3);
    rect(0, 0, (float)CANVAS_WIDTH, (float)CANVAS_HEIGHT);
    popMatrix();
    translate(CANVAS_WIDTH/2, CANVAS_HEIGHT/2, 0);
    pushMatrix();
    translate(-pg.width/2, -pg.height/2, -1);
    if (beatState > 3) {
      image(bluescreen, 0, 0);
    } else {
      image(pg, 0, 0);
      popMatrix();

      // Text
      pushMatrix();
      fill(255);
      translate(-pg.width/2, -pg.height/2, 0);
      if (status2 == 5) {  
        fill(255);
        textSize(100);
        text("This is 4K",CANVAS_WIDTH/2 -600, CANVAS_HEIGHT/2 +300,0);
      }else if(status2 == 12) {
        fill(255);
        textSize(100);
        text("In4K presents",CANVAS_WIDTH/2 -350, CANVAS_HEIGHT/2 +50 ,0);
      }else if(status2 == 13) {
        fill(255);
        textSize(100);
        text("Long Ass Intro",CANVAS_WIDTH/2 -350, CANVAS_HEIGHT/2 +50,0);
      }
      stroke(255, 255, 255, 255);
      line(x1, yPoint, x2, yPoint);
      line(xPoint, y1, xPoint, y2);

      stroke(255, 255, 255, 255 -textColor);
      line(xPoint, 0, xPoint + 10, 10);
      line(xPoint - 10, 10, xPoint, 0);
      line(xPoint, CANVAS_HEIGHT -1, xPoint +10, CANVAS_HEIGHT - 11);
      line(xPoint - 10, CANVAS_HEIGHT -11, xPoint, CANVAS_HEIGHT -1);
      line(0, yPoint, 10, yPoint +10);
      line(10, yPoint -10, 0, yPoint);
      line(CANVAS_WIDTH -1, yPoint, CANVAS_WIDTH -11, yPoint + 10);
      line(CANVAS_WIDTH -11, yPoint -10, CANVAS_WIDTH -1, yPoint);
      textSize(32);
      fill(255, 255, 255, 255 -textColor);
      text("4096", 7, yPoint -10);
      fill(255, 255, 255, 255 -textColor);
      text("2160 ", xPoint + 5, 32);
      fill(255, 255, 255, 255-textColor);
      noStroke();

      // Flash
      if (flash > 0.0) {
        fill(255, 255, 255, (int)(flash * 255));
        rect(0, 0, CANVAS_WIDTH, CANVAS_HEIGHT);
      }
    }
    popMatrix();

    fill(textColor);
    pushMatrix();
    translate(0, CANVAS_HEIGHT/2+5, 0);
    box(CANVAS_WIDTH + 20, 10, 20);
    popMatrix();
    pushMatrix();
    translate(0, -CANVAS_HEIGHT/2-5, 0);
    box(CANVAS_WIDTH + 20, 10, 20);
    popMatrix();
    pushMatrix();
    translate(CANVAS_WIDTH/2+5, 0, 0);
    box(10, CANVAS_HEIGHT, 20);
    popMatrix();
    pushMatrix();
    translate(-CANVAS_WIDTH/2-5, 0, 0);
    box(10, CANVAS_HEIGHT, 20);
    popMatrix();
    pushMatrix();
    translate(CANVAS_WIDTH/2, CANVAS_HEIGHT/2 + 24, - 10);
    rotateZ(0.4);
    box(20, 10, 50);
    rotateZ(-0.4);
    translate(-CANVAS_WIDTH, 0, 0);
    rotateZ(0.4);
    box(10, 10, 50);
    popMatrix();
    textSize(120);
    fill(0, 0, 0, status);
    rotateY(-0.4);
    text("Sony", 900, 0);
    rotateY(-0.2);
    fill(248, 0, 40, status);
    text("4K", 900, 120);
    fill(0, 0, 0, status);
    text("Bravia", 1100, 120);
  }
}

