import java.util.*;

class Engine {
  // GameObjects
  ArrayList<GameObject> gameObjects = new ArrayList<GameObject>();
  Drawer drawer = new Drawer();
  GameObject car;
  GameObject road;
  GameObject ground;
  void Add(GameObject gameObject) {
    gameObjects.add(gameObject);
  }
  double sf;
  int rotation = 0;
  void init() {
    //    Camera camera = new Camera();  
    //    Add((GameObject) camera);
    /*Add(new Tree(200, 200));
     Add(new Tree(500, 500));
     Add(new Tree(200, -200));
     Add(new Tree(-200, -200));
     Add(new Tree(-500, 200));
     Add(new Tree(-500, -500));
     */
    ground = new Ground();
    Add(ground);
    road = new Road();
    Add(road);
    car = new Car();
    Add(car);
    for (int x = 0; x < 20; x++) {
      Add(new Tree(450*x, -450, car));
      Add(new Tree(-450*x, 450, car));
      Add(new Tree(450*x, 450, car));
      Add(new Tree(-450*x, -450, car));
    }
    //camera.setParent(car);

    for (GameObject gameObject : gameObjects) {
      gameObject.init();
    }
  }

  void update(double dt) {
    
    carx = car.x;
    carz = car.z;
    
    for (GameObject gameObject : gameObjects) {
      gameObject.update(dt);
    }
    
    if (sf2 > 0 && sf > 0.03) {
      for (int i2 = 1; i2 <= 10; i2++) {
        Add(new Snowflake(gameObjects));
      }
      sf = 0;
    } else {
      sf += dt;
    }
    
    pg.pushMatrix();
    road.update(car.x);
    //ground.update(car.x);
    pg.popMatrix();
  }
  void paint() {
    pg.beginDraw();
    pg.noStroke();
    pg.clear();
    pg.pushMatrix();


    pg.background(54, 191, 255);

    int status = moonlander.getIntValue("status");
    float cameraZ = (float)moonlander.getValue("cameraZ");
    float cameraX = (float)moonlander.getValue("cameraX");
    float cameraY = (float)moonlander.getValue("cameraY");
    float centerX = (float)moonlander.getValue("centerX");
    float centerZ = (float)moonlander.getValue("centerZ");
    float centerY = (float)moonlander.getValue("centerY");

    // Center the Scene
    pg.translate(width/2, height/2, 0);
    //    // Move up and backwards - away from the origin
    pg.translate(0, 200, -400);
    //    // Rotate the viewport a bit with mouse
    pg.rotateY((mouseX - width/2) * 0.01);
    pg.rotateX((mouseY - height/2) * -0.01);

    //cinematic mode
    if (status == 1 || status > 10) {
      pg.camera(car.x, -200, 250, car.x + 50000, 0, car.z -25000, 0, 1, 0);
    } else if (status == 2) {
      pg.camera(car.x + cameraX, -200 - cameraY, 250 -cameraZ, car.x + 50000-centerX, 0-centerY, -25000 +centerZ, 0, 1, 0);
    } else if (status == 3 || status == 5) {
      pg.camera(car.x + cameraX, -200 - cameraY, 250 -cameraZ, car.x, car.y, car.z, 0, 1, 0);
    } else {
      pg.camera(900+car.x, -800, 0, car.x, car.y, car.z, 0, 1, 0);
    }
    //    // Rotate the viewport a bit with mouse
    //rotateY((mouseX - width/2) * 0.01);
    //rotateX((mouseY - height/2) * -0.01);

    pg.fill(255);

    // Draw the ground plane
    pg.ambientLight(140, 140, 120);
    pg.directionalLight(150, 150, 150, 0, 1, -1);

    for (GameObject gameObject : gameObjects) {
      gameObject.paint(drawer);
    }
    pg.popMatrix();
    pg.endDraw();
  }
}

