class Drawer {

  void drawCylinderPart(int sides, float r, float h) {
    float angle = 360 / sides;
    pg.beginShape();
    for (int i = 0; i < sides; i++) {
      float x = cos( radians( i * angle ) ) * r;
      float y = sin( radians( i * angle ) ) * r;
      pg.vertex( x, y, h );
    }
    pg.endShape(CLOSE);
  }  

  void drawCylinder(int sides, float r, float h) {
    float angle = 360 / sides;
    float halfHeight = h / 2;
    // draw top shape
    drawCylinderPart(sides, r, -halfHeight);
    // draw bottom shape
    drawCylinderPart(sides, r, halfHeight);
    // draw body
    pg.beginShape(TRIANGLE_STRIP);
    for (int i = 0; i < sides + 1; i++) {
      float x = cos( radians( i * angle ) ) * r;
      float y = sin( radians( i * angle ) ) * r;
      pg.vertex( x, y, halfHeight);
      pg.vertex( x, y, -halfHeight);
    }
    pg.endShape(CLOSE);
  }
}

