/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;

public class in4k
extends PApplet {
    int CANVAS_WIDTH = 1280;
    int CANVAS_HEIGHT = 720;
    double dt = 0.0;
    double lastTime = 0.0;
    Engine engine = new Engine();
    Moonlander moonlander;
    double beat;
    double red;
    double green;
    double blue;
    double flash;
    double beatState;
    PGraphics pg;
    TV tv;
    PImage bluescreen;
    double sf2;
    float carx;
    float carz;

    public void setup() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.frameRate(50.0f);
        this.pg = this.createGraphics(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.pg.rectMode(3);
        this.noStroke();
        this.tv = new TV();
        this.bluescreen = this.loadImage("bluescreen.png");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"music.wav", (int)122, (int)12);
        this.moonlander.start();
        this.engine.init();
    }

    public void draw() {
        this.moonlander.update();
        this.beat = this.moonlander.getValue("beat");
        this.beatState = this.moonlander.getValue("beatState");
        this.red = this.moonlander.getValue("red");
        this.green = this.moonlander.getValue("green");
        this.blue = this.moonlander.getValue("blue");
        this.flash = this.moonlander.getValue("flash");
        this.sf2 = this.moonlander.getValue("snow");
        this.dt = ((double)this.millis() - this.lastTime) / 1000.0;
        this.engine.update(this.dt);
        this.engine.paint();
        this.lastTime = this.millis();
        if (this.flash > 0.0) {
            this.background(255, (float)(this.flash * 255.0));
        }
        this.tv.paint();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"in4k"};
        if (stringArray != null) {
            PApplet.main((String[])in4k.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Camera
    extends GameObject {
        GameObject parent;

        Camera() {
        }

        public void setParent(GameObject gameObject) {
            this.parent = gameObject;
        }

        @Override
        public void init() {
            this.x = in4k.this.width / 2;
            this.y = in4k.this.height / 2;
        }

        @Override
        public void update(double d) {
        }

        @Override
        public void paint(Drawer drawer) {
            in4k.this.pg.beginCamera();
            in4k.this.pg.camera();
            if (this.parent != null) {
                in4k.println((String)(String.valueOf(this.parent.x) + " " + this.parent.y));
                in4k.this.pg.translate(this.parent.x, this.parent.y, this.parent.z);
            }
            in4k.this.pg.translate(this.x, this.y, this.z);
            in4k.this.pg.rotateX(-0.5235988f);
            in4k.this.pg.rotateY(1.5707964f);
            in4k.this.pg.endCamera();
        }
    }

    class Car
    extends GameObject {
        float h;
        float vx;

        public Car() {
            this.h = 50.0f;
            this.vx = 0.0f;
        }

        public Car(float f, float f2) {
            this.h = 50.0f;
            this.vx = 0.0f;
            this.x = f;
            this.z = f2;
        }

        @Override
        public void init() {
            this.y += -this.h / 2.0f;
        }

        @Override
        public void update(double d) {
            this.x = (float)in4k.this.moonlander.getValue("speed");
        }

        public void drawWheel(Drawer drawer, float f, float f2) {
            in4k.this.pg.pushMatrix();
            in4k.this.pg.translate(f, -50.0f, f2);
            in4k.this.pg.rotateZ((float)in4k.this.millis() / 1000.0f);
            in4k.this.pg.fill(5.0f, 7.0f, 15.0f);
            drawer.drawCylinder(10, 100.0f, 50.0f);
            in4k.this.pg.popMatrix();
        }

        @Override
        public void paint(Drawer drawer) {
            in4k.this.pg.pushMatrix();
            in4k.this.pg.translate(this.x, this.y, this.z);
            in4k.this.pg.fill(200.0f, 0.0f, 0.0f);
            in4k.this.pg.pushMatrix();
            in4k.this.pg.translate(0.0f, -150.0f + (in4k.this.beatState > 1.0 ? 50.0f * (float)in4k.this.beat : 0.0f), 0.0f);
            in4k.this.pg.box(400.0f, 200.0f, 240.0f);
            in4k.this.pg.pushMatrix();
            in4k.this.pg.textSize(100.0f);
            in4k.this.pg.fill(0.0f, 0.0f, 0.0f);
            in4k.this.pg.text("Badass", -170.0f, 50.0f, 121.0f);
            in4k.this.pg.rotateY((float)Math.PI);
            in4k.this.pg.textSize(40.0f);
            in4k.this.pg.text("Reserved for Sponsors", -190.0f, 0.0f, 121.0f);
            in4k.this.pg.popMatrix();
            in4k.this.pg.fill(200.0f, 0.0f, 0.0f);
            in4k.this.pg.translate(250.0f, 40.0f, 0.0f);
            in4k.this.pg.box(100.0f, 150.0f, 240.0f);
            in4k.this.pg.pushMatrix();
            in4k.this.pg.fill(247.0f, 219.0f, 7.0f);
            in4k.this.pg.translate(55.0f, -80.0f, -30.0f);
            in4k.this.pg.rotateY(1.5707964f);
            in4k.this.pg.ellipse(50.0f, 50.0f, 50.0f, 50.0f + (in4k.this.beatState > 1.0 ? -30.0f * (float)in4k.this.beat : 0.0f));
            in4k.this.pg.translate(-150.0f, 0.0f, 0.0f);
            in4k.this.pg.ellipse(50.0f, 50.0f, 50.0f, 50.0f + (in4k.this.beatState > 1.0 ? -30.0f * (float)in4k.this.beat : 0.0f));
            in4k.this.pg.popMatrix();
            in4k.this.pg.fill(200.0f, 0.0f, 0.0f);
            in4k.this.pg.translate(-500.0f, 0.0f, 0.0f);
            in4k.this.pg.box(100.0f, 150.0f, 240.0f);
            in4k.this.pg.translate(250.0f, -185.0f, 0.0f);
            in4k.this.pg.pushMatrix();
            in4k.this.pg.translate(-230.0f, 0.0f, 0.0f);
            in4k.this.pg.rotateZ(-0.7853982f);
            in4k.this.pg.box(30.0f, 120.0f, 240.0f);
            in4k.this.pg.popMatrix();
            in4k.this.pg.fill(0.0f, 0.0f, 0.0f);
            in4k.this.pg.pushMatrix();
            if (in4k.this.beatState > 0.0) {
                in4k.this.pg.translate(50.0f * (float)in4k.this.beat, 0.0f, 0.0f);
            }
            in4k.this.pg.sphere(50.0f);
            in4k.this.pg.translate(-10.0f, -50.0f, -40.0f);
            in4k.this.pg.rotateY(1.5707964f);
            drawer.drawCylinder(40, 40.0f, 40.0f);
            in4k.this.pg.translate(-80.0f, 0.0f, 0.0f);
            drawer.drawCylinder(40, 40.0f, 40.0f);
            in4k.this.pg.popMatrix();
            in4k.this.pg.fill(255.0f, 255.0f, 255.0f, 50.0f);
            in4k.this.pg.translate(130.0f, 10.0f, 0.0f);
            in4k.this.pg.rotateZ(0.4f);
            in4k.this.pg.box(100.0f, 20.0f, 240.0f);
            in4k.this.pg.popMatrix();
            this.drawWheel(drawer, 200.0f, 120.0f);
            this.drawWheel(drawer, -200.0f, 120.0f);
            this.drawWheel(drawer, 200.0f, -120.0f);
            this.drawWheel(drawer, -200.0f, -120.0f);
            in4k.this.pg.popMatrix();
        }
    }

    class Drawer {
        Drawer() {
        }

        public void drawCylinderPart(int n, float f, float f2) {
            float f3 = 360 / n;
            in4k.this.pg.beginShape();
            int n2 = 0;
            while (n2 < n) {
                float f4 = in4k.cos((float)in4k.radians((float)((float)n2 * f3))) * f;
                float f5 = in4k.sin((float)in4k.radians((float)((float)n2 * f3))) * f;
                in4k.this.pg.vertex(f4, f5, f2);
                ++n2;
            }
            in4k.this.pg.endShape(2);
        }

        public void drawCylinder(int n, float f, float f2) {
            float f3 = 360 / n;
            float f4 = f2 / 2.0f;
            this.drawCylinderPart(n, f, -f4);
            this.drawCylinderPart(n, f, f4);
            in4k.this.pg.beginShape(10);
            int n2 = 0;
            while (n2 < n + 1) {
                float f5 = in4k.cos((float)in4k.radians((float)((float)n2 * f3))) * f;
                float f6 = in4k.sin((float)in4k.radians((float)((float)n2 * f3))) * f;
                in4k.this.pg.vertex(f5, f6, f4);
                in4k.this.pg.vertex(f5, f6, -f4);
                ++n2;
            }
            in4k.this.pg.endShape(2);
        }
    }

    class Engine {
        ArrayList<GameObject> gameObjects = new ArrayList();
        Drawer drawer;
        GameObject car;
        GameObject road;
        GameObject ground;
        double sf;
        int rotation;

        Engine() {
            this.drawer = new Drawer();
            this.rotation = 0;
        }

        public void Add(GameObject gameObject) {
            this.gameObjects.add(gameObject);
        }

        public void init() {
            this.ground = new Ground();
            this.Add(this.ground);
            this.road = new Road();
            this.Add(this.road);
            this.car = new Car();
            this.Add(this.car);
            int n = 0;
            while (n < 20) {
                this.Add(new Tree(450 * n, -450.0f, this.car));
                this.Add(new Tree(-450 * n, 450.0f, this.car));
                this.Add(new Tree(450 * n, 450.0f, this.car));
                this.Add(new Tree(-450 * n, -450.0f, this.car));
                ++n;
            }
            for (GameObject gameObject : this.gameObjects) {
                gameObject.init();
            }
        }

        public void update(double d) {
            in4k.this.carx = this.car.x;
            in4k.this.carz = this.car.z;
            for (GameObject gameObject : this.gameObjects) {
                gameObject.update(d);
            }
            if (in4k.this.sf2 > 0.0 && this.sf > (double)0.03f) {
                int n = 1;
                while (n <= 10) {
                    this.Add(new Snowflake(this.gameObjects));
                    ++n;
                }
                this.sf = 0.0;
            } else {
                this.sf += d;
            }
            in4k.this.pg.pushMatrix();
            this.road.update(this.car.x);
            in4k.this.pg.popMatrix();
        }

        public void paint() {
            in4k.this.pg.beginDraw();
            in4k.this.pg.noStroke();
            in4k.this.pg.clear();
            in4k.this.pg.pushMatrix();
            in4k.this.pg.background(54.0f, 191.0f, 255.0f);
            int n = in4k.this.moonlander.getIntValue("status");
            float f = (float)in4k.this.moonlander.getValue("cameraZ");
            float f2 = (float)in4k.this.moonlander.getValue("cameraX");
            float f3 = (float)in4k.this.moonlander.getValue("cameraY");
            float f4 = (float)in4k.this.moonlander.getValue("centerX");
            float f5 = (float)in4k.this.moonlander.getValue("centerZ");
            float f6 = (float)in4k.this.moonlander.getValue("centerY");
            in4k.this.pg.translate((float)(in4k.this.width / 2), (float)(in4k.this.height / 2), 0.0f);
            in4k.this.pg.translate(0.0f, 200.0f, -400.0f);
            in4k.this.pg.rotateY((float)(in4k.this.mouseX - in4k.this.width / 2) * 0.01f);
            in4k.this.pg.rotateX((float)(in4k.this.mouseY - in4k.this.height / 2) * -0.01f);
            if (n == 1 || n > 10) {
                in4k.this.pg.camera(this.car.x, -200.0f, 250.0f, this.car.x + 50000.0f, 0.0f, this.car.z - 25000.0f, 0.0f, 1.0f, 0.0f);
            } else if (n == 2) {
                in4k.this.pg.camera(this.car.x + f2, -200.0f - f3, 250.0f - f, this.car.x + 50000.0f - f4, 0.0f - f6, -25000.0f + f5, 0.0f, 1.0f, 0.0f);
            } else if (n == 3 || n == 5) {
                in4k.this.pg.camera(this.car.x + f2, -200.0f - f3, 250.0f - f, this.car.x, this.car.y, this.car.z, 0.0f, 1.0f, 0.0f);
            } else {
                in4k.this.pg.camera(900.0f + this.car.x, -800.0f, 0.0f, this.car.x, this.car.y, this.car.z, 0.0f, 1.0f, 0.0f);
            }
            in4k.this.pg.fill(255);
            in4k.this.pg.ambientLight(140.0f, 140.0f, 120.0f);
            in4k.this.pg.directionalLight(150.0f, 150.0f, 150.0f, 0.0f, 1.0f, -1.0f);
            for (GameObject gameObject : this.gameObjects) {
                gameObject.paint(this.drawer);
            }
            in4k.this.pg.popMatrix();
            in4k.this.pg.endDraw();
        }
    }

    class GameObject {
        float x;
        float y;
        float z;

        GameObject() {
        }

        public void init() {
        }

        public void update(double d) {
        }

        public void paint(Drawer drawer) {
        }
    }

    class Ground
    extends GameObject {
        int x = 0;

        Ground() {
        }

        @Override
        public void init() {
        }

        @Override
        public void update(double d) {
        }

        @Override
        public void paint(Drawer drawer) {
            in4k.this.pg.pushMatrix();
            in4k.this.pg.rotateX(1.5707964f);
            in4k.this.pg.scale(6.0f);
            in4k.this.pg.fill((float)((int)in4k.this.red), (float)((int)in4k.this.green), (float)((int)in4k.this.blue));
            in4k.this.pg.rect(-1000.0f, -1000.0f, 10000.0f, 10000.0f);
            in4k.this.pg.popMatrix();
        }
    }

    class Road
    extends Ground {
        int x = 0;

        Road() {
        }

        @Override
        public void update(double d) {
            this.x = (int)d;
        }

        @Override
        public void paint(Drawer drawer) {
            in4k.this.pg.pushMatrix();
            in4k.this.pg.rotateX(1.5707964f);
            in4k.this.pg.fill(186.0f, 185.0f, 179.0f);
            in4k.this.pg.translate((float)this.x, 0.0f, 2.0f);
            in4k.this.pg.rect(-7000.0f, -300.0f, 100000.0f, 600.0f);
            in4k.this.pg.popMatrix();
        }
    }

    class Snowflake
    extends GameObject {
        ArrayList<GameObject> gameObjects;
        public int snow_color;
        public boolean draw_snow;
        public float snow_v;
        int snow_color2;

        public Snowflake(ArrayList<GameObject> arrayList) {
            this.snow_color = in4k.this.color(200);
            this.draw_snow = true;
            this.snow_v = 1000.0f;
            this.snow_color2 = in4k.this.color(in4k.this.random(256.0f), in4k.this.random(256.0f), in4k.this.random(256.0f));
            int n = in4k.this.moonlander.getIntValue("status");
            float f = (float)in4k.this.moonlander.getValue("cameraZ");
            float f2 = (float)in4k.this.moonlander.getValue("cameraX");
            if (n == 1) {
                this.x = in4k.this.random(3000.0f) - 1500.0f + in4k.this.carx;
                this.z = in4k.this.random(3000.0f) - 1500.0f + 250.0f;
            } else if (n == 2) {
                this.x = in4k.this.random(3000.0f) - 1500.0f + in4k.this.carx + f2;
                this.z = in4k.this.random(3000.0f) - 1500.0f + 250.0f - f;
            } else if (n == 3 || n == 5) {
                this.x = in4k.this.random(3000.0f) - 1500.0f + in4k.this.carx + f2;
                this.z = in4k.this.random(3000.0f) - 1500.0f + 250.0f - f;
            } else {
                this.x = in4k.this.random(3000.0f) - 1500.0f + in4k.this.carx + 900.0f;
                this.z = in4k.this.random(3000.0f) - 1500.0f;
            }
            this.y = -1000.0f;
            this.gameObjects = arrayList;
        }

        @Override
        public void init() {
        }

        @Override
        public void update(double d) {
            if (in4k.this.sf2 > 10.0) {
                this.snow_color = this.snow_color2;
            }
            if (this.draw_snow) {
                this.y = (float)((double)this.y + (double)this.snow_v * d);
                if (this.y > 5.0f) {
                    this.draw_snow = false;
                }
            }
        }

        @Override
        public void paint(Drawer drawer) {
            if (this.draw_snow) {
                in4k.this.pg.pushMatrix();
                in4k.this.pg.noLights();
                in4k.this.pg.translate(this.x, this.y, this.z);
                in4k.this.pg.fill(this.snow_color);
                in4k.this.pg.sphere(9.0f);
                in4k.this.pg.popMatrix();
                in4k.this.pg.lights();
            }
        }
    }

    class TV {
        int CANVAS_DEPTH = 500;
        int rotation = 1;
        float ASPECT_RATIO;
        int status;
        int status2;

        TV() {
            this.ASPECT_RATIO = (float)in4k.this.CANVAS_WIDTH / (float)in4k.this.CANVAS_HEIGHT;
        }

        public void paint() {
            this.status = in4k.this.moonlander.getIntValue("tvstatus");
            this.status2 = in4k.this.moonlander.getIntValue("status");
            float f = (float)in4k.this.moonlander.getValue("tvcamera");
            float f2 = (float)in4k.this.moonlander.getValue("tvcameraX");
            float f3 = (float)in4k.this.moonlander.getValue("tvcenterX");
            if (this.status > 0) {
                in4k.this.camera((float)in4k.this.CANVAS_WIDTH / 2.0f - f2, (float)in4k.this.CANVAS_HEIGHT / 2.0f, (float)in4k.this.CANVAS_HEIGHT / 2.0f / in4k.tan((float)0.5235988f) - f, (float)in4k.this.CANVAS_WIDTH / 2.0f - f3, (float)in4k.this.CANVAS_HEIGHT / 2.0f, 0.0f, 0.0f, 1.0f, 0.0f);
            }
            this.resolution();
        }

        public void resolution() {
            float f = (float)in4k.this.CANVAS_WIDTH - 0.25f * (float)in4k.this.CANVAS_WIDTH;
            float f2 = (float)in4k.this.CANVAS_HEIGHT - 0.25f * (float)in4k.this.CANVAS_HEIGHT;
            double d = in4k.this.moonlander.getValue("tvtimes");
            float f3 = f - (float)d * f;
            float f4 = f + (float)d * (0.25f * (float)in4k.this.CANVAS_WIDTH);
            float f5 = f2 - (float)d * f2;
            float f6 = f2 + (float)d * (0.25f * (float)in4k.this.CANVAS_HEIGHT);
            int n = in4k.this.moonlander.getIntValue("tvcolor");
            in4k.this.background(255.0f, 255.0f, 255.0f, 0.0f);
            in4k.this.pushMatrix();
            in4k.this.translate(0.0f, 0.0f, -3.0f);
            in4k.this.rect(0.0f, 0.0f, in4k.this.CANVAS_WIDTH, in4k.this.CANVAS_HEIGHT);
            in4k.this.popMatrix();
            in4k.this.translate(in4k.this.CANVAS_WIDTH / 2, in4k.this.CANVAS_HEIGHT / 2, 0.0f);
            in4k.this.pushMatrix();
            in4k.this.translate(-in4k.this.pg.width / 2, -in4k.this.pg.height / 2, -1.0f);
            if (in4k.this.beatState > 3.0) {
                in4k.this.image(in4k.this.bluescreen, 0.0f, 0.0f);
            } else {
                in4k.this.image((PImage)in4k.this.pg, 0.0f, 0.0f);
                in4k.this.popMatrix();
                in4k.this.pushMatrix();
                in4k.this.fill(255);
                in4k.this.translate(-in4k.this.pg.width / 2, -in4k.this.pg.height / 2, 0.0f);
                if (this.status2 == 5) {
                    in4k.this.fill(255);
                    in4k.this.textSize(100.0f);
                    in4k.this.text("This is 4K", in4k.this.CANVAS_WIDTH / 2 - 600, in4k.this.CANVAS_HEIGHT / 2 + 300, 0.0f);
                } else if (this.status2 == 12) {
                    in4k.this.fill(255);
                    in4k.this.textSize(100.0f);
                    in4k.this.text("In4K presents", in4k.this.CANVAS_WIDTH / 2 - 350, in4k.this.CANVAS_HEIGHT / 2 + 50, 0.0f);
                } else if (this.status2 == 13) {
                    in4k.this.fill(255);
                    in4k.this.textSize(100.0f);
                    in4k.this.text("Long Ass Intro", in4k.this.CANVAS_WIDTH / 2 - 350, in4k.this.CANVAS_HEIGHT / 2 + 50, 0.0f);
                }
                in4k.this.stroke(255.0f, 255.0f, 255.0f, 255.0f);
                in4k.this.line(f3, f2, f4, f2);
                in4k.this.line(f, f5, f, f6);
                in4k.this.stroke(255.0f, 255.0f, 255.0f, 255 - n);
                in4k.this.line(f, 0.0f, f + 10.0f, 10.0f);
                in4k.this.line(f - 10.0f, 10.0f, f, 0.0f);
                in4k.this.line(f, in4k.this.CANVAS_HEIGHT - 1, f + 10.0f, in4k.this.CANVAS_HEIGHT - 11);
                in4k.this.line(f - 10.0f, in4k.this.CANVAS_HEIGHT - 11, f, in4k.this.CANVAS_HEIGHT - 1);
                in4k.this.line(0.0f, f2, 10.0f, f2 + 10.0f);
                in4k.this.line(10.0f, f2 - 10.0f, 0.0f, f2);
                in4k.this.line(in4k.this.CANVAS_WIDTH - 1, f2, in4k.this.CANVAS_WIDTH - 11, f2 + 10.0f);
                in4k.this.line(in4k.this.CANVAS_WIDTH - 11, f2 - 10.0f, in4k.this.CANVAS_WIDTH - 1, f2);
                in4k.this.textSize(32.0f);
                in4k.this.fill(255.0f, 255.0f, 255.0f, 255 - n);
                in4k.this.text("4096", 7.0f, f2 - 10.0f);
                in4k.this.fill(255.0f, 255.0f, 255.0f, 255 - n);
                in4k.this.text("2160 ", f + 5.0f, 32.0f);
                in4k.this.fill(255.0f, 255.0f, 255.0f, 255 - n);
                in4k.this.noStroke();
                if (in4k.this.flash > 0.0) {
                    in4k.this.fill(255.0f, 255.0f, 255.0f, (int)(in4k.this.flash * 255.0));
                    in4k.this.rect(0.0f, 0.0f, in4k.this.CANVAS_WIDTH, in4k.this.CANVAS_HEIGHT);
                }
            }
            in4k.this.popMatrix();
            in4k.this.fill(n);
            in4k.this.pushMatrix();
            in4k.this.translate(0.0f, in4k.this.CANVAS_HEIGHT / 2 + 5, 0.0f);
            in4k.this.box(in4k.this.CANVAS_WIDTH + 20, 10.0f, 20.0f);
            in4k.this.popMatrix();
            in4k.this.pushMatrix();
            in4k.this.translate(0.0f, -in4k.this.CANVAS_HEIGHT / 2 - 5, 0.0f);
            in4k.this.box(in4k.this.CANVAS_WIDTH + 20, 10.0f, 20.0f);
            in4k.this.popMatrix();
            in4k.this.pushMatrix();
            in4k.this.translate(in4k.this.CANVAS_WIDTH / 2 + 5, 0.0f, 0.0f);
            in4k.this.box(10.0f, in4k.this.CANVAS_HEIGHT, 20.0f);
            in4k.this.popMatrix();
            in4k.this.pushMatrix();
            in4k.this.translate(-in4k.this.CANVAS_WIDTH / 2 - 5, 0.0f, 0.0f);
            in4k.this.box(10.0f, in4k.this.CANVAS_HEIGHT, 20.0f);
            in4k.this.popMatrix();
            in4k.this.pushMatrix();
            in4k.this.translate(in4k.this.CANVAS_WIDTH / 2, in4k.this.CANVAS_HEIGHT / 2 + 24, -10.0f);
            in4k.this.rotateZ(0.4f);
            in4k.this.box(20.0f, 10.0f, 50.0f);
            in4k.this.rotateZ(-0.4f);
            in4k.this.translate(-in4k.this.CANVAS_WIDTH, 0.0f, 0.0f);
            in4k.this.rotateZ(0.4f);
            in4k.this.box(10.0f, 10.0f, 50.0f);
            in4k.this.popMatrix();
            in4k.this.textSize(120.0f);
            in4k.this.fill(0.0f, 0.0f, 0.0f, this.status);
            in4k.this.rotateY(-0.4f);
            in4k.this.text("Sony", 900.0f, 0.0f);
            in4k.this.rotateY(-0.2f);
            in4k.this.fill(248.0f, 0.0f, 40.0f, this.status);
            in4k.this.text("4K", 900.0f, 120.0f);
            in4k.this.fill(0.0f, 0.0f, 0.0f, this.status);
            in4k.this.text("Bravia", 1100.0f, 120.0f);
        }
    }

    class Tree
    extends GameObject {
        float sphereRadius = 100.0f;
        float h = 300.0f;
        int r = 0;
        int g = 0;
        int b = 0;
        double last;
        GameObject car;

        public Tree(float f, float f2, GameObject gameObject) {
            this.x = f;
            this.z = f2;
            this.car = gameObject;
        }

        @Override
        public void init() {
            this.y += -this.h / 2.0f;
        }

        @Override
        public void update(double d) {
            this.sphereRadius = 200 + (int)(in4k.this.beatState > 2.0 ? 60.0f * (float)in4k.this.beat : 0.0f);
            if (this.car.x - this.x > 10000.0f) {
                this.x = this.car.x + 10000.0f;
            }
        }

        @Override
        public void paint(Drawer drawer) {
            float f = (float)in4k.this.moonlander.getValue("cameraX");
            int n = in4k.this.moonlander.getIntValue("status");
            in4k.this.pg.pushMatrix();
            if (n == 1) {
                in4k.this.pg.translate(this.x, this.y + this.h * f - 2.0f * f, this.z);
            } else {
                in4k.this.pg.translate(this.x, this.y, this.z);
            }
            in4k.this.pg.fill(176.0f, 80.0f, 1.0f);
            in4k.this.pg.box(40.0f, 300.0f, 40.0f);
            if (n == 1) {
                in4k.this.pg.translate(0.0f, -this.h + this.sphereRadius / 1.8f + this.h * f, 0.0f);
            } else {
                in4k.this.pg.translate(0.0f, -this.h + this.sphereRadius / 1.8f, 0.0f);
            }
            if (in4k.this.beatState > 2.5) {
                if (in4k.this.beat - this.last > (double)0.7f) {
                    this.r = (int)in4k.this.random(256.0f);
                    this.g = (int)in4k.this.random(256.0f);
                    this.b = (int)in4k.this.random(256.0f);
                }
                this.last = in4k.this.beat;
            } else {
                this.r = (int)in4k.this.red;
                this.g = (int)in4k.this.green;
                this.b = (int)in4k.this.blue;
            }
            in4k.this.pg.fill((float)this.r, (float)this.g, (float)this.b);
            in4k.this.pg.sphere(this.sphereRadius);
            in4k.this.pg.popMatrix();
        }
    }
}

