/*
 * Decompiled with CFR 0.152.
 */
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.opengl.PShader;

public class i_want_to_evolve_fullscreen
extends PApplet {
    int CANVAS_WIDTH = 1280;
    int CANVAS_HEIGHT = 720;
    Moonlander moonlander;
    PShader mandelbrotshader;
    PFont mono;
    PImage overlayimg;
    PImage primitivelogo;
    PImage evolvelogo;
    PImage endimg;
    ArrayList<String> greetGroups = new ArrayList();
    ArrayList<GreetObject> greetObjects = new ArrayList();
    String greetsStartRow = "290";
    float x;
    float y;
    float z;
    float deltaTime = 0.0f;
    int lastTime = 0;

    public void setup() {
        System.out.println("I Want To Evolve\n2015 Primitive");
        System.setErr(new PrintStream(new OutputStream(){

            @Override
            public void write(int n) {
            }
        }));
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.frameRate(60.0f);
        this.background(0.0f, 0.0f, 0.0f);
        this.mono = this.loadFont("CenturyGothic-72.vlw");
        this.textFont(this.mono);
        this.textAlign(3, 3);
        this.mandelbrotshader = this.loadShader("mandelbrot.glsl");
        this.mandelbrotshader.set("iResolution", (float)this.CANVAS_WIDTH, (float)this.CANVAS_HEIGHT);
        this.overlayimg = this.loadImage("overlay1.png");
        this.primitivelogo = this.loadImage("primitivelogo_alpha.png");
        this.evolvelogo = this.loadImage("primitive-iwanttoevolve.png");
        this.endimg = this.loadImage("primitive_axelogo.png");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"T-101_-_Vitae_Novel_Two.mp3", (int)101, (int)8);
        this.moonlander.start();
        this.x = this.CANVAS_WIDTH / 2;
        this.y = this.CANVAS_HEIGHT / 2;
        this.z = 0.0f;
        this.greetGroups.add("accession");
        this.greetGroups.add("alpha design");
        this.greetGroups.add("beyond force");
        this.greetGroups.add("boozoholics");
        this.greetGroups.add("brainstorm");
        this.greetGroups.add("byterapers");
        this.greetGroups.add("cncd");
        this.greetGroups.add("coma");
        this.greetGroups.add("dahlia");
        this.greetGroups.add("damones");
        this.greetGroups.add("darklite");
        this.greetGroups.add("dekadence");
        this.greetGroups.add("extend");
        this.greetGroups.add("finnish gold");
        this.greetGroups.add("HiRMU");
        this.greetGroups.add("jumalauta");
        this.greetGroups.add("mercury");
        this.greetGroups.add("peisik");
        this.greetGroups.add("rno");
        this.greetGroups.add("spaceballs");
        this.greetGroups.add("teurasporsaat");
        this.greetGroups.add("TRSi");
        this.greetGroups.add("\u00fcmlaut design");
        this.greetGroups.add("wide load");
    }

    public void draw() {
        this.moonlander.update();
        this.clear();
        this.background(0);
        if ((int)this.moonlander.getCurrentRow() > Integer.parseInt("000", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("120", 16)) {
            this.strobe();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("120", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("180", 16)) {
            this.graffathon();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("180", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("1C0", 16)) {
            this.primitiveLogo();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("1C0", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("200", 16)) {
            this.evolveLogo();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("200", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("250", 16)) {
            this.cubes1();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("250", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("280", 16)) {
            this.cubes2();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("280", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("480", 16)) {
            this.greetings();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("480", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("580", 16)) {
            this.mandelbrot();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("580", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("600", 16)) {
            this.credits();
        }
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("600", 16) && (int)this.moonlander.getCurrentRow() < Integer.parseInt("650", 16)) {
            this.endLogo();
        }
    }

    public void overlay() {
        this.image(this.overlayimg, 0.0f, 0.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
    }

    public void strobe() {
        this.background((int)this.moonlander.getValue("strobe_white"));
        this.overlay();
    }

    public void graffathon() {
        this.background((int)this.moonlander.getValue("strobe_white"));
        this.fill((int)this.moonlander.getValue("imageFade"));
        this.text("GRAFFATHON\n2015", this.CANVAS_WIDTH / 2, this.CANVAS_HEIGHT / 2);
        this.overlay();
    }

    public void primitiveLogo() {
        this.background((int)this.moonlander.getValue("strobe_white"));
        this.tint(255, (int)this.moonlander.getValue("imageFade"));
        this.image(this.primitivelogo, 0.0f, 0.0f + i_want_to_evolve_fullscreen.sin((float)((float)this.millis() * 5.0E-4f)) * 20.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
        this.tint(255, 255.0f);
        this.overlay();
    }

    public void evolveLogo() {
        this.background((int)this.moonlander.getValue("strobe_white"));
        this.tint(255, (int)this.moonlander.getValue("imageFade"));
        this.image(this.evolvelogo, 0.0f, 0.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
        this.tint(255, 255.0f);
        this.overlay();
    }

    public void cubes1() {
        this.background((int)this.moonlander.getValue("strobe_white"));
        this.hint(-2);
        this.fill((int)this.moonlander.getValue("imageFade"));
        if ((int)this.moonlander.getCurrentRow() >= Integer.parseInt("220", 16)) {
            this.pushMatrix();
            this.translate(this.x, this.y, this.z);
            this.rectMode(3);
            this.rotateZ(0.0f + (float)this.millis() * 0.001f);
            this.rotateX(0.0f + (float)this.millis() * 0.001f);
            this.box(this.CANVAS_HEIGHT / 6);
            this.translate(-this.CANVAS_HEIGHT / 6, 0.0f);
            this.box(this.CANVAS_HEIGHT / 6);
            this.translate(this.CANVAS_HEIGHT / 6 * 2, 0.0f);
            this.box(this.CANVAS_HEIGHT / 6);
            this.translate(-this.CANVAS_HEIGHT / 6, -this.CANVAS_HEIGHT / 6, 0.0f);
            this.box(this.CANVAS_HEIGHT / 6);
            this.translate(0.0f, this.CANVAS_HEIGHT / 6 * 2, 0.0f);
            this.box(this.CANVAS_HEIGHT / 6);
            this.translate(0.0f, -this.CANVAS_HEIGHT / 6, -this.CANVAS_HEIGHT / 6);
            this.box(this.CANVAS_HEIGHT / 6);
            this.translate(0.0f, 0.0f, this.CANVAS_HEIGHT / 6 * 2);
            this.box(this.CANVAS_HEIGHT / 6);
            this.popMatrix();
            this.hint(2);
        }
        this.overlay();
    }

    public void cubes2() {
        this.hint(-2);
        this.fill((int)this.moonlander.getValue("imageFade"));
        this.pushMatrix();
        this.translate(this.x, this.y, this.z);
        this.rectMode(3);
        this.translate(0.0f, 0.0f, 0.0f);
        this.rotateZ(0.0f + (float)this.millis() * 0.001f);
        this.rotateX(0.0f + (float)this.millis() * 0.001f);
        this.sphereDetail(5, 128);
        this.strokeWeight(1.0f);
        this.sphere(this.CANVAS_HEIGHT / 6);
        this.translate(this.CANVAS_HEIGHT / 3, 0.0f, 0.0f);
        this.rotateZ(0.0f + (float)this.millis() * 0.001f);
        this.rotateX(0.0f + (float)this.millis() * 0.001f);
        this.strokeWeight(2.0f);
        this.box(this.CANVAS_HEIGHT / 10);
        this.popMatrix();
        this.hint(2);
        this.overlay();
    }

    public void cubes3() {
        this.hint(-2);
        int n = 0;
        while (n < 12) {
            this.fill((int)this.moonlander.getValue("imageFade"));
            this.pushMatrix();
            this.translate(this.x + 100.0f, this.y + 100.0f, this.z);
            this.box(50.0f);
            this.popMatrix();
            this.rotateX(36.0f);
            ++n;
        }
        this.hint(2);
        this.overlay();
    }

    public void greetings() {
        int n = this.millis();
        this.deltaTime = (float)(n - this.lastTime) / 1000.0f;
        this.lastTime = n;
        if ((int)this.moonlander.getValue("greetingsCounter") > this.greetObjects.size()) {
            GreetObject greetObject = new GreetObject(this.greetGroups.get((int)this.moonlander.getValue("greetingsCounter") - 1));
            this.greetObjects.add(greetObject);
        }
        int n2 = 0;
        while (n2 < this.greetObjects.size()) {
            this.greetObjects.get((int)n2).x += this.deltaTime * (float)this.CANVAS_WIDTH / 6.0f;
            this.greetObjects.get(n2).draw();
            ++n2;
        }
        this.overlay();
    }

    public void mandelbrot() {
        this.shader(this.mandelbrotshader);
        this.mandelbrotshader.set("iGlobalTime", (float)this.moonlander.getCurrentTime());
        this.mandelbrotshader.set("texture", this.overlayimg);
        this.textureMode(1);
        this.image(this.overlayimg, 0.0f, 0.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
    }

    public void credits() {
        this.resetShader();
        this.background((int)this.moonlander.getValue("strobe_white"));
        this.fill((int)this.moonlander.getValue("imageFade"));
        if (this.moonlander.getCurrentRow() < 1472.0) {
            this.text("T-101\ncode ^ music", this.CANVAS_WIDTH / 2, this.CANVAS_HEIGHT / 2);
        } else {
            this.textSize(36.0f);
            this.text("featuring", this.CANVAS_WIDTH / 2, this.CANVAS_HEIGHT / 4);
            this.textSize(72.0f);
            this.text("BRACKET\ngfx", this.CANVAS_WIDTH / 2, this.CANVAS_HEIGHT / 2);
        }
        this.overlay();
    }

    public void endLogo() {
        this.background((int)this.moonlander.getValue("strobe_white"));
        this.tint(255, (int)this.moonlander.getValue("imageFade"));
        this.image(this.endimg, 0.0f, 0.0f, this.CANVAS_WIDTH, this.CANVAS_HEIGHT);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#000000", "--stop-color=#7C7C7C", "i_want_to_evolve_fullscreen"};
        if (stringArray != null) {
            PApplet.main((String[])i_want_to_evolve_fullscreen.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class GreetObject {
        String greetText;
        float x;
        float y;

        GreetObject(String string) {
            this.x = -i_want_to_evolve_fullscreen.this.CANVAS_WIDTH / 2;
            float f = (float)(i_want_to_evolve_fullscreen.this.CANVAS_HEIGHT / 9) - (float)i_want_to_evolve_fullscreen.this.CANVAS_HEIGHT / 2.0f;
            float f2 = (float)i_want_to_evolve_fullscreen.this.CANVAS_HEIGHT / 2.0f - (float)(i_want_to_evolve_fullscreen.this.CANVAS_HEIGHT / 9);
            this.y = (int)f + (int)(Math.random() * (double)(f2 - f + 1.0f));
            if (i_want_to_evolve_fullscreen.this.greetGroups.size() > 0) {
                this.greetText = string;
            }
        }

        public void draw() {
            i_want_to_evolve_fullscreen.this.pushMatrix();
            i_want_to_evolve_fullscreen.this.translate(i_want_to_evolve_fullscreen.this.CANVAS_WIDTH / 2, i_want_to_evolve_fullscreen.this.CANVAS_HEIGHT / 2);
            i_want_to_evolve_fullscreen.this.pushMatrix();
            i_want_to_evolve_fullscreen.this.rotate((float)Math.PI);
            i_want_to_evolve_fullscreen.this.fill((float)(64 + (int)(Math.random() * 192.0)) + i_want_to_evolve_fullscreen.sin((float)((float)i_want_to_evolve_fullscreen.this.millis() * 0.005f)) * 60.0f);
            i_want_to_evolve_fullscreen.this.text(this.greetText, this.x - 200.0f, this.y);
            i_want_to_evolve_fullscreen.this.popMatrix();
            i_want_to_evolve_fullscreen.this.popMatrix();
        }
    }
}

