/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import java.util.Vector;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class SAX2StAXBaseWriter
extends DefaultHandler
implements LexicalHandler {
    protected boolean isCDATA;
    protected StringBuffer CDATABuffer;
    protected Vector namespaces;
    protected Locator docLocator;
    protected XMLReporter reporter;

    public SAX2StAXBaseWriter() {
    }

    public SAX2StAXBaseWriter(XMLReporter xMLReporter) {
        this.reporter = xMLReporter;
    }

    public void setXMLReporter(XMLReporter xMLReporter) {
        this.reporter = xMLReporter;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.docLocator = locator;
    }

    public Location getCurrentLocation() {
        if (this.docLocator != null) {
            return new SAXLocation(this.docLocator);
        }
        return null;
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.reportException("ERROR", sAXParseException);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.reportException("FATAL", sAXParseException);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.reportException("WARNING", sAXParseException);
    }

    @Override
    public void startDocument() throws SAXException {
        this.namespaces = new Vector(2);
    }

    @Override
    public void endDocument() throws SAXException {
        this.namespaces = null;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.namespaces = null;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.namespaces = null;
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (string == null) {
            string = "";
        } else if (string.equals("xml")) {
            return;
        }
        if (this.namespaces == null) {
            this.namespaces = new Vector(2);
        }
        this.namespaces.addElement(string);
        this.namespaces.addElement(string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        this.isCDATA = true;
        if (this.CDATABuffer == null) {
            this.CDATABuffer = new StringBuffer();
        } else {
            this.CDATABuffer.setLength(0);
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.isCDATA) {
            this.CDATABuffer.append(cArray, n, n2);
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        this.isCDATA = false;
        this.CDATABuffer.setLength(0);
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    protected void reportException(String string, SAXException sAXException) throws SAXException {
        if (this.reporter != null) {
            try {
                this.reporter.report(sAXException.getMessage(), string, sAXException, this.getCurrentLocation());
            }
            catch (XMLStreamException xMLStreamException) {
                throw new SAXException(xMLStreamException);
            }
        }
    }

    public static final void parseQName(String string, String[] stringArray) {
        String string2;
        String string3;
        int n = string.indexOf(58);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        stringArray[0] = string3;
        stringArray[1] = string2;
    }

    private static final class SAXLocation
    implements Location {
        private int lineNumber;
        private int columnNumber;
        private String publicId;
        private String systemId;

        private SAXLocation(Locator locator) {
            this.lineNumber = locator.getLineNumber();
            this.columnNumber = locator.getColumnNumber();
            this.publicId = locator.getPublicId();
            this.systemId = locator.getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }

        @Override
        public int getColumnNumber() {
            return this.columnNumber;
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }
    }
}

