/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.analysis;

import ddf.minim.Minim;
import ddf.minim.analysis.WindowFunction;

public class GaussWindow
extends WindowFunction {
    double alpha;

    public GaussWindow(double d) {
        if (d < 0.0 || d > 0.5) {
            Minim.error("Range for GaussWindow out of bounds. Value must be <= 0.5");
            return;
        }
        this.alpha = d;
    }

    public GaussWindow() {
        this(0.25);
    }

    @Override
    protected float value(int n, int n2) {
        return (float)Math.pow(Math.E, -0.5 * Math.pow(((double)n2 - (double)(n - 1) / 2.0) / (this.alpha * (double)(n - 1) / 2.0), 2.0));
    }

    public String toString() {
        return "Gauss Window";
    }
}

