/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.LoginException;
import sun.misc.SharedSecrets;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.krb5.SubjectComber;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;

public class Krb5Util {
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));

    private Krb5Util() {
    }

    public static KerberosTicket getTicketFromSubjectAndTgs(GSSCaller gSSCaller, String string, String string2, String string3, AccessControlContext accessControlContext) throws LoginException, KrbException, IOException {
        Credentials credentials;
        Credentials credentials2;
        boolean bl;
        KerberosTicket kerberosTicket;
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket2 = SubjectComber.find(subject, string2, string, KerberosTicket.class);
        if (kerberosTicket2 != null) {
            return kerberosTicket2;
        }
        Subject subject2 = null;
        if (!GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            try {
                subject2 = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
                kerberosTicket2 = SubjectComber.find(subject2, string2, string, KerberosTicket.class);
                if (kerberosTicket2 != null) {
                    return kerberosTicket2;
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        if ((kerberosTicket = SubjectComber.find(subject, string3, string, KerberosTicket.class)) == null && subject2 != null) {
            kerberosTicket = SubjectComber.find(subject2, string3, string, KerberosTicket.class);
            bl = false;
        } else {
            bl = true;
        }
        if (kerberosTicket != null && (credentials2 = Credentials.acquireServiceCreds(string2, credentials = Krb5Util.ticketToCreds(kerberosTicket))) != null) {
            kerberosTicket2 = Krb5Util.credsToTicket(credentials2);
            if (bl && subject != null && !subject.isReadOnly()) {
                subject.getPrivateCredentials().add(kerberosTicket2);
            }
        }
        return kerberosTicket2;
    }

    static KerberosTicket getTicket(GSSCaller gSSCaller, String string, String string2, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket = SubjectComber.find(subject, string2, string, KerberosTicket.class);
        if (kerberosTicket == null && !GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            Subject subject2 = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
            kerberosTicket = SubjectComber.find(subject2, string2, string, KerberosTicket.class);
        }
        return kerberosTicket;
    }

    public static Subject getSubject(GSSCaller gSSCaller, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject == null && !GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            subject = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
        }
        return subject;
    }

    public static ServiceCreds getServiceCreds(GSSCaller gSSCaller, String string, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        ServiceCreds serviceCreds = null;
        if (subject != null) {
            serviceCreds = ServiceCreds.getInstance(subject, string);
        }
        if (serviceCreds == null && !GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            Subject subject2 = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
            serviceCreds = ServiceCreds.getInstance(subject2, string);
        }
        return serviceCreds;
    }

    public static KerberosTicket credsToTicket(Credentials credentials) {
        EncryptionKey encryptionKey = credentials.getSessionKey();
        return new KerberosTicket(credentials.getEncoded(), new KerberosPrincipal(credentials.getClient().getName()), new KerberosPrincipal(credentials.getServer().getName(), 2), encryptionKey.getBytes(), encryptionKey.getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
    }

    public static Credentials ticketToCreds(KerberosTicket kerberosTicket) throws KrbException, IOException {
        return new Credentials(kerberosTicket.getEncoded(), kerberosTicket.getClient().getName(), kerberosTicket.getServer().getName(), kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
    }

    public static EncryptionKey[] keysFromJavaxKeyTab(KeyTab keyTab, PrincipalName principalName) {
        return SharedSecrets.getJavaxSecurityAuthKerberosAccess().keyTabGetEncryptionKeys(keyTab, principalName);
    }

    public static class KeysFromKeyTab
    extends KerberosKey {
        public KeysFromKeyTab(KerberosKey kerberosKey) {
            super(kerberosKey.getPrincipal(), kerberosKey.getEncoded(), kerberosKey.getKeyType(), kerberosKey.getVersionNumber());
        }
    }

    public static class ServiceCreds {
        private KerberosPrincipal kp;
        private List<KeyTab> ktabs;
        private List<KerberosKey> kk;
        private Subject subj;

        private static ServiceCreds getInstance(Subject subject, String string) {
            ServiceCreds serviceCreds = new ServiceCreds();
            serviceCreds.subj = subject;
            for (KerberosPrincipal kerberosPrincipal : subject.getPrincipals(KerberosPrincipal.class)) {
                if (string != null && !kerberosPrincipal.getName().equals(string)) continue;
                serviceCreds.kp = kerberosPrincipal;
                string = kerberosPrincipal.getName();
                break;
            }
            if (serviceCreds.kp == null) {
                List<KerberosKey> list = SubjectComber.findMany(subject, null, null, KerberosKey.class);
                if (!list.isEmpty()) {
                    serviceCreds.kp = ((KerberosKey)list.get(0)).getPrincipal();
                    string = serviceCreds.kp.getName();
                    if (DEBUG) {
                        System.out.println(">>> ServiceCreds: no kp? find one from kk: " + string);
                    }
                } else {
                    return null;
                }
            }
            serviceCreds.ktabs = SubjectComber.findMany(subject, null, null, KeyTab.class);
            serviceCreds.kk = SubjectComber.findMany(subject, string, null, KerberosKey.class);
            if (serviceCreds.ktabs.isEmpty() && serviceCreds.kk.isEmpty()) {
                return null;
            }
            return serviceCreds;
        }

        public String getName() {
            return this.kp.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public KerberosKey[] getKKeys() {
            if (this.ktabs.isEmpty()) {
                return this.kk.toArray(new KerberosKey[this.kk.size()]);
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            Object set = this.ktabs.iterator();
            while (set.hasNext()) {
                KeyTab iterator = set.next();
                for (KerberosKey kerberosKey : iterator.getKeys(this.kp)) {
                    arrayList.add(kerberosKey);
                }
            }
            if (!this.subj.isReadOnly()) {
                Object object = set = this.subj.getPrivateCredentials();
                synchronized (object) {
                    Object object2 = set.iterator();
                    while (object2.hasNext()) {
                        KerberosKey kerberosKey;
                        Object e = object2.next();
                        if (!(e instanceof KeysFromKeyTab) || !Objects.equals((kerberosKey = (KerberosKey)e).getPrincipal(), this.kp)) continue;
                        object2.remove();
                    }
                }
                for (Object object2 : arrayList) {
                    this.subj.getPrivateCredentials().add(new KeysFromKeyTab((KerberosKey)object2));
                }
            }
            return arrayList.toArray(new KerberosKey[arrayList.size()]);
        }

        public EncryptionKey[] getEKeys() {
            KerberosKey[] kerberosKeyArray = this.getKKeys();
            EncryptionKey[] encryptionKeyArray = new EncryptionKey[kerberosKeyArray.length];
            for (int i = 0; i < encryptionKeyArray.length; ++i) {
                encryptionKeyArray[i] = new EncryptionKey(kerberosKeyArray[i].getEncoded(), kerberosKeyArray[i].getKeyType(), new Integer(kerberosKeyArray[i].getVersionNumber()));
            }
            return encryptionKeyArray;
        }

        public void destroy() {
            this.kp = null;
            this.ktabs = null;
            this.kk = null;
        }
    }
}

