/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PShape;
import processing.core.PVector;

public class derp
extends PApplet {
    int CANVAS_WIDTH = 1280;
    int CANVAS_HEIGHT = 720;
    float ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
    Moonlander moonlander;
    PShape shape;
    Planet planet;
    FractalTree tree0;
    int phase = 0;
    int prevMillis = 0;
    float t0 = 10000.0f;
    int delay = 0;
    float delayTime = 50000.0f;
    int mode = 0;

    public void setupAudio() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"DST-AngryRobotIII.mp3", (int)130, (int)16);
        this.moonlander.start();
    }

    public void setup() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics2D");
        this.frameRate(60.0f);
        this.noStroke();
        this.fill(255);
        this.smooth();
        this.planet = new Planet();
        this.planet.rot = (float)Math.PI;
        this.planet.scale = new PVector(0.75f, 0.75f);
        this.tree0 = new FractalTree();
        this.tree0.scale = new PVector(0.5f, 0.5f);
        this.tree0.branches = 6;
        this.tree0.maxLength = 0.5f;
        this.tree0.lifeLength = 0.0f;
        this.tree0.lifeAngles = 0.0f;
        this.tree0.lifeLengthMulti = 1.0f;
        this.tree0.lifeAngleMulti = 1.0f;
        this.tree0.lengthMulti = 1.0f;
        this.tree0.angleMulti = 1.0f;
        this.tree0.angles[0] = 2.094393f;
        this.tree0.angles[1] = 1.5707964f;
        this.tree0.angles[2] = 1.0471965f;
        this.setupAudio();
    }

    public void drawDemo(int n) {
        this.ellipse(0.0f + (float)(n % 100) * 0.01f, 0.0f, 1.0f, 1.0f);
    }

    public void drawAxes() {
        this.stroke(255);
        this.strokeWeight(0.004f);
        this.fill(255);
        this.line(-this.ASPECT_RATIO, 0.0f, this.ASPECT_RATIO, 0.0f);
        this.pushMatrix();
        this.resetMatrix();
        this.text(String.format("%.3f", Float.valueOf(-this.ASPECT_RATIO)), 12.0f, this.CANVAS_HEIGHT / 2);
        this.text(String.format("%.3f", Float.valueOf(this.ASPECT_RATIO)), this.CANVAS_WIDTH - 42, this.CANVAS_HEIGHT / 2);
        this.popMatrix();
        this.line(0.0f, -1.0f, 0.0f, 1.0f);
        this.pushMatrix();
        this.resetMatrix();
        this.text("1", this.CANVAS_WIDTH / 2 + 12, 12.0f);
        this.text("-1", this.CANVAS_WIDTH / 2 + 12, this.CANVAS_HEIGHT - 12);
        this.popMatrix();
    }

    public float easeinoutQuad(float f, float f2, float f3) {
        if ((f3 *= 2.0f) < 1.0f) {
            return 0.5f * f2 * f3 * f3 + f;
        }
        return -0.5f * f2 * ((f3 - 2.0f) * (f3 - 1.0f) - 1.0f) + f;
    }

    public void draw() {
        float f;
        if (this.mode == -1) {
            this.clear();
            this.resetMatrix();
            this.fill(255);
            this.textSize(30.0f);
            this.text("Greetings guys, see you at Assembly!", 0.0f, 30.0f);
            this.text("-Kajak Crew", 0.0f, 70.0f);
            this.text("Music: AngryRobotIII - Deceased Superior Technician", 0.0f, 150.0f);
            this.text("Attribution 3.0 Unported (CC BY 3.0)", 0.0f, 190.0f);
            return;
        }
        this.moonlander.update();
        this.resetMatrix();
        this.translate((float)this.CANVAS_WIDTH / 2.0f, (float)this.CANVAS_HEIGHT / 2.0f);
        this.scale((float)this.CANVAS_WIDTH / 2.0f / this.ASPECT_RATIO, (float)(-this.CANVAS_HEIGHT) / 2.0f);
        this.clear();
        this.mode = this.moonlander.getIntValue("mode");
        float f2 = (float)this.moonlander.getValue("ta");
        this.phase = this.moonlander.getIntValue("phase");
        float f3 = (float)this.moonlander.getValue("growth");
        if (f3 < 1.0f) {
            this.tree0.maxAngle = this.tree0.angles[(this.phase + 1) % 3];
            f = (float)((3 - this.phase + 1) % 3) * 0.5f + 1.0f;
            this.tree0.scale = new PVector(f, f);
            this.tree0.lifeLength = f3;
            this.tree0.lifeAngles = f3;
        } else {
            this.tree0.maxAngle = derp.map((float)f2, (float)0.0f, (float)1.0f, (float)this.tree0.angles[this.phase], (float)this.tree0.angles[(this.phase + 1) % 3]);
            f = derp.map((float)f2, (float)0.0f, (float)1.0f, (float)((float)(2 - this.phase) * 0.5f + 1.0f), (float)((float)((3 - this.phase + 1) % 3) * 0.5f + 1.0f));
            this.tree0.scale = new PVector(f, f);
            f2 = derp.abs((float)(2.0f * (f2 - 0.5f))) * 0.5f + 0.5f;
            this.tree0.lifeLength = 1.0f;
            this.tree0.lifeAngles = 1.0f;
        }
        this.tree0.display();
        if (this.mode == 1 || this.mode == -1) {
            f = (float)this.moonlander.getValue("waterAssist");
            if (f < 1.0f) {
                this.planet.water.planetScale0 = f * (float)this.moonlander.getValue("scale0");
                this.planet.water.planetScale1 = f * (float)this.moonlander.getValue("scale1");
            } else {
                this.planet.water.planetScale0 = (float)this.moonlander.getValue("scale0");
                this.planet.water.planetScale1 = (float)this.moonlander.getValue("scale1");
            }
            this.planet.display(0.0f);
        }
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 37) {
                this.planet.water.scale = new PVector(0.1f + this.planet.water.scale.x, 0.1f + this.planet.water.scale.y);
            } else if (this.keyCode == 39) {
                this.planet.water.scale = new PVector(0.1f - this.planet.water.scale.x, 0.1f - this.planet.water.scale.y);
            }
        } else if (this.key != ' ') {
            // empty if block
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "derp"};
        if (stringArray != null) {
            PApplet.main((String[])derp.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class FractalTree {
        PVector pos;
        PVector scale;
        float rot = 0.0f;
        float[] angles = new float[3];
        int branches = 6;
        float maxAngle = 1.0461504f;
        float maxLength = 0.5f;
        float lifeLength = 0.0f;
        float lifeAngles = 0.0f;
        float lifeLengthMulti = 1.0f;
        float lifeAngleMulti = 1.0f;
        float lengthMulti = 1.0f;
        float angleMulti = 1.0f;

        FractalTree() {
            this.pos = new PVector(0.0f, 0.0f);
            this.scale = new PVector(1.0f, 1.0f);
            this.angles[0] = 2.094393f;
            this.angles[1] = 1.5707964f;
            this.angles[2] = 1.0471965f;
        }

        public void display() {
            derp.this.pushMatrix();
            derp.this.translate(this.pos.x, this.pos.y);
            derp.this.scale(this.scale.x, this.scale.y);
            derp.this.rotate(this.rot);
            derp.this.stroke(255);
            derp.this.strokeWeight(0.01f);
            this.branch(0, this.lifeLength, this.lifeAngles, this.maxLength, this.maxAngle);
            derp.this.popMatrix();
        }

        public void branch(int n, float f, float f2, float f3, float f4) {
            if (n < this.branches) {
                derp.this.pushMatrix();
                float f5 = f2 * f4;
                derp.this.rotate(derp.min((float)f5, (float)f4));
                float f6 = f * f3;
                derp.this.line(0.0f, 0.0f, 0.0f, 0.0f, derp.min((float)f6, (float)f3), 0.0f);
                derp.this.translate(0.0f, derp.min((float)f6, (float)f3));
                this.branch(n + 1, f * this.lifeLengthMulti, f2 * this.lifeAngleMulti, f3 * this.lengthMulti, f4 * this.angleMulti);
                derp.this.popMatrix();
                derp.this.pushMatrix();
                derp.this.rotate(-derp.min((float)f5, (float)f4));
                derp.this.line(0.0f, 0.0f, 0.0f, 0.0f, derp.min((float)f6, (float)f3), 0.0f);
                derp.this.translate(0.0f, derp.min((float)f6, (float)f3));
                this.branch(n + 1, f * this.lifeLengthMulti, f2 * this.lifeAngleMulti, f3 * this.lengthMulti, f4 * this.angleMulti);
                derp.this.popMatrix();
            }
        }

        public void branch2(int n, float f, float f2, float f3, float f4) {
            if (n < this.branches) {
                derp.this.pushMatrix();
                float f5 = f2 * f4;
                derp.this.rotate(derp.min((float)f5, (float)f4));
                float f6 = f * f3;
                derp.this.line(0.0f, 0.0f, 0.0f, 0.0f, derp.min((float)f6, (float)f3), 0.0f);
                derp.this.translate(0.0f, derp.min((float)f6, (float)f3));
                this.branch2(n + 1, f - this.lifeLengthMulti, f2 - this.lifeAngleMulti, f3 * this.lengthMulti, f4 * this.angleMulti);
                derp.this.popMatrix();
                derp.this.pushMatrix();
                derp.this.rotate(-derp.min((float)f5, (float)f4));
                derp.this.line(0.0f, 0.0f, 0.0f, 0.0f, derp.min((float)f6, (float)f3), 0.0f);
                derp.this.translate(0.0f, derp.min((float)f6, (float)f3));
                this.branch2(n + 1, f - this.lifeLengthMulti, f2 - this.lifeAngleMulti, f3 * this.lengthMulti, f4 * this.angleMulti);
                derp.this.popMatrix();
            }
        }
    }

    class Ground {
        PVector pos = new PVector(0.0f, 0.0f, 0.0f);
        PVector scale = new PVector(1.0f, 1.0f);
        float rot = 0.0f;

        Ground() {
        }

        public void display(float f) {
            derp.this.pushMatrix();
            derp.this.translate(this.pos.x, this.pos.y);
            derp.this.scale(this.scale.x, this.scale.y);
            derp.this.rotate(this.rot);
            derp.this.fill(0.0f, 255.0f, 0.0f);
            derp.this.shape(derp.this.shape, 0.0f, 0.0f, this.scale.x * 2.0f, this.scale.y * 2.0f);
            derp.this.popMatrix();
        }
    }

    class Planet {
        Water water;
        Ground ground;
        PVector pos = new PVector(0.0f, 0.0f, 0.0f);
        PVector scale = new PVector(1.0f, 1.0f);
        float rot = 0.0f;

        Planet() {
            this.ground = new Ground();
            this.water = new Water();
            float f = 1.1f;
            this.water.scale = new PVector(f, f);
            this.water.planetScale0 = 0.5f;
            this.ground.pos.x = 0.0f;
            this.ground.pos.y = -0.075f;
        }

        public void display(float f) {
            derp.this.pushMatrix();
            derp.this.translate(this.pos.x, this.pos.y);
            derp.this.scale(this.scale.x, this.scale.y);
            derp.this.rotate(this.rot);
            this.water.display(f);
            derp.this.popMatrix();
        }
    }

    class Water {
        int waterColor;
        float yoff;
        float planetScale0;
        float planetScale1;
        int points;
        int smoothing;
        PVector pos;
        PVector scale;
        float rot;

        Water() {
            this.waterColor = derp.this.color(50, 50, 255);
            this.yoff = 0.0f;
            this.planetScale0 = 0.85f;
            this.planetScale1 = 1.0f;
            this.points = 100;
            this.smoothing = 50;
            this.pos = new PVector(0.0f, 0.0f, 0.0f);
            this.scale = new PVector(1.0f, 1.0f);
            this.rot = 0.0f;
        }

        public void display(float f) {
            float f2;
            float f3;
            derp.this.pushMatrix();
            derp.this.translate(this.pos.x, this.pos.y);
            derp.this.scale(this.scale.x, this.scale.y);
            derp.this.rotate(this.rot);
            derp.this.noStroke();
            derp.this.beginShape();
            float f4 = 0.0f;
            float f5 = 0.0f;
            while (f5 < (float)(this.points - 1 - this.smoothing)) {
                f3 = derp.map((float)derp.this.noise(f4, this.yoff), (float)0.0f, (float)1.0f, (float)this.planetScale0, (float)this.planetScale1);
                f2 = f5 * (float)Math.PI * 2.0f / (float)this.points;
                derp.this.fill(50.0f, 50.0f, 255.0f - f3 * (derp.sin((float)f2) + 1.0f) * 0.5f);
                derp.this.vertex(f3 * derp.cos((float)f2), f3 * derp.sin((float)f2));
                f4 += 0.05f;
                f5 += 1.0f;
            }
            f5 = this.points - 1 - this.smoothing;
            while (f5 <= (float)(this.points - 1)) {
                f3 = derp.map((float)derp.this.noise(f4, this.yoff), (float)0.0f, (float)1.0f, (float)this.planetScale0, (float)this.planetScale1);
                f2 = derp.map((float)derp.this.noise((f5 - (float)this.points) * 0.05f, this.yoff), (float)0.0f, (float)1.0f, (float)this.planetScale0, (float)this.planetScale1);
                float f6 = derp.map((float)f5, (float)(this.points - 1 - this.smoothing), (float)(this.points - 1), (float)f3, (float)f2);
                float f7 = f5 * (float)Math.PI * 2.0f / (float)this.points;
                derp.this.fill(50.0f, 50.0f, 255.0f - f6 * (derp.sin((float)f7) + 1.0f) * 0.5f);
                derp.this.vertex(f6 * derp.cos((float)f7), f6 * derp.sin((float)f7));
                f4 += 0.05f;
                f5 += 1.0f;
            }
            this.yoff += 0.01f;
            derp.this.endShape(2);
            derp.this.popMatrix();
        }
    }
}

