/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.ArrayList;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;

public class smoke
extends PApplet {
    AudioPlayer player;
    Minim minim;
    PShape s;
    PFont f;
    float i = 0.0f;
    ParticleSystem ps0;
    ParticleSystem ps1;
    ParticleSystem ps2;
    ParticleSystem ps3;
    ParticleSystem ps4;
    ParticleSystem ps5;
    ParticleSystem ps6;
    ParticleSystem ps7;
    ParticleSystem ps8;
    ParticleSystem ps9;
    ParticleSystem ps10;
    ParticleSystem ps11;

    public void setup() {
        this.size(1280, 720, "processing.opengl.PGraphics3D");
        this.ps0 = new ParticleSystem(0, new PVector((float)(this.width / 2), (float)(this.height / 2)));
        this.ps1 = new ParticleSystem(0, new PVector((float)this.width, (float)(this.height / 2)));
        this.ps2 = new ParticleSystem(0, new PVector((float)this.width, 0.0f));
        this.ps3 = new ParticleSystem(0, new PVector((float)(this.width / 2), 0.0f));
        this.ps4 = new ParticleSystem(0, new PVector((float)(this.width / 2), (float)(this.height / 2), (float)(this.width / 2)));
        this.ps5 = new ParticleSystem(0, new PVector((float)this.width, (float)(this.height / 2), (float)(this.width / 2)));
        this.ps6 = new ParticleSystem(0, new PVector((float)this.width, 0.0f, (float)(this.width / 2)));
        this.ps7 = new ParticleSystem(0, new PVector((float)(this.width / 2), 0.0f, (float)(this.width / 2)));
        this.ps8 = new ParticleSystem(0, new PVector((float)(this.width / 2), (float)(this.height / 2), (float)(-this.width / 2)));
        this.ps9 = new ParticleSystem(0, new PVector((float)this.width, (float)(this.height / 2), (float)(-this.width / 2)));
        this.ps10 = new ParticleSystem(0, new PVector((float)this.width, 0.0f, (float)(-this.width / 2)));
        this.ps11 = new ParticleSystem(0, new PVector((float)(this.width / 2), 0.0f, (float)(-this.width / 2)));
        this.setupMusic();
        this.s = this.loadShape("face.obj");
        this.f = this.createFont("Arial", 72.0f, true);
    }

    public void setupMusic() {
        this.minim = new Minim((Object)this);
        this.player = this.minim.loadFile("music.mp3", 2048);
        this.player.play();
    }

    public void draw() {
        this.setupWorldViews();
        this.setupParticleSystems();
    }

    public void setupWorldViews() {
        this.background(0);
        this.camera(smoke.sin((float)((float)this.millis() * 5.0E-4f)) * ((float)this.width / 2.0f), (float)this.height * 0.25f, smoke.cos((float)((float)this.millis() * 5.0E-4f)) * (float)(this.width / 2), this.width, smoke.sin((float)((float)this.millis() * 0.001f)) * (float)this.height, 0.0f, 0.0f, 1.0f, 0.0f);
        this.perspective();
        this.ambientLight(255.0f, 255.0f, 255.0f);
        this.directionalLight(255.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        this.directionalLight(255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        this.directionalLight(0.0f, 255.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        this.directionalLight(0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        this.directionalLight(0.0f, 0.0f, 255.0f, 0.0f, 0.0f, 1.0f);
        this.directionalLight(0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f);
        this.pushMatrix();
        this.translate((float)this.width * 0.75f, (float)this.height * 0.25f, 0.0f);
        this.rotate(this.i, 1.0f, -1.0f, 1.0f);
        this.scale(smoke.sin((float)((float)this.millis() * 5.0E-4f)) * smoke.sin((float)((float)this.millis() * 5.0E-4f)) * 10.0f + 1.0f);
        this.shape(this.s);
        this.popMatrix();
        this.i += 0.05f;
        this.pushMatrix();
        this.textFont(this.f);
        this.fill(255);
        this.translate(this.width, -this.height, 0.0f);
        this.rotate(1.5707964f, 0.0f, -1.0f, 0.0f);
        this.text("Demoscene: 3D Fire Disco", 0.0f, 0.0f);
        this.text("Made by unixman", 0.0f, 72.0f);
        this.text("For Graffathon 2015", 0.0f, 144.0f);
        this.popMatrix();
    }

    public void setupParticleSystems() {
        this.runParticleSystem(this.ps0);
        this.runParticleSystem(this.ps1);
        this.runParticleSystem(this.ps2);
        this.runParticleSystem(this.ps3);
        this.runParticleSystem(this.ps4);
        this.runParticleSystem(this.ps5);
        this.runParticleSystem(this.ps6);
        this.runParticleSystem(this.ps7);
        this.runParticleSystem(this.ps8);
        this.runParticleSystem(this.ps9);
        this.runParticleSystem(this.ps10);
        this.runParticleSystem(this.ps11);
    }

    public void runParticleSystem(ParticleSystem particleSystem) {
        float f = smoke.sin((float)((float)this.millis() * 0.001f)) * 0.01f;
        float f2 = smoke.cos((float)((float)this.millis() * 0.001f)) * 0.01f;
        PVector pVector = new PVector(f, f2);
        particleSystem.applyForce(pVector);
        particleSystem.run();
        int n = 0;
        while (n < 2) {
            particleSystem.addParticle();
            ++n;
        }
    }

    public void stop() {
        this.player.close();
        this.minim.stop();
        super.stop();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "smoke"};
        if (stringArray != null) {
            PApplet.main((String[])smoke.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Particle {
        PVector loc;
        PVector vel;
        PVector acc = new PVector(0.0f, 0.0f);
        float lifespan;
        PImage img;

        Particle(PVector pVector, PImage pImage) {
            float f = smoke.this.randomGaussian() * 0.3f;
            float f2 = smoke.this.randomGaussian() * 0.3f - 1.0f;
            this.vel = new PVector(f, f2);
            this.loc = pVector.get();
            this.lifespan = 500.0f;
        }

        public void run() {
            this.update();
            this.render();
        }

        public void applyForce(PVector pVector) {
            this.acc.add(pVector);
        }

        public void update() {
            this.vel.add(this.acc);
            this.loc.add(this.vel);
            this.lifespan -= 2.5f;
            this.acc.mult(0.0f);
        }

        public void render() {
            smoke.this.fill(240.0f, 117.0f, 17.0f, this.lifespan);
            smoke.this.noStroke();
            smoke.this.pushMatrix();
            smoke.this.translate(this.loc.x, this.loc.y, this.loc.z);
            smoke.this.box(10.0f);
            smoke.this.popMatrix();
        }

        public boolean isDead() {
            return this.lifespan <= 0.0f;
        }
    }

    class ParticleSystem {
        ArrayList<Particle> particles = new ArrayList();
        PVector origin;
        PImage img;

        ParticleSystem(int n, PVector pVector) {
            this.origin = pVector.get();
            int n2 = 0;
            while (n2 < n) {
                this.particles.add(new Particle(this.origin, this.img));
                ++n2;
            }
        }

        public void run() {
            int n = this.particles.size() - 1;
            while (n >= 0) {
                Particle particle = this.particles.get(n);
                particle.run();
                if (particle.isDead()) {
                    this.particles.remove(n);
                }
                --n;
            }
        }

        public void applyForce(PVector pVector) {
            for (Particle particle : this.particles) {
                particle.applyForce(pVector);
            }
        }

        public void addParticle() {
            this.particles.add(new Particle(this.origin, this.img));
        }
    }
}

