
function Round(x: real): cardinal;
//----------------------------------------------------------------------------------------------
// Round floating point value to nearest integer number
// Result :=  cardinal(x) shr FracBits;
//----------------------------------------------------------------------------------------------
begin

asm
{	mva x+1 result
	mva x+2 result+1
	mva x+3 result+2
	mva #0 result+3

	lda x
	spl
	ind result
};

end;



function Trunc(x: real): cardinal;
//----------------------------------------------------------------------------------------------
// Truncate a floating point value
//----------------------------------------------------------------------------------------------
begin

asm
{	mva x+1 result
	mva x+2 result+1
	mva x+3 result+2
	mva #0 result+3
};

end;



function Frac(x: real): real;
//----------------------------------------------------------------------------------------------
// Return fractional part of floating point value
//----------------------------------------------------------------------------------------------
begin

asm
{	mva x result
	mva #0 result+1
	sta result+2
	sta result+3
};

end;



function IntToReal(x: cardinal): Real;
begin

//  Result :=  Real(x shl FracBits);

asm
{	mva x+2 result+3
	mva x+1 result+2
	mva x result+1
	mva #0 result
};

end;



function fsin(deg: word): real;
// Bhaskara's Approximation  DEG = <0..180>
var c, x, y: word;

    a,b: real;
begin
 
 c := deg * (180 - deg);

 x := 4*c;
 y := 40500 - c;

asm
{	mva #0 a+3	; x (word) -> a (real)
	mva x+1 a+2
	mva x a+1
	mva #0 a

	mva #0 b+3	; y (word) -> b (real)
	mva y+1 b+2
	mva y b+1
	mva #0 b
};

// Result := CardToReal(x) / CardToReal(y);

  Result := a / b;

end;



function fcos(deg: word): real;
begin
 
 Result := fsin(deg+90);

end;



{
function sin(deg: real): real;
// Bhaskara's Approximation  DEG = <0..180>
var c,x,y: real;
begin
 
 c := deg * (180.0 - deg);

 x := 4.0*c;
 y := 40500.0 - c;

 Result := x / y;
end;



function cos(deg: real): real;
begin
 
 Result := sin(deg+90.0);

end;
}

