// Eratosthenes Sieve benchmark

// uses crt;

const
 size = 255;
 sizepl = 256;

 iter_max = 10;

var 
  flags: array [0..sizepl] of boolean;

  iter: byte;

  i,k,count: word;

  prime: word;


function time: byte;
begin
asm
{	ldx @sp
	mva rtclok+2 Result
};

end;


begin
	writeln(iter_max,' iterations');

asm
{
	lda:cmp:req rtclok+2	; reset clock
	lda #0
	sta rtclok
	sta rtclok+1
	sta rtclok+2
};

	iter := 1;
	while (iter <= iter_max) do begin

		count := 0;
		i := 0;

		while (i <= size) do begin
			flags[i] := true;
			inc(i);
		end;

		i := 0;
		while (i <= size) do begin

			if flags[i] then begin

				prime := i shl 1 + 3;
				k := i + prime;

				while (k <= size) do begin
					flags[k] := false;
					k := k + prime;
				end;
				inc(count);
			end;
			inc(i);
		end;

		inc(iter);
	end;

 writeln(count, ' primes');
 writeln(time, ' fps');

 repeat until keypressed;

end.
