
const
 eol = #$9b;


procedure TextMode(mode: byte);
begin

asm
{	mva mode putchar.invers
};

end;


procedure TextBackground(a: byte);
begin

asm
{	mwa a colpf2s
};

end;


procedure TextColor(a: byte);
begin

asm
{	lda a
	and #$0f
	sta colpf1s
};

end;


procedure Delay(count: word);
begin

asm
{	stx @sp

	ldx #0
	ldy #0

loop	cpy count
	bne @+
	cpx count+1
	beq stop

@	lda:cmp:req vcount

	iny
	sne
	inx

	bne loop

stop	ldx @sp
};

end;


function Keypressed: Boolean;
begin

asm
{	ldy #$00	; false
	lda skstat
	and #4
	sne
	dey		; true
	sty Result
};

end;


procedure ClrScr;
//----------------------------------------------------------------------------------------------
// Clear screen
//----------------------------------------------------------------------------------------------
begin

 write( chr(125) );

end;


procedure GotoXY(x,y: byte);
//----------------------------------------------------------------------------------------------
// Set cursor position on screen
//----------------------------------------------------------------------------------------------
begin

asm
{	mva x 85
	mva y 84
};

end;


function WhereX: byte;
//----------------------------------------------------------------------------------------------
// Return X (horizontal) cursor position
//----------------------------------------------------------------------------------------------
begin

asm
{	mva 85 result
};

end;


function WhereY: byte;
//----------------------------------------------------------------------------------------------
// Return Y (vertical) cursor position
//----------------------------------------------------------------------------------------------
begin

asm
{	mva 84 result
};

end;
  

