MAXSIZE = 4
EOL	= $9B

	icl 'atari.hea'

.proc	movaBX_EAX		; mov [BX], EAX
	:MAXSIZE mva eax+# STACKORIGIN-1+#*STACKWIDTH,x
	rts
.endp

.proc	pushBYTE
	adc STACKORIGIN+STACKWIDTH,x
	sta bp+1

	lda (bp),y

	sta STACKORIGIN,x
;	lda #$00
;	sta STACKORIGIN+STACKWIDTH,x
;	sta STACKORIGIN+STACKWIDTH*2,x
;	sta STACKORIGIN+STACKWIDTH*3,x

	rts
.endp

.proc	pushWORD
	adc STACKORIGIN+STACKWIDTH,x
	sta bp+1

	lda (bp),y
	sta STACKORIGIN,x
	iny
	lda(bp),y
	sta STACKORIGIN+STACKWIDTH,x
;	lda #$00
;	sta STACKORIGIN+STACKWIDTH*2,x
;	sta STACKORIGIN+STACKWIDTH*3,x

	rts
.endp

.proc	pushCARDINAL
	adc STACKORIGIN+STACKWIDTH,x
	sta bp+1

	lda (bp),y
	sta STACKORIGIN,x
	iny
	lda(bp),y
	sta STACKORIGIN+STACKWIDTH,x
	iny
	lda(bp),y
	sta STACKORIGIN+STACKWIDTH*2,x
	iny
	lda(bp),y
	sta STACKORIGIN+STACKWIDTH*3,x

	rts
.endp

.proc	incaBX
;	ldx @sp
	inc STACKORIGIN,x
	sne
	inc STACKORIGIN+STACKWIDTH,x
	rts
.endp

.proc	shlAL_CL
;	ldx @sp
	ldy STACKORIGIN,x	; cl
@	asl STACKORIGIN-1,x	; eax
	dey
	bne @-
	rts
.endp

.proc	shlAX_CL
;	ldx @sp
	ldy STACKORIGIN,x	; cl
@	asl STACKORIGIN-1,x	; eax
	rol STACKORIGIN-1+STACKWIDTH,x
	dey
	bne @-
	rts
.endp

.proc	shlEAX_CL
;	ldx @sp
	ldy STACKORIGIN,x	; cl
@	asl STACKORIGIN-1,x	; eax
	rol STACKORIGIN-1+STACKWIDTH,x
	rol STACKORIGIN-1+STACKWIDTH*2,x
	rol STACKORIGIN-1+STACKWIDTH*3,x
	dey
	bne @-
	rts
.endp


.proc	shrAL_CL
;	ldx @sp
	ldy STACKORIGIN,x	; cl
@	lsr STACKORIGIN-1,x
	dey
	bne @-
	rts
.endp

.proc	shrAX_CL
;	ldx @sp
	ldy STACKORIGIN,x	; cl
@	lsr STACKORIGIN-1+STACKWIDTH,x
	ror STACKORIGIN-1,x
	dey
	bne @-
	rts
.endp

.proc	shrEAX_CL
;	ldx @sp
	ldy STACKORIGIN,x	; cl
@	lsr STACKORIGIN-1+STACKWIDTH*3,x
	ror STACKORIGIN-1+STACKWIDTH*2,x
	ror STACKORIGIN-1+STACKWIDTH,x
	ror STACKORIGIN-1,x
	dey
	bne @-
	rts
.endp


.proc	addAL_CL
;	ldx @sp
	lda #0
	sta STACKORIGIN-1+STACKWIDTH,x
	sta STACKORIGIN-1+STACKWIDTH*2,x
	sta STACKORIGIN-1+STACKWIDTH*3,x

	lda STACKORIGIN-1,x
	add STACKORIGIN,x
	sta STACKORIGIN-1,x
	scc
	inc STACKORIGIN-1+STACKWIDTH,x

	rts
.endp

.proc	addAX_CX
;	ldx @sp
	lda STACKORIGIN-1,x
	add STACKORIGIN,x
	sta STACKORIGIN-1,x

	lda STACKORIGIN-1+STACKWIDTH,x
	adc STACKORIGIN+STACKWIDTH,x
	sta STACKORIGIN-1+STACKWIDTH,x

;	scc
;	mva #$01 STACKORIGIN-1+STACKWIDTH*2,x
	
	rts
.endp

.proc	addEAX_ECX
;	ldx @sp
	lda STACKORIGIN-1,x
	add STACKORIGIN,x
	sta STACKORIGIN-1,x

	lda STACKORIGIN-1+STACKWIDTH,x
	adc STACKORIGIN+STACKWIDTH,x
	sta STACKORIGIN-1+STACKWIDTH,x

	lda STACKORIGIN-1+STACKWIDTH*2,x
	adc STACKORIGIN+STACKWIDTH*2,x
	sta STACKORIGIN-1+STACKWIDTH*2,x

	lda STACKORIGIN-1+STACKWIDTH*3,x
	adc STACKORIGIN+STACKWIDTH*3,x
	sta STACKORIGIN-1+STACKWIDTH*3,x

	rts
.endp

.proc	subAL_CL
;	ldx @sp
	lda STACKORIGIN-1,x
	sub STACKORIGIN,x
	sta STACKORIGIN-1,x

	rts
.endp

.proc	subAX_CX
;	ldx @sp
	lda STACKORIGIN-1,x		; ax
	sub STACKORIGIN,x		; cx
	sta STACKORIGIN-1,x

	lda STACKORIGIN-1+STACKWIDTH,x
	sbc STACKORIGIN+STACKWIDTH,x
	sta STACKORIGIN-1+STACKWIDTH,x

	rts
.endp

.proc	subEAX_ECX
;	ldx @sp
	lda STACKORIGIN-1,x
	sub STACKORIGIN,x
	sta STACKORIGIN-1,x

	lda STACKORIGIN-1+STACKWIDTH,x
	sbc STACKORIGIN+STACKWIDTH,x
	sta STACKORIGIN-1+STACKWIDTH,x

	lda STACKORIGIN-1+STACKWIDTH*2,x
	sbc STACKORIGIN+STACKWIDTH*2,x
	sta STACKORIGIN-1+STACKWIDTH*2,x

	lda STACKORIGIN-1+STACKWIDTH*3,x
	sbc STACKORIGIN+STACKWIDTH*3,x
	sta STACKORIGIN-1+STACKWIDTH*3,x

	rts
.endp

.proc	cmpAX_CX
	lda STACKORIGIN-1+STACKWIDTH,x
	cmp STACKORIGIN+STACKWIDTH,x
	bne _done
	lda STACKORIGIN-1,x
	cmp STACKORIGIN,x

_done	rts
.endp

.proc	cmpEAX_ECX
	lda STACKORIGIN-1+STACKWIDTH*3,x
	cmp STACKORIGIN+STACKWIDTH*3,x
	bne _done
	lda STACKORIGIN-1+STACKWIDTH*2,x
	cmp STACKORIGIN+STACKWIDTH*2,x
	bne _done
	lda STACKORIGIN-1+STACKWIDTH,x
	cmp STACKORIGIN+STACKWIDTH,x
	bne _done
	lda STACKORIGIN-1,x
	cmp STACKORIGIN,x

_done	rts
.endp


.proc	notaBXm1
;	ldx @sp

	.rept MAXSIZE
	lda STACKORIGIN-1+#*STACKWIDTH,x
	eor #$ff
	sta STACKORIGIN-1+#*STACKWIDTH,x
	.endr
	rts
.endp


.proc	notaBX
;	ldx @sp

	.rept MAXSIZE
	lda STACKORIGIN+#*STACKWIDTH,x
	eor #$ff
	sta STACKORIGIN+#*STACKWIDTH,x
	.endr
	rts
.endp


.proc	negaBX
;	ldx @sp

	lda #$00
	sub STACKORIGIN,x
	sta STACKORIGIN,x

	lda #$00
	sbc STACKORIGIN+STACKWIDTH,x
	sta STACKORIGIN+STACKWIDTH,x

	lda #$00
	sbc STACKORIGIN+STACKWIDTH*2,x
	sta STACKORIGIN+STACKWIDTH*2,x

	lda #$00
	sbc STACKORIGIN+STACKWIDTH*3,x
	sta STACKORIGIN+STACKWIDTH*3,x

	rts
.endp


.proc	andAL_CL
;	ldx @sp

	lda STACKORIGIN-1,x
	and STACKORIGIN,x
	sta STACKORIGIN-1,x
	rts
.endp

.proc	andAX_CX
;	ldx @sp

	.rept 2
	lda STACKORIGIN-1+#*STACKWIDTH,x
	and STACKORIGIN+#*STACKWIDTH,x
	sta STACKORIGIN-1+#*STACKWIDTH,x
	.endr
	rts
.endp

.proc	andEAX_ECX
;	ldx @sp

	.rept MAXSIZE
	lda STACKORIGIN-1+#*STACKWIDTH,x
	and STACKORIGIN+#*STACKWIDTH,x
	sta STACKORIGIN-1+#*STACKWIDTH,x
	.endr
	rts
.endp


.proc	orAL_CL
;	ldx @sp

	lda STACKORIGIN-1,x
	ora STACKORIGIN,x
	sta STACKORIGIN-1,x
	rts
.endp

.proc	orAX_CX
;	ldx @sp

	.rept 2
	lda STACKORIGIN-1+#*STACKWIDTH,x
	ora STACKORIGIN+#*STACKWIDTH,x
	sta STACKORIGIN-1+#*STACKWIDTH,x
	.endr
	rts
.endp

.proc	orEAX_ECX
;	ldx @sp

	.rept MAXSIZE
	lda STACKORIGIN-1+#*STACKWIDTH,x
	ora STACKORIGIN+#*STACKWIDTH,x
	sta STACKORIGIN-1+#*STACKWIDTH,x
	.endr
	rts
.endp


.proc	xorAL_CL
;	ldx @sp

	lda STACKORIGIN-1,x
	eor STACKORIGIN,x
	sta STACKORIGIN-1,x
	rts
.endp

.proc	xorAX_CX
;	ldx @sp

	.rept 2
	lda STACKORIGIN-1+#*STACKWIDTH,x
	eor STACKORIGIN+#*STACKWIDTH,x
	sta STACKORIGIN-1+#*STACKWIDTH,x
	.endr
	rts
.endp

.proc	xorEAX_ECX
;	ldx @sp

	.rept MAXSIZE
	lda STACKORIGIN-1+#*STACKWIDTH,x
	eor STACKORIGIN+#*STACKWIDTH,x
	sta STACKORIGIN-1+#*STACKWIDTH,x
	.endr
	rts
.endp


.proc	iniAL_CL
	mva STACKORIGIN,x ecx
	mva #$00 ecx+1
	sta ecx+2
	sta ecx+3

	mva STACKORIGIN-1,x eax
	mva #$00 eax+1
	sta eax+2
	sta eax+3
	rts
.endp

.proc	iniAX_CX
	mva STACKORIGIN,x ecx
	mva STACKORIGIN+STACKWIDTH,x ecx+1
	mva #$00 ecx+2
	sta ecx+3

	mva STACKORIGIN-1,x eax
	mva STACKORIGIN-1+STACKWIDTH,x eax+1
	mva #$00 eax+2
	sta eax+3

	rts
.endp

.proc	iniEAX_ECX
	mva STACKORIGIN,x ecx
	mva STACKORIGIN+STACKWIDTH,x ecx+1
	mva STACKORIGIN+STACKWIDTH*2,x ecx+2
	mva STACKORIGIN+STACKWIDTH*3,x ecx+3

	mva STACKORIGIN-1,x eax
	mva STACKORIGIN-1+STACKWIDTH,x eax+1
	mva STACKORIGIN-1+STACKWIDTH*2,x eax+2
	mva STACKORIGIN-1+STACKWIDTH*3,x eax+3

	rts
.endp

.proc	movZTMP_aBX
	mva ZTMP8 STACKORIGIN-1,x
	mva ZTMP9 STACKORIGIN-1+STACKWIDTH,x
	mva ZTMP10 STACKORIGIN-1+STACKWIDTH*2,x
	mva ZTMP11 STACKORIGIN-1+STACKWIDTH*3,x

	rts
.endp



.proc	divREAl
	ldy #0

	lda STACKORIGIN-1+STACKWIDTH*3,x	; dividend sign
	bpl @+
	jsr notaBXm1
	iny

@	lda STACKORIGIN+STACKWIDTH*3,x		; divisor sign
	bpl @+
	jsr notaBX
	iny

@	lda tsign,y
	pha

;	ldy #FRACBITS
;	jsr shlEAX_CL+3

	mva STACKORIGIN-1+STACKWIDTH*2,x STACKORIGIN-1+STACKWIDTH*3,x
	mva STACKORIGIN-1+STACKWIDTH,x STACKORIGIN-1+STACKWIDTH*2,x
	mva STACKORIGIN-1,x STACKORIGIN-1+STACKWIDTH,x
	mva #$00 STACKORIGIN-1,x
	
	jsr iniEAX_ECX
	jsr idivECX			; idiv ecx
	jsr movaBX_EAX

	pla
	spl

	jmp notaBXm1

	rts

tsign	dta 0,$80,0
.endp



;32 bit multiply with 64 bit product

.proc	imul64
	lda #$00
	sta edx		;Clear upper half of
	sta edx+1	;product
	sta edx+2
	sta edx+3

	sta ztmp8
	sta ztmp9
	sta ztmp10
	sta ztmp11

	ldy #$20	;Set binary count to 32
SHIFT_R	lsr eax+3	;Shift multiplyer right
	ror eax+2
	ror eax+1
	ror eax
	bcc ROTATE_R	;Go rotate right if c = 0
	lda edx		;Get upper half of product
	clc		;and add multiplicand to
	adc ecx		;it
	sta edx
	lda edx+1
	adc ecx+1
	sta edx+1
	lda edx+2
	adc ecx+2
	sta edx+2
	lda edx+3
	adc ecx+3
ROTATE_R  ror @		;Rotate partial product
        sta edx+3	;right
        ror edx+2
        ror edx+1
        ror edx
        ror ztmp11
        ror ztmp10
        ror ztmp9
        ror ztmp8
        dey		;Decrement bit count and
        bne SHIFT_R	;loop until 32 bits are

	mva ztmp8 eax
	mva ztmp9 eax+1
	mva ztmp10 eax+2
	mva ztmp11 eax+3

;	clc		;done
;	lda MULXP1	;Add dps and put sum in MULXP2
;	adc MULXP2
;	sta MULXP2
	rts
.endp


.proc	mulREAl
	ldy #0

	lda STACKORIGIN-1+STACKWIDTH*3,x	; dividend sign
	bpl @+
	jsr notaBXm1
	iny

@	lda STACKORIGIN+STACKWIDTH*3,x		; divisor sign
	bpl @+
	jsr notaBX
	iny

@	lda tsign,y
	pha
	
	jsr iniEAX_ECX
	jsr imul64			; imul ecx 64 bit

	mva eax+1 eax
	mva eax+2 eax+1
	mva eax+3 eax+2
	mva edx eax+3
/*
	ldy #32-FRACBITS		; shl edx, 32 - FRACBITS
@	asl edx
	rol edx+1
	rol edx+2
	rol edx+3
	dey
	bne @-

	ldy #FRACBITS			; shr eax, FRACBITS
@	lsr eax+3
	ror eax+2
	ror eax+1
	ror eax
	dey
	bne @-

	.rept MAXSIZE
	lda eax+#
	ora edx+#
	sta eax+#
	.endr
*/
	jsr movaBX_EAX	

	pla
	spl

	jmp notaBXm1

	rts

tsign	dta 0,$80,0
.endp


; *** MUL32: 32-bit multiply 
; ZTMP0-ZTMP3 * ZTMP4-ZTMP7 -> ZTMP0-ZTMP3 
.proc	imulECX
;	ldx @sp

	lda #0 
      	sta ZTMP10
	sta ZTMP9
	sta ZTMP8

	ldy #32 
MUL320	lsr ZTMP10 
	ror ZTMP9 
	ror ZTMP8 
	ror @
	ror eax+3
	ror eax+2
	ror eax+1
	ror eax
	bcc MUL321 
	clc 
	adc ecx 
	pha 
	lda ecx+1
	adc ZTMP8 
	sta ZTMP8 
	lda ecx+2 
	adc ZTMP9 
	sta ZTMP9 
	lda ecx+3 
	adc ZTMP10 
	sta ZTMP10 
	pla 
MUL321	dey
       	bpl MUL320 
;	lda ZTMP0		; Load the low result word 
;	ldy ZTMP1 

	rts
.endp


; *** UDIV32: 32-bit unsigned division 
; input: dividend at ZTMP0-ZTMP3 
;        divisor at ZTMP4-ZTMP7 
; output: result at ZTMP0-ZTMP3 
;         remainder at ZTMP8-ZTMP11 
; X,Y preserved
.proc	idivECX

	LDA #0
	STA ZTMP9
	STA ZTMP10
	STA ZTMP11

	LDY #32
UDIV320	ASL eax
	ROL eax+1
	ROL eax+2
	ROL eax+3
	ROL @
	ROL ZTMP9
	ROL ZTMP10
	ROL ZTMP11
			;do a subtraction 
	PHA
	CMP ecx
	LDA ZTMP9
	SBC ecx+1
	LDA ZTMP10
	SBC ecx+2
	LDA ZTMP11
	SBC ecx+3
	BCC UDIV321
 			;overflow, do the subtraction again, this time store the result 
	STA ecx+3	;we have the high byte already 
	PLA
	SBC ecx		;byte 0 
	PHA
	LDA ZTMP9
	SBC ecx+1
	STA ZTMP9	;byte 1 
	LDA ZTMP10
	SBC ecx+2
	STA ZTMP10	;byte 2 
	INC eax		;set result bit 
 
UDIV321	PLA
	DEY
	BNE UDIV320
	STA ZTMP8

	rts

	; jsr movEAX_STACK		; DIV
	; jsr movZTMP_STACK		' MOD
.endp


.proc	print (.byte a) .reg
	stx @sp

	jsr putchar

	ldx @sp
	rts
.endp

.proc	printCHAR
	stx @sp

	lda STACKORIGIN,x
	jsr putchar

	ldx @sp
	rts
.endp


.proc	printSTRING (.word ya) .reg
	sta string
	sty string+1

	stx @sp

loop	lda $ffff
string	equ *-2
	cmp #EOL
	beq stop

	putchar @

	inw string
	jmp loop

stop	ldx @sp
	rts
.endp


.proc	printBOOLEAN
	lda STACKORIGIN,x
	beq _0

_1	lda <_true
	ldy >_true
	jmp printSTRING	
	
_0	lda <_false
	ldy >_false
	jmp printSTRING	

_true	dta c'TRUE',$9B
_false	dta c'FALSE',$9b	
.endp


.proc	printREAL
	lda STACKORIGIN+STACKWIDTH*3,x
	bpl plus

	print #'-'

	jsr notaBX

plus	mva STACKORIGIN,x dx
	mva STACKORIGIN+STACKWIDTH,x dx+1
	mva STACKORIGIN+STACKWIDTH*2,x dx+2
	mva STACKORIGIN+STACKWIDTH*3,x dx+3

	mva dx+1 dx
	mva dx+2 dx+1
	mva dx+3 dx+2
	mva #$00 dx+3
/*
	ldy #FRACBITS
@	lsr dx+3
	ror dx+2
	ror dx+1
	ror dx
	dey
	bne @-
*/
	jsr printValue

	lda STACKORIGIN,x
	and <FRACMASK
	sta Frac
	lda STACKORIGIN+STACKWIDTH,x
	and >FRACMASK
	sta Frac+1

	lda #$00
	sta Frac+2
	sta Frac+3

	print #'.'
	
	mva #1 loop+1

loop	ldy #3
	mva lInvWeight,y InvWeight
	sta ecx
	mva hInvWeight,y InvWeight+1
	sta ecx+1
	lda #$00
	sta ecx+2
	sta ecx+3

	sta eax+2
	sta eax+3

	mwa Frac eax

;	mva Frac eax
;	mva Frac+1 eax+1
;	mva Frac+2 eax+2
;	mva Frac+3 eax+3

	jsr imulECX

	mva eax+1 eax
	mva eax+2 eax+1
	mva eax+3 eax+2
	mva #$00 eax+3

/*
	ldy #FRACBITS
@	lsr eax+3
	ror eax+2
	ror eax+1
	ror eax
	dey
	bne @-
*/
	cpl eax #10
	bcc skp

	mva #9 eax
	
skp	lda #'0'
	add eax
	print @

	ldy eax
	mva lDig,y eax
	mva hDig,y eax+1

	mva InvWeight ecx
	mva InvWeight+1 ecx+1
	lda #$00
	sta ecx+2
	sta ecx+3

	sta eax+2
	sta eax+3

	jsr idivECX

	sbw Frac eax

;	lda Frac
;	sub eax
;	sta Frac
;	lda Frac+1
;	sbc eax+1
;	sta Frac+1
;	lda Frac+2
;	sbc eax+2
;	sta Frac+2
;	lda Frac+3
;	sbc eax+3
;	sta Frac+3

	dec loop+1
	jpl loop
	rts
stop
/*
while InvWeight <= 10000 do
  begin
  Digit := (Frac * InvWeight) shr FracBits;
  if Digit > 9 then Digit := 9;
  Write(  Char(ord('0') + Digit) );
  Frac := Frac - (Digit shl FracBits) div InvWeight;
  InvWeight := InvWeight * 10;
  end; // while
*/
	rts

lInvWeight dta l(/*10000,1000,*/100,10)
hInvWeight dta h(/*10000,1000,*/100,10)

lDig	:10 dta l(#<<FracBits)
hDig	:10 dta h(#<<FracBits)

Frac	.ds 4
InvWeight .ds 2
.endp


.proc	printCARDINAL
	mva STACKORIGIN,x dx
	mva STACKORIGIN+STACKWIDTH,x dx+1
	mva STACKORIGIN+STACKWIDTH*2,x dx+2
	mva STACKORIGIN+STACKWIDTH*3,x dx+3

	jmp printVALUE
.endp

.proc	printWORD
	mva STACKORIGIN,x dx
	mva STACKORIGIN+STACKWIDTH,x dx+1
	mva #$00 dx+2
	sta dx+3

	jmp printVALUE
.endp

.proc	printBYTE
	mva STACKORIGIN,x dx
	mva #$00 dx+1
	sta dx+2
	sta dx+3

	jmp printVALUE
.endp

.proc	printVALUE

	mva #'0' old

	stx @sp

ne	mov32 ztmp8 1000000000
	jsr digit
	mov32 ztmp8 100000000
	jsr digit
	mov32 ztmp8 10000000
	jsr digit
	mov32 ztmp8 1000000
	jsr digit
	mov32 ztmp8 100000
	jsr digit
	mwa #10000 ztmp8
	mva #0 ztmp8+2
	jsr digit
	mwa #1000 ztmp8
	jsr digit
	mwa #100 ztmp8
	jsr digit
	mva #10 ztmp8
	jsr digit

	dec old
	mva #1 ztmp8

	jsr digit

	ldx @sp
	rts

digit	ldy #'0'

_0	cpd dx ztmp8
	bcc _1

sub32	lda dx
	sec
	sbc ztmp8
	sta dx
	lda dx+1
	sbc ztmp8+1
	sta dx+1
	lda dx+2
	sbc ztmp8+2
	sta dx+2
	lda dx+3
	sbc ztmp8+3
	sta dx+3

	iny
	bne _0
	
_1	cpy #'0'
old	equ *-1
	beq skip

	dec old
	tya
	jmp putchar

skip	rts

.macro	mov32
	mva <%%2 %%1
	mva >%%2 %%1+1
	mva ^%%2 %%1+2
	mva #%%2>>24 %%1+3
.endm

.endp


;----------------------------;
; Biblioteka procedur        ;
; graficznych                ;
;----------------------------;
; Autorzy:                   ;
;  Slawomir 'SERO' Ritter,   ;
;  Jakub Cebula,             ;
;  Winfried Hofacker         ;
;----------------------------;
; Wersja:1.1 DATA:09.01.2008 ;
;----------------------------;

@open	= $03		; Otworz kanal
@close	= $0c		; Zamknij kanal

@IDplot	= $09		; Narysuj punkt
@IDdraw	= $11		; Narysuj linie
@IDfill	= $12		; Wypelnij obszar


;------------------------;
;Wy:.Y-numer bledu (1-OK);
;   f(N)=1-wystapil blad ;
;------------------------;
.proc	@COMMAND

	ldx	#$00
scrchn	equ *-1

	sta	iocom,x

	lda	#$00
colscr	equ *-1
	sta	atachr

	jmp	ciov

stop	rts

mWidth	.word
mHeight	.word
.endp

;------------------------;
; Ustaw tryb ekranu      ;
;------------------------;
;We:.X-numer kanalu      ;
;      (normalnie 0)     ;
;   .Y-numer trybu (O.S.);
;   .A-Ustawiony bit nr :;
;     5-Nie kasowanie    ;
;       pamieci ekranu   ;
;     4-Obecnosc okna    ;
;       tekstowego       ;
;     2-Odczyt z ekranu  ;
;------------------------;
;Wy:SCRCHN-numer kanalu  ;
;  .Y-numer bledu (1-OK) ;
;   f(N)=1 wystapil blad ;
;------------------------;
@GRAPHICS .proc (.byte x,y,a) .reg

	sta	byte1
	sty	byte2

	stx	@COMMAND.scrchn

	mva	#@close	iocom,x
	jsr	ciov

	lda	#0		; =opcje
byte1	equ	*-1
	ora	#8		; +zapis na ekranie
	sta	ioaux1,x

	lda	#0
byte2	equ	*-1
	sta	ioaux2,x	;=nr.trybu

	mva	#@open	iocom,x

	mwa	#scrnam	ioadr,x

	jmp	ciov

scrnam   dta c'S:',$9b

	.endp



	icl 'putchar.asm'
