class GameClient {
  
  Client remoteClient;
  Ship ship;
  Universe universe;    
  float lastShoot = 3.0f;
  boolean shooting = false;
  int life = 3;
  int points = 0;
  
  public GameClient(Universe universe, Ship ship, Client remoteClient) {
    this.ship = ship;
    this.universe = universe;
    this.remoteClient = remoteClient;
  }
  
  public void accleration(boolean value) {
    this.ship.accleration = value;
    this.universe.updateObject(this.ship);
  }
  
  public void turnLeft(boolean value) {
    this.ship.turnLeft = value;
    this.universe.updateObject(this.ship);
  }
  
  public void turnRight(boolean value) {
    this.ship.turnRight = value;
    this.universe.updateObject(this.ship);
  }
  
  public void shoot(boolean value) {
    this.shooting = value;
  }
  
  public void update(float elapsed) {
    lastShoot += elapsed;
    if (shooting && this.ship.visible) {
      if (lastShoot >= 0.5f) {
        
        float[] shift = x_rotate(this.ship.model1[0], this.ship.direction);
        
        this.universe.updateObject(this.universe.bullet(
          this.ship.position[0] + shift[0], 
          this.ship.position[1] + shift[1], 
          (cos(this.ship.direction - PI / 2) * Bullet.BULLET_SPEED),
          (sin(this.ship.direction - PI / 2) * Bullet.BULLET_SPEED),
          Bullet.BULLET_LIFE,
          this.ship.entityColor,
          this.ship.id
          ));
        
        lastShoot = 0.0f;
      }
    }
  }
}