class Blur {
  PImage buffer;
  int sum = 16;
  int[] kernel = { 
    2, 4, 2, 
    4, 8, 4, 
    2, 4, 2 
  };
  int[] offset;
  
  public void init() {
    buffer = createImage(width, height, RGB);
    offset = new int[] { 
        -(width + 1), -(width), -(width - 1),
        -1, 0, +1,
        +(width - 1), +(width), +(width + 1)
    };
  }
  
  public void applyEffect() {
    loadPixels();

    int i = 0;
    int alpha = 255 << 24;
    for( int y = 0; y < height; ++y) {
      for( int x = 0; x < width; ++x) {
    
        int r = 0, g = 0, b = 0;
        
        for( int o = 0; o < offset.length; ++o) {
          
          int a = i + offset[o];
          if ( a < 0 || a >= pixels.length) {
            continue;
          }
          
          int c = pixels[a];
          r += ((c >> 16) & 0xFF) * kernel[o];
          g += ((c >> 8) & 0xFF) * kernel[o];
          b += (c & 0xFF) * kernel[o];
        }
        
        r = (r >> 4); if (r < 0) r = 0; else if (r > 255) r = 255;
        g = (g >> 4); if (g < 0) g = 0; else if (g > 255) g = 255;
        b = (b >> 4); if (b < 0) b = 0; else if (b > 255) b = 255;
                
        buffer.pixels[i++] = (alpha | (r << 16) | (g << 8) | (b));
      }
    }
    
    buffer.updatePixels();
    image(buffer, 0, 0);
  }
}