void forceLimit(float[] force, float limit) {
  float fl = sqrt(force[0] * force[0] + force[1] * force[1]); 
  if (fl > limit) {
    force[0] = (force[0] / fl) * limit;
    force[1] = (force[1] / fl) * limit;
  }
}

void wrap(float[] vector, float size) {
  if (vector[0] - size <= 0) vector[0] = width - size - 1;
  if (vector[1] - size <= 0) vector[1] = height - size - 1;
  if (vector[0] + size >= width) vector[0] = size + 1;
  if (vector[1] + size >= height) vector[1] = size + 1;
}

void drawPolygon(float[][] polygon) {
  int pl = polygon.length;
  
  if (pl == 0) {
    return;
  }
  
  if (polygon.length == 1) {
    point(polygon[0][0], polygon[0][1]);
    return;
  } 
  
  for(int i = 1; i < pl; ++i) {
    line(polygon[i - 1][0], polygon[i - 1][1], polygon[i][0], polygon[i][1]);
  }
  
  if (pl > 2) {
    line(polygon[pl - 1][0], polygon[pl - 1][1], polygon[0][0], polygon[0][1]);
  }
}

boolean pointInPolygon(float[] point, float[][] polygon) {
  return pointInPolygon(point[0], point[1], polygon);
}

boolean pointInPolygon(float px, float py, float[][] polygon) {
  // http://stackoverflow.com/questions/11716268/point-in-polygon-algorithm
  
  int i, j, nvert = polygon.length;
  boolean c = false;

  for(i = 0, j = nvert - 1; i < nvert; j = i++) {
    if( ( (polygon[i][1] >= py ) != (polygon[j][1] >= py) ) &&
        (px <= (polygon[j][0] - polygon[i][0]) * (py - polygon[i][1]) / (polygon[j][1] - polygon[i][1]) + polygon[i][0])
      )
      c = !c;
  }

  return c;
}

void to_world(float[] result, float rotate, float scale, float[] position, float[] point) {
  result[0] = (point[0] * cos(rotate) - point[1] * sin(rotate)) * scale + position[0];
  result[1] = (point[1] * cos(rotate) + point[0] * sin(rotate)) * scale + position[1];
}

float[] x_rotate(float[] point, float angle)
{
  float[] result = new float[2];
  
  result[0] = point[0] * cos(angle) - point[1] * sin(angle);
  result[1] = point[1] * cos(angle) + point[0] * sin(angle);
  
  return result;
}