
#include <shadercommon.hlsli>

float dfWater(float3 pos)
{
	return 1-pos.y 
	 + snoise(pos.xz + waterAnim)*.2 
	 + snoise(pos.xz - waterAnim)*.2;
	 + snoise(pos.xz*.2 + waterAnim)
	 + snoise(pos.xz*.2 - waterAnim);
}
float dfObject(float3 pos)
{
	float3 opos = pos;
	pos.xz = mod(pos.xz+8,16)-8;
	float box = max(abs(pos.x),abs(pos.z));
	return min(max(box-1, -(opos.y + structureHeight + nnoise((opos.zx-4)/16)*25)),7);
}

float df(float3 pos){
	return min(dfObject(pos), dfWater(pos));
}

float3 nf(float3 p){
    float2 e = float2(.0,.001);
    float c = df(p);
    return normalize(float3(df(p-e.yxx)-df(p+e.yxx),df(p-e.xyx)-df(p+e.xyx),df(p-e.xxy)-df(p+e.xxy)));
}

/*
float dfSphere(float3 pos)
{
	
	return 
	max(length(pos) - 1,
		-(length(pos-float3(.5,0,0)) - .7));
}

float dfPlane(float3 pos)
{
	return 1-pos.y;
}

float df(float3 pos)
{
	//return min(dfPlane(pos),dfSphere(pos));
	pos = mod(pos+2, 4)-2;
	return dfSphere(pos);
}

float3 nf(float3 pos)
{
	float2 e = float2(.0,.001);
	return normalize(float3(
		df(pos+e.yxx) - df(pos-e.yxx),
		df(pos+e.xyx) - df(pos-e.xyx),
		df(pos+e.xxy) - df(pos-e.xxy)
	));
}
*/

float ambientShading(float3 pos)
{
	float3 normal = nf(pos);
	return (
		((df(pos-normal*.7)/.7)*.5+.5) +
		((df(pos-normal*1.4)/1.4)*.5+.5) +
		((df(pos-normal*4.4)/4.4)*.5+.5)
		)*.33;
}

float3 backgroundAtmos(float3 dir)
{
	return float3(.2,.4,.7)*(dir.y*-.5+.5) 
	+ pow(1-abs(dir.y),4) ;
}

float3 background(float3 dir)
{
	return  backgroundAtmos(dir)*.5
	 + snoise(dir*float3(8,16,8)) * snoise(dir*float3(4,8,4))
	 + 1.0/(.05+(dot(dir,normalize(lightDir))*.5+.5)*sunSize);
}

float4 p(VSOutput input) : SV_TARGET
{
	float2 uv = input.TexCoord;
	uv -= 0.5;
	//uv /= float2(16 / 9, 1.5);
	uv /= float2(Resolution.y / Resolution.x, 1);

	float t = time;
	
	float3 p = cameraPosition;
    float luv = length(uv);
    float3 dir = normalize(float3(uv.xy,1.0));
    
	rotate(dir.yz, cameraRX);
	rotate(dir.xz, cameraRY);
    float3 lightp = float3(cos(time)*10,-1,sin(time)*10);
    
    p+=dir*hash(uv)*.1;
    float it;
	
    float dist;
	float totalDist = 0;
    for(float i=0.0; i<100.0; i+=1.){
    	dist = df(p);
		totalDist += dist;
        p+=dist*dir;
        it = i;
        if (dist<.001 || dist > 100.0){
        	break;
        }
    }
    
    float3 d2 = normalize(lightp-p);
    float td = .01;
    float3 p2 = p+d2*(td+td*hash(uv));
    float occlusion = 1.0;
    float mtd = distance(lightp,p);
    float3 color;
	float3 bgcolor = background(dir);
   
	if (dist<.1)
	{ 
		if (dfWater(p)<dfObject(p))	
		{
			float3 normal = nf(p);
			normal.y += snoise(p.xz*8 + waterAnim*2)*2;
			normal.y += snoise(p.xz*8 - waterAnim*2)*2;
			normal = normalize(normal);
			
			float diffuse = max(.1,dot(normal,normalize(lightDir)));
			float3 lcolor = float3(.1,.2,.15)*0.5;
			float3 rdir = reflect(dir, normal);
			
			float3 sp = p;
			float3 sd = rdir;
			float rocclusion = 1.0;
			for (int i=0; i<20; i++)
			{
				float dist = dfObject(sp);
				sp += dist*sd;
				rocclusion = min(dist,rocclusion*4);
			}
			
			rocclusion = saturate(rocclusion);
			
			float fresnel = pow(dot(dir,rdir)*.5+.5,10);
			color= diffuse;
			
			float waterFresnel = fresnel*.8+.2;
			color = waterColor*diffuse;
			color += backgroundAtmos(-normal)*.3 + background(rdir)*waterFresnel*rocclusion;
		}
		else
		{
			float3 normal = nf(p);
			float diffuse = max(0,dot(normal,normalize(lightDir)));
			float3 lcolor = float3(.1,.1,.15)*.5;
			float3 rdir = reflect(dir, normal);
			float fresnel = pow(dot(dir,rdir)*.5+.5,10);
			color= lcolor*(diffuse*.3 + .3) + fresnel;
		}
		
		color *= ambientShading(p);
	}
	else 
	{
		color = background(dir);
	}
	
	color = lerp(bgcolor, color, 1.0/(1.0+totalDist*totalDist*0.001));
	
	//color += pow(max(0,dfCutter(p)+1.0f),100.0);
	color = max(0,color-length(uv)*.05);
	//color = lerp(color,float3(1.1,1.1,1.2)*color / (color + 1),1.1);
	
    //color = nf(p)*.5+.5;
	return float4(color,1.0);
}