
#include <shadercommon.hlsli>




float dfpart(float3 pos, float rep,float interp){
    float3 rep3 = float3(rep,rep,rep);
	pos = mod(pos+rep3,rep3*2.0)-rep3;
    float d=rep;
    //d = min(d,length(pos.xy));
    //d = min(d,length(pos.yz));
    //d = min(d,length(pos.zx));
    //return rep*.5-d+interp*.2;
    return rep*(1.15+interp*.27)-length(pos);
} 

float dfCutter(float3 pos)
{
	rotate(pos.xy, cutRZ); 
	rotate(pos.yz, cutRX);
	//float box = 32 - max(max(abs(pos.x), abs(pos.y)), abs(pos.z));
	//return box;
	//return cutAmount-abs(mod(pos.x+4.5, 9.0) - 4.5);
	return cutAmount*20-abs(mod(pos.y+20, 40) - 20);
}
  
float df(float3 pos){
	
	//return box;
    float interp = structure;
    interp = interp*interp*interp;
    float d = 0.0,e=16.0;
    for (float i=.0; i<4.; i++){
    	d = max(d,dfpart(pos,e,interp));
        if (d>e*.125) break;
        e*=.2712;
    }
	return max(dfCutter(pos),d);
}

float3 nf(float3 p){
    float2 e = float2(.0,.001);
    float c = df(p);
    return normalize(float3(df(p-e.yxx)-df(p+e.yxx),df(p-e.xyx)-df(p+e.xyx),df(p-e.xxy)-df(p+e.xxy)));
}

/*
float dfSphere(float3 pos)
{
	
	return 
	max(length(pos) - 1,
		-(length(pos-float3(.5,0,0)) - .7));
}

float dfPlane(float3 pos)
{
	return 1-pos.y;
}

float df(float3 pos)
{
	//return min(dfPlane(pos),dfSphere(pos));
	pos = mod(pos+2, 4)-2;
	return dfSphere(pos);
}

float3 nf(float3 pos)
{
	float2 e = float2(.0,.001);
	return normalize(float3(
		df(pos+e.yxx) - df(pos-e.yxx),
		df(pos+e.xyx) - df(pos-e.xyx),
		df(pos+e.xxy) - df(pos-e.xxy)
	));
}
*/

float ambientShading(float3 pos)
{
	float3 normal = nf(pos);
	return (
		((df(pos-normal*.7)/.7)*.5+.5) +
		((df(pos-normal*1.4)/1.4)*.5+.5) +
		((df(pos-normal*4.4)/4.4)*.5+.5)
		)*.33;
}

float4 p(VSOutput input) : SV_TARGET
{
	float2 uv = input.TexCoord;
	uv -= 0.5;
	//uv /= float2(16 / 9, 1.5);
	uv /= float2(Resolution.y / Resolution.x, 1);

	
	/*float3 pos = float3(0, 0, -4);
	float3 dir = normalize(float3(uv, 1));
	
	float ry = normalizedTime * 40.0;
	
	rotate(dir.xz,ry);
	rotate(pos.xz,ry);
	
	float totalDistance = 0;
	float distance;
	float sceneresult = 0.0;
	float iteration;
  	for(float i = 0; i < 100; i++)
	{
		distance = df(pos);
		pos += dir * distance; 
		
		iteration = i;
		
		if (distance < 0.001 || distance > 100.0)
		{
			break;
		}
	}
	
	float3 color = float3(.2,.3,.4)*iteration/100;
	
	float3 lightDir = normalize(float3(1,2,3));
	
	float3 normal = nf(pos);
	
	if (df(pos) < .01)
	{
		color = float3(.9,.1,.1);
		color = normal*.5 + .5;
		
		float diffuse = max(0,dot(lightDir,normal));
		diffuse += ((df(pos+normal))*.5+.5)*.2;
		float specular = pow(dot(reflect(dir,normal),lightDir)*.5+.5,64);
		color = float3(.9,.1,.1)*diffuse + specular;
	}
	
	return float4(color, 1);*/
	
	float t = normalizedTime;
	
	float3 p = cameraPosition + (sin(float3(t*.172, t*.271, t*.314)*2.0)+t)*autoObjectSpeed;
    float luv = length(uv);
    float3 dir = normalize(float3(uv.xy,0.9+luv*luv*.1));
    
    float3 lightp = cameraPosition + t*autoObjectSpeed + normalize(sin(p*.1))*5.0 + dir*15.0;
    
    rotate(dir.xy,t*.1 * autoObjectRotation);
    rotate(dir.yz,t*.07 * autoObjectRotation);
    rotate(dir.zx,t*.025 * autoObjectRotation);
    p+=dir*hash(uv)*.1;
    float it;
	
    float dist;
    for(float i=0.0; i<100.0; i+=1.){
    	dist = df(p);
        p+=dist*dir;
        it = i;
        if (dist<.01){
        	break;
        }
    }
    
    float3 d2 = normalize(lightp-p);
    float td = .01;
    float3 p2 = p+d2*(td+td*hash(uv));
    float occlusion = 1.0;
    float mtd = distance(lightp,p);
    
    for(float i=0.0; i<100.0;i++){
        float d = df(p2);
    	p2 += d*d2;
        td += d;
        if (td>mtd || occlusion<.01) break;
        occlusion = min(occlusion,d/(td*.05));
    }
    occlusion=max(occlusion,0.0);
    
    float diffuse = dot(nf(p),-d2)*.5+.5;
    float3 lcolor = objectColor*.5;
    float3 color= diffuse*lcolor/(1.0+mtd*mtd*.0005)*16.0*occlusion+lcolor/(1.0+mtd*mtd*.0005)*.5;
    color += (1-lcolor)*(td*.001+occlusion+it/200.0)*.5;
	color *= 1.0 - length(uv)*.5;
	if (dist<.1)
		color *= ambientShading(p);
	
	//color += pow(max(0,dfCutter(p)+1.0f),100.0);
	color = max(0,color-length(uv)*.05);
	//color = lerp(color,float3(1.1,1.1,1.2)*color / (color + 1),1.1);
	
    //color = nf(p)*.5+.5;
	return float4(color,1.0);
}