// ----------------------------------------
// xIII of A4 with a fast 1k intro for
// forever party 2015
// ----------------------------------------

.pc = $0801 "Basic Upstart"
:BasicUpstart(start)

.pc = $0810 "sprite-wave"
start: 	lda #0
		sta $d020
		sta $d021
		jsr $e544

 		lda #%00000111
		sta $d015
		sta $d01d

		lda #$b4
		sta spr01+1
		sta spr02+1
		sta spr03+1
		
		ldx #$02
!loop: 	lda spritepointer,x
 		sta $07f8,x		// spritepointers
 		lda spritecolor,x
 		sta $d027,x		// spritecolors
 		dex 
 		bpl !loop-

 		ldx #$05
!loop: 	lda spritecoord,x
 		sta $d000,x		// sprite coord
 		dex 
 		bpl !loop-

 		lda #$10
		sta $d010		// sprite msb
		
		ldx #0
!l:		lda text,x
		sta $0400,x
		lda text2,x
		sta $0400+31,x
		lda text3,x
		sta $07c0,x
		lda text4,x
		sta $07c0+31,x
		inx
		cpx #8
		bne !l-
		
		jsr color
		
 		sei 
 		lda #<irq
 		sta $0314
 		sta $dc0e
		lda #>irq
		sta $0315
		lda #$3f
		sta $dc0d
		lda #$30
 		sta $d012
 		lda #$81
 		sta $d01a
 		lda #$1b
 		sta $d011
 		cli 
self:	jmp self

irq:	inc $d019

		lda #$7a
		cmp $d012
		bne *-3
		
		ldx #$00

!loop:	ldy timing,x
		dey
		bne *-1

spr01:	lda sinus,x
		sta $d000
		inx
		cpx #$15
		bne !loop-
		nop

!loop:	ldy timing,x
		dey
		bne *-1

spr02:	lda sinus,x
		sta $d002
		inx
		cpx #$2a
		bne !loop-
		nop

!loop:	ldy timing,x
		dey
		bne *-1
spr03:	lda sinus,x
		sta $d004
		inx
		cpx #$3f
		bne !loop-

		dec spr01+1
		dec spr02+1
		dec spr03+1
		bne !loop+

		lda #$b4
		sta spr01+1
		sta spr02+1
		sta spr03+1
		
	!loop:	jmp $ea81

spritepointer:		.byte $09c0/64,$0940/64,$0980/64
spritecolor:		.byte $06,$0b,$04
spritecoord:		.byte $a8,$7a,$a8,$8f,$a8,$a4

.align $0100
timing:
.byte 08,02,08,08,08,08,08,08,06,01,07,08,08,08,08,08,07,01,08,08,08	// sprite 1
.byte 08,08,08,07,01,07,08,08,08,08,08,07,01,08,08,08,08,08,08,07,01	// sprite 2
.byte 07,08,08,08,07,08,07,01,08,08,08,08,08,08,07,01,08,08,08,08,08	// sprite 3

.align $0040
sprites:
.import binary "sprites.bin"

.align $0100
sinus:
.import c64 "sinus.c64"

color:
		ldx #0
	!l:		lda col,x
			sta $d800,x
			sta $d800+31,x
			sta $dbc0,x
			sta $dbc0+31,x
		inx
		cpx #8
		bne !l-

		rts

col: .byte 9,8,2,10,7,3,14,4,11,6


text:	.text "1k intro"
text2:	.text "forever!"
text3:	.text "xiii/a4!"
text4:	.text ".:2015:."