                ORG 32768
; *****************************************************************************
; * Tritone v2 Player (with equal channel volumes)
; *
; * By Shiru (shiru@mail.ru) 03'11
; *
; * Three channels of tone, per-pattern tempo
; * One channel of interrupting drums
; * Feel free to do whatever you want with the code, it is PD
; *
; * Produced by Beepola v1.08.01
; ******************************************************************************

OP_NOP:         EQU   $00                 ; NOP opcode  (used for CHECK_KEMPSTON)
OP_SCF:         EQU   $37                 ; SCF opcode  (used in CHECK_KEMPSTON)
OP_ORC:         EQU   $b1                 ; OR C opcode (used in CHECK_KEMPSTON)

                LD    HL,MUSICDATA
                CALL  TRI_PLAY
                RET

TRI_PLAY:
                DI
                LD    (NEXT_POS_POS + 1),HL
                LD    C,16
                PUSH  IY
                EXX
                PUSH  HL
                LD    (PREV_SP+1),SP
                XOR   A
                LD    H,A
                LD    L,H
                LD    (CNT0 + 1),HL
                LD    (CNT1 + 1),HL
                LD    (CNT2 + 1),HL
                LD    (DUTY0 + 1),A
                LD    (DUTY1 + 1),A
                LD    (DUTY2 + 1),A
                LD    (SKIP_DRUM),A
                IN    A,($1F)
                AND   $1F
                LD    A,OP_NOP
                JR    NZ,SET_KEMPSTON
                LD    A,OP_ORC
SET_KEMPSTON:   LD    (CHECK_KEMPSTON),A
                JP    NEXT_POS

NEXT_ROW:
NEXT_ROW_POS:   LD    HL,0
                LD    A,(HL)
                INC   HL
                CP    2
                JR    C,CH0
                CP    128
                JR    C,DRUM_SOUND
                CP    255
                JP    Z,NEXT_POS
CH0:
                LD    D,1
                CP    D
                JR    Z,CH1
                OR    A
                JR    NZ,CH0_NOTE
                LD    B,A
                LD    C,A
                JR    CH0_SET
CH0_NOTE:       LD    E,A
                AND   $0F
                LD    B,A
                LD    C,(HL)
                INC   HL
                LD    A,E
                AND   $F0
CH0_SET:        LD    (DUTY0 + 1),A
                LD    (CNT0 + 1),BC
CH1:
                LD    A,(HL)
                INC   HL
                CP    D
                JR    Z,CH2
                OR    A
                JR    NZ,CH1_NOTE
                LD    B,A
                LD    C,A
                JR    CH1_SET
CH1_NOTE:       LD    E,A
                AND   $0F
                LD    B,A
                LD    C,(HL)
                INC   HL
                LD    A,E
                AND   $F0
CH1_SET:        LD    (DUTY1 + 1),A
                LD    (CNT1 + 1),BC
CH2:
                LD    A,(HL)
                INC   HL
                CP    D
                JR    Z,SKIP
                OR    A
                JR    NZ,CH2_NOTE
                LD    B,A
                LD    C,A
                JR    CH2_SET
CH2_NOTE:       LD    E,A
                AND   $0F
                LD    B,A
                LD    C,(HL)
                INC   HL
                LD    A,E
                AND   $F0
CH2_SET:        LD    (DUTY2 + 1),A
                LD    (CNT2 + 1),BC
SKIP:
                LD    (NEXT_ROW_POS + 1),HL
SKIP_DRUM:      SCF
                JP    NC,PLAY_ROW
                LD    A,OP_NOP
                LD    (SKIP_DRUM),A
                LD    HL,(TEMPO+1)
                LD    DE,65386                 ; DE = -150 
                ADD   HL,DE
                EX    DE,HL
                JR    C,DRM1
                LD    DE,257
DRM1:           LD    A,D
                OR    A
                JR    NZ,DRM2
                INC   D
DRM2:           LD    A,E
                OR    A
                JR    NZ,DRM3
                INC   E
DRM3:           JR    DRUM

DRUM_SOUND:     LD    (NEXT_ROW_POS + 1),HL
                ADD   A,A
                LD    IXL,A
                LD    IXH,0
                LD    BC,DRUM_SETTINGS - 4
                ADD   IX,BC
                CP    28                       ; 14 * 2
                LD    A,OP_SCF
                LD    (SKIP_DRUM),A
                JR    NC,DRUM_NOISE
DRUM_TONE:      LD    BC,2
                LD    A,B
                LD    DE,$1001
                LD    L,(IX+0)
DRUM_TONE_L0:   BIT   0,B
                JR    Z,DRUM_TONE_L1
                DEC   E
                JR    NZ,DRUM_TONE_L1
                LD    E,L
                EX    AF,AF'
                LD    A,L
                ADD   A,(IX + 1)
                LD    L,A
                EX    AF,AF'
                XOR   D
DRUM_TONE_L1:   OUT   ($FE),A
                DJNZ  DRUM_TONE_L0
                DEC   C
                JP    NZ,DRUM_TONE_L0
                JP    NEXT_ROW
DRUM_NOISE:     LD    B,0
                LD    H,B
                LD    L,H
                LD    DE,$1001
DRUM_NOISE_L0:  LD    A,(HL)
                AND   D
                OUT   ($FE),A
                AND   (IX+0)
                DEC   E
                OUT   ($FE),A
                JR    NZ,DRUM_NOISE_L1
                LD    E,(IX+1)
                INC   HL
DRUM_NOISE_L1:  DJNZ  DRUM_NOISE_L0
                JP    NEXT_ROW

NEXT_POS:
NEXT_POS_POS:   LD    HL,0
NEXT_POS_READ:  LD    E,(HL)
                INC   HL
                LD    D,(HL)
                INC   HL
                LD    A,D
                OR    E
                JR    Z,ORDER_LOOP
                LD    (NEXT_POS_POS+1),HL
                EX    DE,HL
                LD    C,(HL)
                INC   HL
                LD    B,(HL)
                INC   HL
                LD    (NEXT_ROW_POS+1),HL
                LD    (TEMPO+1),BC
                JP    NEXT_ROW

ORDER_LOOP:     LD    E,(HL)
                INC   HL
                LD    D,(HL)
                EX    DE,HL
                JR    STOP_PLAYER     ; Do not LOOP when song is over

PLAY_ROW:
TEMPO:          LD    DE,0
DRUM:
CNT0:           LD    BC,0
PREV_HL         LD    HL,0
                EXX
CNT1:           LD    DE,0
CNT2:           LD    SP,0
                EXX

SOUND_LOOP:
                ADD   HL,BC            ; 11 Ts
                LD    A,H              ;  4 Ts
                EXX                    ;  4 Ts
DUTY0:          CP    128              ;  7 Ts
                SBC   A,A              ;  4 Ts
                AND   C                ;  4 Ts
                ADD   IX,DE            ; 15 Ts
                OUT   ($FE),A          ; 11 Ts
                LD    A,IXH            ;  8 Ts
DUTY1:          CP    128              ;  7 Ts
                SBC   A,A              ;  4 Ts
                AND   C                ;  4 Ts
                OUT   ($FE),A          ; 11 Ts
                ADD   HL,SP            ; 11 Ts
                LD    A,H              ;  4 Ts
DUTY2:          CP    128              ;  7 Ts
                SBC   A,A              ;  4 Ts
                AND   C                ;  4 Ts
                EXX                    ;  4 Ts
                DEC   E                ;  4 Ts
                OUT   ($FE),A          ; 11 Ts
                JP    NZ,SOUND_LOOP    ; 10 Ts  = 153
                DEC   D                ;  4 Ts
                JP    NZ,SOUND_LOOP    ; 10 Ts
                XOR   A
                OUT   ($FE),A
                LD    (PREV_HL + 1),HL

                IN    A,($1F)
                AND   $1F
                LD    C,A
                XOR   A
                IN    A,($FE)
                CPL
CHECK_KEMPSTON: OR    C            ; This is set to NOP if no kempston i/f detected
                AND   $1F
                JP    Z,NEXT_ROW   ; Jump to next row unless key/joystick pressed

STOP_PLAYER:
PREV_SP:        LD    SP,0
                POP   HL
                EXX
                POP   IY
                EI
                RET

DRUM_SETTINGS:
                DEFB  $01,$01     ; 1: Tone, Highest
                DEFB  $01,$02
                DEFB  $01,$04
                DEFB  $01,$08
                DEFB  $01,$20
                DEFB  $20,$04
                DEFB  $40,$04
                DEFB  $40,$08     ; 8: Lowest
                DEFB  $04,$80     ; 9: Special
                DEFB  $08,$80
                DEFB  $10,$80
                DEFB  $10,$02
                DEFB  $20,$02
                DEFB  $40,$02
                DEFB  $16,$01     ; 15: Noise, Highest
                DEFB  $16,$02
                DEFB  $16,$04
                DEFB  $16,$08
                DEFB  $16,$10
                DEFB  $00,$01
                DEFB  $00,$02
                DEFB  $00,$04
                DEFB  $00,$08
                DEFB  $00,$10     ; 24: Last drum

; ************************************************************************
; * Song data...
; ************************************************************************
BORDER_CLR:          EQU $0

; *** DATA ***
MUSICDATA:

; *** Song layout ***
                      DEFW      PAT0
                      DEFW      PAT1
                      DEFW      PAT20
                      DEFW      PAT20
                      DEFW      PAT21
                      DEFW      PAT21
                      DEFW      PAT2
                      DEFW      PAT3
                      DEFW      PAT4
                      DEFW      PAT5
                      DEFW      PAT7
                      DEFW      PAT24
                      DEFW      PAT8
                      DEFW      PAT25
                      DEFW      PAT6
                      DEFW      PAT9
                      DEFW      PAT10
                      DEFW      PAT11
                      DEFW      PAT6
                      DEFW      PAT9
                      DEFW      PAT10
                      DEFW      PAT11
                      DEFW      PAT15
                      DEFW      PAT12
                      DEFW      PAT14
                      DEFW      PAT17
                      DEFW      PAT18
                      DEFW      PAT19
                      DEFW      PAT26
                      DEFW      PAT27
                      DEFW      PAT28
                      DEFW      PAT29
                      DEFW      PAT30
LOOPSTART:            DEFW      PAT31
                      DEFW      $0000
                      DEFW      LOOPSTART

; *** Patterns ***
PAT0:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$00    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$80,$7D,$80,$FA
                DEFB      $01    ,$80,$84,$81,$08
                DEFB      $01    ,$80,$94,$81,$29
                DEFB  $03,$01    ,$80,$8C,$81,$18
                DEFB  $03,$01    ,$80,$84,$81,$08
                DEFB  $09,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$9D,$81,$3B
                DEFB      $01    ,$80,$8C,$81,$18
                DEFB      $01    ,$80,$84,$81,$08
                DEFB  $09,$01    ,$80,$9D,$81,$3B
                DEFB      $01    ,$80,$8C,$81,$18
                DEFB      $01    ,$80,$84,$81,$08
                DEFB  $FF  ; End of Pattern

PAT1:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$80,$84,$81,$08
                DEFB      $01    ,$80,$8C,$81,$18
                DEFB      $01    ,$80,$9D,$81,$3B
                DEFB  $03,$01    ,$80,$8C,$81,$18
                DEFB  $03,$01    ,$80,$84,$81,$08
                DEFB  $09,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$80,$76,$80,$EC
                DEFB      $01    ,$00    ,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $03,$01    ,$80,$9D,$81,$3B
                DEFB      $01    ,$80,$8C,$81,$18
                DEFB      $01    ,$80,$84,$81,$08
                DEFB  $09,$01    ,$80,$9D,$81,$3B
                DEFB      $01    ,$80,$8C,$81,$18
                DEFB      $01    ,$80,$84,$81,$08
                DEFB      $01    ,$80,$9D,$81,$3B
                DEFB      $01    ,$80,$8C,$81,$18
                DEFB      $01    ,$80,$84,$81,$08
                DEFB      $01    ,$80,$9D,$81,$3B
                DEFB      $01    ,$80,$8C,$81,$18
                DEFB      $01    ,$80,$84,$81,$08
                DEFB      $01    ,$81,$3B,$82,$76
                DEFB      $01    ,$81,$18,$82,$31
                DEFB      $01    ,$81,$08,$82,$11
                DEFB      $01    ,$81,$3B,$82,$76
                DEFB      $01    ,$81,$18,$82,$31
                DEFB      $01    ,$81,$08,$82,$11
                DEFB      $01    ,$81,$3B,$82,$76
                DEFB      $01    ,$81,$18,$82,$31
                DEFB      $01    ,$81,$08,$82,$11
                DEFB      $01    ,$8A,$6E,$8B,$0D
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $FF  ; End of Pattern

PAT2:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $80,$EC,$83,$B0,$80,$76
                DEFB      $00    ,$82,$C3,$00
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $80,$D2,$83,$B0,$80,$69
                DEFB      $01    ,$84,$23,$01
                DEFB      $80,$EC,$84,$63,$80,$76
                DEFB      $00    ,$84,$23,$00
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $80,$EC,$83,$B0,$80,$76
                DEFB      $00    ,$84,$23,$00
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $80,$EC,$83,$B0,$80,$76
                DEFB      $00    ,$82,$ED,$00
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$82,$ED,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT3:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $80,$EC,$83,$B0,$80,$76
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$EC,$83,$B0,$01
                DEFB      $81,$61,$85,$86,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$EC,$83,$B0,$01
                DEFB      $81,$3B,$84,$E7,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$EC,$83,$B0,$01
                DEFB      $81,$18,$84,$63,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$EC,$83,$B0,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$EC,$83,$B0,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB      $00    ,$84,$63,$00
                DEFB      $01    ,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$82,$C3,$01
                DEFB      $80,$EC,$83,$B0,$80,$76
                DEFB      $00    ,$84,$23,$00
                DEFB      $01    ,$82,$C3,$01
                DEFB      $01    ,$83,$B0,$80,$76
                DEFB      $01    ,$84,$23,$00
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$84,$23,$80,$76
                DEFB      $80,$EC,$83,$B0,$80,$7D
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$61,$85,$86,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$3B,$84,$E7,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$18,$84,$63,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB      $81,$18,$84,$63,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$61,$85,$86,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$18,$84,$E7,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$18,$84,$63,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB      $81,$18,$84,$63,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT4:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$80,$EC,$83,$B0,$80,$76
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$61,$85,$86,$01
                DEFB  $02,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$3B,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $02,$80,$D2,$83,$B0,$80,$69
                DEFB  $02,$01    ,$84,$23,$01
                DEFB  $09,$80,$EC,$84,$63,$80,$76
                DEFB  $09,$81,$08,$84,$23,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $02,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$61,$85,$86,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$3B,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $02,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$80,$76
                DEFB  $02,$81,$08,$84,$23,$00
                DEFB  $02,$80,$B0,$82,$C3,$01
                DEFB  $02,$80,$EC,$83,$B0,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $02,$81,$18,$84,$63,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $09,$80,$EC,$83,$B0,$80,$76
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$61,$85,$86,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$81,$3B,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$18,$84,$63,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$81,$08,$84,$23,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $09,$81,$08,$84,$23,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$61,$85,$86,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$81,$18,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB      $80,$BB,$82,$ED,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB      $81,$08,$84,$23,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $09,$81,$08,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT5:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$80,$EC,$83,$B0,$80,$76
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$61,$85,$86,$01
                DEFB  $02,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$3B,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $02,$80,$D2,$83,$B0,$80,$69
                DEFB  $02,$01    ,$84,$23,$01
                DEFB  $09,$80,$EC,$84,$63,$80,$76
                DEFB  $09,$81,$08,$84,$23,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $02,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$61,$85,$86,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$3B,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $02,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$EC,$83,$B0,$80,$76
                DEFB  $02,$81,$08,$84,$23,$00
                DEFB  $02,$80,$B0,$82,$C3,$01
                DEFB  $02,$80,$EC,$83,$B0,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $02,$81,$18,$84,$63,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $09,$80,$EC,$83,$B0,$80,$84
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$61,$85,$86,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$81,$3B,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$18,$84,$63,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$81,$08,$84,$23,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $09,$81,$08,$84,$23,$80,$B0
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$61,$85,$86,$01
                DEFB      $80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $09,$81,$18,$84,$E7,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $02,$80,$BB,$82,$ED,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $09,$80,$B0,$82,$C3,$01
                DEFB  $09,$80,$BB,$82,$ED,$01
                DEFB  $02,$81,$08,$84,$23,$01
                DEFB  $09,$81,$18,$84,$63,$01
                DEFB  $02,$81,$08,$84,$23,$80,$A6
                DEFB  $FF  ; End of Pattern

PAT6:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$87,$60,$83,$B0,$80,$76
                DEFB  $09,$E7,$60,$85,$86,$80,$EC
                DEFB  $09,$87,$60,$83,$B0,$80,$76
                DEFB  $09,$E7,$60,$84,$E7,$80,$EC
                DEFB  $09,$87,$60,$83,$B0,$80,$76
                DEFB  $09,$E7,$60,$84,$63,$80,$EC
                DEFB  $09,$87,$60,$83,$B0,$80,$76
                DEFB  $09,$E7,$60,$84,$23,$80,$EC
                DEFB  $09,$87,$60,$83,$B0,$80,$76
                DEFB  $09,$E7,$60,$83,$49,$80,$EC
                DEFB  $09,$87,$60,$83,$B0,$80,$76
                DEFB  $09,$EA,$6E,$84,$23,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$85,$86,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$84,$E7,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$84,$63,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$84,$23,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$83,$49,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$84,$23,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$CB,$0D,$85,$86,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$CB,$0D,$84,$E7,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$CB,$0D,$84,$63,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$CB,$0D,$84,$23,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$CB,$0D,$83,$49,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$CB,$0D,$84,$23,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$85,$86,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$84,$E7,$80,$EC
                DEFB  $09,$00    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$84,$63,$80,$EC
                DEFB  $09,$01    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$84,$23,$80,$EC
                DEFB  $09,$8B,$0D,$83,$B0,$80,$76
                DEFB  $09,$DB,$0D,$83,$49,$80,$EC
                DEFB  $09,$00    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$84,$23,$80,$EC
                DEFB  $FF  ; End of Pattern

PAT7:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$00    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$85,$86,$80,$EC
                DEFB  $09,$01    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$84,$E7,$80,$EC
                DEFB  $09,$01    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$84,$63,$80,$EC
                DEFB  $09,$01    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$84,$23,$80,$EC
                DEFB  $09,$01    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$83,$49,$80,$EC
                DEFB  $09,$01    ,$83,$B0,$80,$76
                DEFB  $09,$01    ,$84,$23,$80,$EC
                DEFB  $09,$01    ,$83,$B0,$90,$76
                DEFB  $09,$01    ,$85,$86,$90,$EC
                DEFB  $09,$01    ,$83,$B0,$90,$76
                DEFB  $09,$01    ,$84,$E7,$90,$EC
                DEFB  $09,$01    ,$83,$B0,$90,$76
                DEFB  $09,$01    ,$84,$63,$90,$EC
                DEFB  $09,$01    ,$83,$B0,$90,$76
                DEFB  $09,$01    ,$84,$23,$90,$EC
                DEFB  $09,$01    ,$83,$B0,$90,$76
                DEFB  $09,$01    ,$83,$49,$90,$EC
                DEFB  $09,$01    ,$83,$B0,$90,$76
                DEFB  $09,$01    ,$84,$23,$90,$EC
                DEFB  $09,$01    ,$83,$B0,$A0,$76
                DEFB  $09,$01    ,$85,$86,$A0,$EC
                DEFB  $09,$01    ,$83,$B0,$A0,$76
                DEFB  $09,$01    ,$84,$E7,$A0,$EC
                DEFB  $09,$01    ,$83,$B0,$A0,$76
                DEFB  $09,$01    ,$84,$63,$A0,$EC
                DEFB  $09,$01    ,$83,$B0,$A0,$76
                DEFB  $09,$01    ,$84,$23,$A0,$EC
                DEFB  $09,$01    ,$83,$B0,$A0,$76
                DEFB  $09,$01    ,$83,$49,$A0,$EC
                DEFB  $09,$01    ,$83,$B0,$A0,$76
                DEFB  $09,$01    ,$84,$23,$A0,$EC
                DEFB  $09,$01    ,$83,$B0,$B0,$76
                DEFB  $09,$01    ,$85,$86,$B0,$EC
                DEFB  $09,$01    ,$83,$B0,$B0,$76
                DEFB  $09,$01    ,$84,$E7,$B0,$EC
                DEFB  $09,$01    ,$83,$B0,$B0,$76
                DEFB  $09,$01    ,$84,$63,$B0,$EC
                DEFB  $09,$01    ,$83,$B0,$B0,$76
                DEFB  $09,$01    ,$84,$23,$B0,$EC
                DEFB  $09,$01    ,$83,$B0,$B0,$76
                DEFB  $09,$01    ,$83,$49,$B0,$EC
                DEFB  $09,$01    ,$83,$B0,$B0,$76
                DEFB  $09,$01    ,$84,$23,$B0,$EC
                DEFB  $FF  ; End of Pattern

PAT8:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$85,$86,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$E7,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$63,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$23,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$83,$49,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$23,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$85,$86,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$E7,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$63,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$23,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$83,$49,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$23,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$85,$86,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$E7,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$63,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$23,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$83,$49,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$23,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$B0,$5D
                DEFB  $09,$01    ,$85,$86,$B0,$BB
                DEFB  $09,$01    ,$83,$B0,$B0,$5D
                DEFB  $09,$01    ,$84,$E7,$B0,$BB
                DEFB  $09,$01    ,$83,$B0,$B0,$5D
                DEFB  $09,$01    ,$84,$63,$B0,$BB
                DEFB  $09,$01    ,$83,$B0,$B0,$5D
                DEFB  $09,$01    ,$84,$23,$B0,$BB
                DEFB  $09,$01    ,$83,$B0,$B0,$5D
                DEFB  $09,$01    ,$83,$49,$B0,$BB
                DEFB  $09,$01    ,$83,$B0,$B0,$5D
                DEFB  $09,$01    ,$84,$23,$B0,$BB
                DEFB  $FF  ; End of Pattern

PAT9:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$8B,$0D,$83,$B0,$80,$84
                DEFB  $09,$EB,$0D,$85,$86,$81,$08
                DEFB  $09,$8B,$0D,$83,$B0,$80,$84
                DEFB  $09,$EB,$0D,$84,$E7,$81,$08
                DEFB  $09,$8B,$0D,$83,$B0,$80,$84
                DEFB  $09,$EB,$0D,$84,$63,$81,$08
                DEFB  $09,$8B,$0D,$83,$B0,$80,$84
                DEFB  $09,$EB,$0D,$84,$23,$81,$08
                DEFB  $09,$8B,$0D,$83,$B0,$80,$84
                DEFB  $09,$EB,$0D,$83,$49,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$E8,$C6,$84,$23,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$F9,$D9,$85,$86,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$F9,$D9,$84,$E7,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$F9,$D9,$84,$63,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$F9,$D9,$84,$23,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$F9,$D9,$83,$49,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$F9,$D9,$84,$23,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$E9,$D9,$85,$86,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$E9,$D9,$84,$E7,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$E9,$D9,$84,$63,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$E9,$D9,$84,$23,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$E9,$D9,$83,$49,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$E9,$D9,$84,$23,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$D9,$D9,$85,$86,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$D9,$D9,$84,$E7,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$D9,$D9,$84,$63,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$D9,$D9,$84,$23,$81,$08
                DEFB  $09,$89,$D9,$83,$B0,$80,$84
                DEFB  $09,$D9,$D9,$83,$49,$81,$08
                DEFB  $09,$00    ,$83,$B0,$80,$84
                DEFB  $09,$D9,$D9,$84,$23,$81,$08
                DEFB  $FF  ; End of Pattern

PAT10:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$87,$60,$83,$B0,$80,$8C
                DEFB  $09,$D7,$60,$85,$86,$81,$18
                DEFB  $09,$87,$60,$83,$B0,$80,$8C
                DEFB  $09,$D7,$60,$84,$E7,$81,$18
                DEFB  $09,$87,$60,$83,$B0,$80,$8C
                DEFB  $09,$D7,$60,$84,$63,$81,$18
                DEFB  $09,$87,$60,$83,$B0,$80,$8C
                DEFB  $09,$D7,$60,$84,$23,$81,$18
                DEFB  $09,$87,$60,$83,$B0,$80,$8C
                DEFB  $09,$D7,$60,$83,$49,$81,$18
                DEFB  $09,$87,$60,$83,$B0,$80,$8C
                DEFB  $09,$DA,$6E,$84,$23,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$85,$86,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$E7,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$63,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$23,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$83,$49,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$23,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$85,$86,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$E7,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$63,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$23,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$83,$49,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$23,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$85,$86,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$84,$E7,$81,$18
                DEFB  $09,$00    ,$83,$B0,$80,$8C
                DEFB  $09,$01    ,$84,$63,$81,$18
                DEFB  $09,$01    ,$83,$B0,$80,$8C
                DEFB  $09,$01    ,$84,$23,$81,$18
                DEFB  $09,$8B,$0D,$83,$B0,$80,$8C
                DEFB  $09,$DB,$0D,$83,$49,$81,$18
                DEFB  $09,$00    ,$83,$B0,$80,$8C
                DEFB  $09,$01    ,$84,$23,$81,$18
                DEFB  $FF  ; End of Pattern

PAT11:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$85,$86,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$E7,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$63,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$23,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$83,$49,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$23,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$85,$86,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$E7,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$63,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$23,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$83,$49,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$23,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$85,$86,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$E7,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$63,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$23,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$83,$49,$81,$3B
                DEFB  $09,$89,$D9,$83,$B0,$80,$9D
                DEFB  $09,$D9,$D9,$84,$23,$81,$3B
                DEFB  $09,$88,$C6,$83,$B0,$80,$8C
                DEFB  $09,$E8,$C6,$85,$86,$81,$18
                DEFB  $09,$88,$C6,$83,$B0,$80,$8C
                DEFB  $09,$E8,$C6,$84,$E7,$81,$18
                DEFB  $09,$88,$C6,$83,$B0,$80,$8C
                DEFB  $09,$E8,$C6,$84,$63,$81,$18
                DEFB  $09,$88,$C6,$83,$B0,$80,$8C
                DEFB  $09,$E8,$C6,$84,$23,$81,$18
                DEFB  $09,$88,$C6,$83,$B0,$80,$8C
                DEFB  $09,$E8,$C6,$83,$49,$81,$18
                DEFB  $09,$88,$C6,$83,$B0,$80,$8C
                DEFB  $09,$E8,$C6,$84,$23,$81,$18
                DEFB  $FF  ; End of Pattern

PAT12:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$83,$B0,$F0,$76
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT14:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$83,$B0,$B0,$EC
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$B0,$76
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$B1,$08
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$B0,$84
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$B1,$18
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$B0,$BB
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$B0,$5D
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT15:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $B7,$60,$83,$B0,$80,$76
                DEFB      $01    ,$85,$86,$90,$76
                DEFB      $D7,$60,$83,$B0,$A0,$76
                DEFB      $01    ,$84,$E7,$B0,$76
                DEFB      $E7,$60,$83,$B0,$C0,$76
                DEFB      $01    ,$84,$63,$D0,$76
                DEFB      $F7,$60,$83,$B0,$E0,$76
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$83,$49,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$83,$49,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$83,$49,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$85,$86,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$E7,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$63,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$83,$49,$01
                DEFB      $01    ,$83,$B0,$01
                DEFB      $01    ,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT17:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$83,$B0,$B0,$5D
                DEFB      $84,$22,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$85,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E6,$84,$63,$01
                DEFB      $00    ,$83,$B0,$80,$5D
                DEFB      $84,$62,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$22,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$48,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$22,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$85,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E6,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$62,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$22,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$48,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$22,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$85,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E6,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$62,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$22,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$48,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$22,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$85,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E6,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$62,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$22,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$48,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT18:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$83,$B0,$B0,$EC
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$B0,$76
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$B1,$08
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$B0,$84
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$B1,$18
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$B1,$76
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$B0,$BB
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$C0,$BB
                DEFB      $84,$63,$84,$23,$D0,$BB
                DEFB      $00    ,$83,$B0,$E1,$61
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$F1,$76
                DEFB      $83,$49,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT19:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$83,$B0,$B1,$61
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$B0,$B0
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$80,$84
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB  $FF  ; End of Pattern

PAT20:
                DEFW  1236     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$00    ,$80,$EC,$81,$D8
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$81,$18,$82,$31
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$81,$08,$82,$11
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$EC,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$01    ,$80,$D2,$81,$A4
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$EC,$81,$D8
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$01    ,$80,$D2,$81,$A4
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $FF  ; End of Pattern

PAT21:
                DEFW  1236     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$84,$63,$82,$31,$80,$EC
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$84,$63,$82,$31,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$85,$86,$82,$C3,$81,$18
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$85,$86,$82,$31,$80,$76
                DEFB      $01    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$84,$E7,$82,$76,$81,$08
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $82,$76,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$80,$EC,$82,$31,$80,$76
                DEFB      $00    ,$00    ,$00
                DEFB  $09,$84,$23,$82,$11,$80,$EC
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$84,$63,$82,$31,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $09,$84,$23,$82,$11,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $FF  ; End of Pattern

PAT24:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$00    ,$83,$B0,$C0,$76
                DEFB  $09,$01    ,$85,$86,$C0,$EC
                DEFB  $09,$01    ,$83,$B0,$C0,$76
                DEFB  $09,$01    ,$84,$E7,$C0,$EC
                DEFB  $09,$01    ,$83,$B0,$C0,$76
                DEFB  $09,$01    ,$84,$63,$C0,$EC
                DEFB  $09,$01    ,$83,$B0,$C0,$76
                DEFB  $09,$01    ,$84,$23,$C0,$EC
                DEFB  $09,$01    ,$83,$B0,$C0,$76
                DEFB  $09,$01    ,$83,$49,$C0,$EC
                DEFB  $09,$01    ,$83,$B0,$C0,$76
                DEFB  $09,$01    ,$84,$23,$C0,$EC
                DEFB  $09,$01    ,$83,$B0,$D0,$76
                DEFB  $09,$01    ,$85,$86,$D0,$EC
                DEFB  $09,$01    ,$83,$B0,$D0,$76
                DEFB  $09,$01    ,$84,$E7,$D0,$EC
                DEFB  $09,$01    ,$83,$B0,$D0,$76
                DEFB  $09,$01    ,$84,$63,$D0,$EC
                DEFB  $09,$01    ,$83,$B0,$D0,$76
                DEFB  $09,$01    ,$84,$23,$D0,$EC
                DEFB  $09,$01    ,$83,$B0,$D0,$76
                DEFB  $09,$01    ,$83,$49,$D0,$EC
                DEFB  $09,$01    ,$83,$B0,$D0,$76
                DEFB  $09,$01    ,$84,$23,$D0,$EC
                DEFB  $09,$01    ,$83,$B0,$E0,$76
                DEFB  $09,$01    ,$85,$86,$E0,$EC
                DEFB  $09,$01    ,$83,$B0,$E0,$76
                DEFB  $09,$01    ,$84,$E7,$E0,$EC
                DEFB  $09,$01    ,$83,$B0,$E0,$76
                DEFB  $09,$01    ,$84,$63,$E0,$EC
                DEFB  $09,$01    ,$83,$B0,$E0,$76
                DEFB  $09,$01    ,$84,$23,$E0,$EC
                DEFB  $09,$01    ,$83,$B0,$E0,$76
                DEFB  $09,$01    ,$83,$49,$E0,$EC
                DEFB  $09,$01    ,$83,$B0,$E0,$76
                DEFB  $09,$01    ,$84,$23,$E0,$EC
                DEFB  $09,$01    ,$83,$B0,$F0,$76
                DEFB  $09,$01    ,$85,$86,$F0,$EC
                DEFB  $09,$01    ,$83,$B0,$F0,$76
                DEFB  $09,$01    ,$84,$E7,$F0,$EC
                DEFB  $09,$01    ,$83,$B0,$F0,$76
                DEFB  $09,$01    ,$84,$63,$F0,$EC
                DEFB  $09,$01    ,$83,$B0,$F0,$76
                DEFB  $09,$01    ,$84,$23,$F0,$EC
                DEFB  $09,$01    ,$83,$B0,$F0,$76
                DEFB  $09,$01    ,$83,$49,$F0,$EC
                DEFB  $09,$01    ,$83,$B0,$F0,$76
                DEFB  $09,$01    ,$84,$23,$F0,$EC
                DEFB  $FF  ; End of Pattern

PAT25:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$85,$86,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$E7,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$63,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$23,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$83,$49,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$C0,$5D
                DEFB  $09,$01    ,$84,$23,$C0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$85,$86,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$E7,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$63,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$23,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$83,$49,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$D0,$5D
                DEFB  $09,$01    ,$84,$23,$D0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$85,$86,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$E7,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$63,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$23,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$83,$49,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$E0,$5D
                DEFB  $09,$01    ,$84,$23,$E0,$BB
                DEFB  $09,$01    ,$83,$B0,$F0,$5D
                DEFB  $09,$01    ,$85,$86,$F0,$BB
                DEFB  $09,$01    ,$83,$B0,$F0,$5D
                DEFB  $09,$01    ,$84,$E7,$F0,$BB
                DEFB  $09,$01    ,$83,$B0,$F0,$5D
                DEFB  $09,$01    ,$84,$63,$F0,$BB
                DEFB  $09,$01    ,$83,$B0,$F0,$5D
                DEFB  $09,$01    ,$84,$23,$F0,$BB
                DEFB  $09,$01    ,$83,$B0,$F0,$5D
                DEFB  $09,$01    ,$83,$49,$F0,$BB
                DEFB  $09,$01    ,$83,$B0,$F0,$5D
                DEFB  $09,$01    ,$84,$23,$F0,$BB
                DEFB  $FF  ; End of Pattern

PAT26:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$83,$B0,$80,$76
                DEFB      $84,$23,$85,$86,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $85,$86,$84,$E7,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$E7,$84,$63,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$63,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$83,$49,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $83,$49,$84,$23,$01
                DEFB      $00    ,$83,$B0,$01
                DEFB      $84,$23,$95,$86,$01
                DEFB      $00    ,$93,$B0,$01
                DEFB      $85,$86,$94,$E7,$01
                DEFB      $00    ,$93,$B0,$01
                DEFB      $84,$E7,$94,$63,$01
                DEFB      $00    ,$93,$B0,$01
                DEFB      $84,$63,$94,$23,$01
                DEFB      $00    ,$93,$B0,$01
                DEFB      $84,$23,$93,$49,$01
                DEFB      $00    ,$93,$B0,$01
                DEFB      $83,$49,$94,$23,$01
                DEFB      $00    ,$A3,$B0,$01
                DEFB      $84,$23,$A5,$86,$01
                DEFB      $00    ,$A3,$B0,$01
                DEFB      $85,$86,$A4,$E7,$01
                DEFB      $00    ,$A3,$B0,$01
                DEFB      $84,$E7,$A4,$63,$01
                DEFB      $00    ,$A3,$B0,$01
                DEFB      $84,$63,$A4,$23,$01
                DEFB      $00    ,$A3,$B0,$01
                DEFB      $84,$23,$A3,$49,$01
                DEFB      $00    ,$A3,$B0,$01
                DEFB      $83,$49,$A4,$23,$01
                DEFB      $00    ,$B3,$B0,$01
                DEFB      $84,$23,$B5,$86,$01
                DEFB      $00    ,$B3,$B0,$01
                DEFB      $85,$86,$B4,$E7,$01
                DEFB      $00    ,$B3,$B0,$01
                DEFB      $84,$E7,$B4,$63,$01
                DEFB      $00    ,$B3,$B0,$01
                DEFB      $84,$63,$B4,$23,$01
                DEFB      $00    ,$B3,$B0,$01
                DEFB      $84,$23,$B3,$49,$01
                DEFB      $00    ,$B3,$B0,$01
                DEFB      $83,$49,$B4,$23,$01
                DEFB  $FF  ; End of Pattern

PAT27:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$C3,$B0,$80,$76
                DEFB      $94,$23,$C5,$86,$01
                DEFB      $00    ,$C3,$B0,$01
                DEFB      $95,$86,$C4,$E7,$01
                DEFB      $00    ,$C3,$B0,$01
                DEFB      $94,$E7,$C4,$63,$01
                DEFB      $00    ,$C3,$B0,$01
                DEFB      $94,$63,$C4,$23,$01
                DEFB      $00    ,$C3,$B0,$01
                DEFB      $94,$23,$C3,$49,$01
                DEFB      $00    ,$C3,$B0,$01
                DEFB      $93,$49,$C4,$23,$01
                DEFB      $00    ,$C3,$B0,$01
                DEFB      $A4,$23,$D5,$86,$01
                DEFB      $00    ,$D3,$B0,$01
                DEFB      $A5,$86,$D4,$E7,$01
                DEFB      $00    ,$D3,$B0,$01
                DEFB      $A4,$E7,$D4,$63,$01
                DEFB      $00    ,$D3,$B0,$01
                DEFB      $A4,$63,$D4,$23,$01
                DEFB      $00    ,$D3,$B0,$01
                DEFB      $A4,$23,$D3,$49,$01
                DEFB      $00    ,$D3,$B0,$01
                DEFB      $A3,$49,$D4,$23,$01
                DEFB      $00    ,$E3,$B0,$01
                DEFB      $B4,$23,$E5,$86,$01
                DEFB      $00    ,$E3,$B0,$01
                DEFB      $B5,$86,$E4,$E7,$01
                DEFB      $00    ,$E3,$B0,$01
                DEFB      $B4,$E7,$E4,$63,$01
                DEFB      $00    ,$E3,$B0,$01
                DEFB      $B4,$63,$E4,$23,$01
                DEFB      $00    ,$E3,$B0,$01
                DEFB      $B4,$23,$E3,$49,$01
                DEFB      $00    ,$E3,$B0,$01
                DEFB      $B3,$49,$E4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C4,$23,$F5,$86,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C5,$86,$F4,$E7,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C4,$E7,$F4,$63,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C4,$63,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C4,$23,$F3,$49,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C3,$49,$F4,$23,$01
                DEFB  $FF  ; End of Pattern

PAT28:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$F3,$B0,$80,$76
                DEFB      $C4,$23,$F5,$86,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C5,$86,$F4,$E7,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C4,$E7,$F4,$63,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C4,$63,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C4,$23,$F3,$49,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $C3,$49,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $D4,$23,$F5,$86,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $D5,$86,$F4,$E7,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $D4,$E7,$F4,$63,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $D4,$63,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $D4,$23,$F3,$49,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $D3,$49,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $E4,$23,$F5,$86,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $E5,$86,$F4,$E7,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $E4,$E7,$F4,$63,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $E4,$63,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $E4,$23,$F3,$49,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $E3,$49,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $F4,$23,$F5,$86,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $F5,$86,$F4,$E7,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $F4,$E7,$F4,$63,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $F4,$63,$F4,$23,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $F4,$23,$F3,$49,$01
                DEFB      $00    ,$F3,$B0,$01
                DEFB      $F3,$49,$F4,$23,$01
                DEFB  $FF  ; End of Pattern

PAT29:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $F3,$B0,$80,$76,$00
                DEFB      $F5,$86,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$E7,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$63,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F3,$49,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB      $F3,$B0,$90,$76,$01
                DEFB      $F5,$86,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$E7,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$63,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F3,$49,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB      $F3,$B0,$B0,$76,$01
                DEFB      $F5,$86,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$E7,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$63,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F3,$49,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB      $F3,$B0,$D0,$76,$01
                DEFB      $F5,$86,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$E7,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$63,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F3,$49,$01    ,$01
                DEFB      $F3,$B0,$01    ,$01
                DEFB      $F4,$23,$01    ,$01
                DEFB  $FF  ; End of Pattern

PAT30:
                DEFW  2464     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $F3,$B0,$F0,$76,$00
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $00    ,$01    ,$01
                DEFB  $FF  ; End of Pattern

PAT31:
                DEFW  3692     ; Pattern tempo
                ;    Drum,Chan.1 ,Chan.2 ,Chan.3
                DEFB      $00    ,$00    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB      $01    ,$01    ,$01
                DEFB  $FF  ; End of Pattern

