/*
 * Decompiled with CFR 0.152.
 */
package updater;

import java.awt.Dimension;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JProgressBar;

public class Updater
extends JFrame {
    String updateurl;
    JProgressBar progress;

    public static void main(String[] args) {
        int localVersion = Updater.localVersion();
        int latestVersion = Updater.latestVersion();
        System.out.println("local: " + localVersion);
        System.out.println("latest: " + latestVersion);
    }

    public static int localVersion() {
        return -1;
    }

    public static int latestVersion() {
        try {
            URL url = new URL("http://my.server.com/~me/stuff/revision.txt");
            HttpURLConnection hConnection = (HttpURLConnection)url.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            if (200 == hConnection.getResponseCode()) {
                BufferedReader is = new BufferedReader(new InputStreamReader(hConnection.getInputStream()));
                int rev = Integer.valueOf(is.readLine());
                return rev;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public Updater(String url) {
        this.updateurl = url;
        this.setPreferredSize(new Dimension(300, 80));
        this.setSize(new Dimension(300, 80));
        this.setTitle("Updater");
        this.progress = new JProgressBar(0, 100);
        this.progress.setValue(0);
        this.progress.setStringPainted(true);
        this.add(this.progress);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.requestFocus(true);
    }

    void downloadLatestVersion() {
        try {
            URL url = new URL(this.updateurl);
            HttpURLConnection hConnection = (HttpURLConnection)url.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            if (200 == hConnection.getResponseCode()) {
                int numRead;
                InputStream in = hConnection.getInputStream();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream("foo.jar"));
                int filesize = hConnection.getContentLength();
                this.progress.setMaximum(filesize);
                byte[] buffer = new byte[4096];
                long numWritten = 0L;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    System.out.println((double)(numWritten += (long)numRead) / (double)filesize);
                    this.progress.setValue((int)numWritten);
                }
                if ((long)filesize != numWritten) {
                    System.out.println("Wrote " + numWritten + " bytes, should have been " + filesize);
                } else {
                    System.out.println("Downloaded successfully.");
                }
                out.close();
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void downloadFile(String sourceurl, String dest) {
        try {
            URL url = new URL(sourceurl);
            HttpURLConnection hConnection = (HttpURLConnection)url.openConnection();
            HttpURLConnection.setFollowRedirects(true);
            if (200 == hConnection.getResponseCode()) {
                int numRead;
                InputStream in = hConnection.getInputStream();
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
                int filesize = hConnection.getContentLength();
                byte[] buffer = new byte[4096];
                long numWritten = 0L;
                while ((numRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, numRead);
                    System.out.println((double)(numWritten += (long)numRead) / (double)filesize);
                }
                if ((long)filesize != numWritten) {
                    System.out.println("Wrote " + numWritten + " bytes, should have been " + filesize);
                } else {
                    System.out.println("Downloaded successfully.");
                }
                out.close();
                in.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

