/*
 * Decompiled with CFR 0.152.
 */
package radio;

import GLEngine.SpriteBatch;
import GLEngine.Texture;
import GLEngine.Vector3f;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import game.Settings;
import java.util.ArrayList;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.player.JavaSoundAudioDevice;
import javazoom.jl.player.Player;

public class Radio {
    private boolean on = true;
    private double volume = 0.1f;
    private double volumeMax = 0.1f;
    private double volumeStep = 0.01f;
    private volatile boolean volChanged = false;
    private volatile int station;
    private ArrayList<Station> stations = new ArrayList();
    private volatile boolean globalClose = false;

    public Radio(double volume, boolean on) {
        this.volume = Math.max(0.0, Math.min(volume, this.volumeMax));
        this.on = on;
        this.stations.add(new Station("HARDBASE", "http://listen.hardbase.fm/tunein-mp3-pls", Texture.RADIO_HARDBASE));
        this.stations.add(new Station("81hiphop ", "http://69.175.13.133:8030/", Texture.RADIO_HIPHOP));
        this.stations.add(new Station("DEATH.fm", "http://hi.death.fm", Texture.RADIO_DEATH));
        this.stations.add(new Station("HARDCORERADIO.nl", "http://shoutcast1.hardcoreradio.nl:80/", Texture.RADIO_HARDCORE));
        this.stations.add(new Station("Jazz ", "http://199.180.72.2:8015/", Texture.RADIO_JAZZ));
        this.stations.add(new Station("Pagan Metal Radio", "http://62.210.209.179:8030/stream", Texture.RADIO_PAGAN));
        this.stations.add(new Station("OFF", "no radio", Texture.RADIO_PAGAN));
        this.loop();
    }

    public synchronized void pressButton(RadioButton button) {
        if (this.on) {
            if (button == RadioButton.STATION_NEXT) {
                ++this.station;
                if (this.station == this.stations.size()) {
                    this.station = 0;
                }
            } else if (button == RadioButton.STATION_PREVIOUS) {
                --this.station;
                if (this.station == -1) {
                    this.station = this.stations.size() - 1;
                }
            } else if (button == RadioButton.VOLUME_DOWN) {
                this.volume -= this.volumeStep;
                if (this.volume < 0.0) {
                    this.volume = 0.0;
                }
                this.volChanged = true;
            } else if (button == RadioButton.VOLUME_UP) {
                this.volume += this.volumeStep;
                if (this.volume > this.volumeMax) {
                    this.volume = this.volumeMax;
                }
                this.volChanged = true;
            }
        }
    }

    public synchronized boolean isOn() {
        return this.on;
    }

    public synchronized String getStationName() {
        if (this.on) {
            return this.stations.get((int)this.station).name;
        }
        return "";
    }

    private void loop() {
        new Thread(){
            int prevStation;
            boolean prevOn;
            Player player;

            @Override
            public void run() {
                while (!Radio.this.globalClose) {
                    int currStation = Radio.this.station;
                    if (currStation < 0 || currStation >= Radio.this.stations.size()) continue;
                    boolean currOn = Radio.this.on;
                    if (currOn && (currStation != this.prevStation || !this.prevOn || Radio.this.volChanged)) {
                        if (this.player != null) {
                            this.player.close();
                        }
                        try {
                            if (((Station)((Radio)Radio.this).stations.get((int)((Radio)Radio.this).station)).name.equals("OFF")) continue;
                            OkHttpClient client = new OkHttpClient();
                            Request request = new Request.Builder().url(((Station)((Radio)Radio.this).stations.get((int)((Radio)Radio.this).station)).url).build();
                            Response response = client.newCall(request).execute();
                            this.player = new Player(response.body().byteStream());
                            new Thread(){

                                @Override
                                public void run() {
                                    try {
                                        player.play(1);
                                        ((JavaSoundAudioDevice)player.audio).setLineGain((float)(20.0 * Math.log10(Radio.this.volume)));
                                        Radio.this.volChanged = false;
                                        player.play();
                                    }
                                    catch (JavaLayerException e) {
                                        e.printStackTrace();
                                    }
                                }
                            }.start();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!Radio.this.on && this.prevOn && this.player != null) {
                        this.player.close();
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.prevStation = currStation;
                    this.prevOn = currOn;
                }
                if (this.player != null) {
                    this.player.close();
                }
            }
        }.start();
    }

    public void close() {
        this.globalClose = true;
    }

    public void render2D(SpriteBatch spriteBatch, Settings settings) {
        if (!this.on) {
            return;
        }
        spriteBatch.renderString("Radio: " + this.stations.get((int)this.station).name, new Vector3f(settings.width / 2 - 170, 50.0f, 0.0f), 0.3f);
    }

    public static enum RadioButton {
        ON_OFF,
        VOLUME_DOWN,
        VOLUME_UP,
        STATION_PREVIOUS,
        STATION_NEXT;

    }

    private class Station {
        String url;
        String name;
        int iconID;

        public Station(String n, String u, int texID) {
            this.url = u;
            this.name = n;
            this.iconID = texID;
        }
    }
}

