/*
 * Decompiled with CFR 0.152.
 */
package physics;

import GLEngine.Mesh;
import com.bulletphysics.collision.shapes.VertexData;
import javax.vecmath.Tuple3f;

public class TriangleVertexData
extends VertexData {
    private Mesh mesh;

    public TriangleVertexData(Mesh mesh) {
        this.mesh = mesh;
    }

    @Override
    public int getIndex(int i) {
        return this.mesh.indices[i];
    }

    @Override
    public int getIndexCount() {
        return this.mesh.indices.length;
    }

    @Override
    public <T extends Tuple3f> T getVertex(int v, T tuple) {
        tuple.x = this.mesh.vertices[v * 3 + 0];
        tuple.y = this.mesh.vertices[v * 3 + 1];
        tuple.z = this.mesh.vertices[v * 3 + 2];
        return tuple;
    }

    @Override
    public int getVertexCount() {
        return this.mesh.vertices.length;
    }

    @Override
    public void setVertex(int i, float x, float y, float z) {
        this.mesh.vertices[i * 3 + 0] = x;
        this.mesh.vertices[i * 3 + 1] = y;
        this.mesh.vertices[i * 3 + 2] = z;
    }
}

