/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class WINDOWPOS
implements Pointer {
    public static final int SIZEOF;
    public static final int HWND;
    public static final int HWNDINSERTAFTER;
    public static final int X;
    public static final int Y;
    public static final int CX;
    public static final int CY;
    public static final int FLAGS;
    private final ByteBuffer struct;

    public WINDOWPOS() {
        this(WINDOWPOS.malloc());
    }

    public WINDOWPOS(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setHwnd(long hwnd) {
        WINDOWPOS.hwnd(this.struct, hwnd);
    }

    public void setHwndInsertAfter(long hwndInsertAfter) {
        WINDOWPOS.hwndInsertAfter(this.struct, hwndInsertAfter);
    }

    public void setX(int x) {
        WINDOWPOS.x(this.struct, x);
    }

    public void setY(int y) {
        WINDOWPOS.y(this.struct, y);
    }

    public void setCx(int cx) {
        WINDOWPOS.cx(this.struct, cx);
    }

    public void setCy(int cy) {
        WINDOWPOS.cy(this.struct, cy);
    }

    public void setFlags(int flags) {
        WINDOWPOS.flags(this.struct, flags);
    }

    public long getHwnd() {
        return WINDOWPOS.hwnd(this.struct);
    }

    public long getHwndInsertAfter() {
        return WINDOWPOS.hwndInsertAfter(this.struct);
    }

    public int getX() {
        return WINDOWPOS.x(this.struct);
    }

    public int getY() {
        return WINDOWPOS.y(this.struct);
    }

    public int getCx() {
        return WINDOWPOS.cx(this.struct);
    }

    public int getCy() {
        return WINDOWPOS.cy(this.struct);
    }

    public int getFlags() {
        return WINDOWPOS.flags(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long hwnd, long hwndInsertAfter, int x, int y, int cx, int cy, int flags) {
        ByteBuffer windowpos = WINDOWPOS.malloc();
        WINDOWPOS.hwnd(windowpos, hwnd);
        WINDOWPOS.hwndInsertAfter(windowpos, hwndInsertAfter);
        WINDOWPOS.x(windowpos, x);
        WINDOWPOS.y(windowpos, y);
        WINDOWPOS.cx(windowpos, cx);
        WINDOWPOS.cy(windowpos, cy);
        WINDOWPOS.flags(windowpos, flags);
        return windowpos;
    }

    public static void hwnd(ByteBuffer windowpos, long hwnd) {
        PointerBuffer.put(windowpos, windowpos.position() + HWND, hwnd);
    }

    public static void hwndInsertAfter(ByteBuffer windowpos, long hwndInsertAfter) {
        PointerBuffer.put(windowpos, windowpos.position() + HWNDINSERTAFTER, hwndInsertAfter);
    }

    public static void x(ByteBuffer windowpos, int x) {
        windowpos.putInt(windowpos.position() + X, x);
    }

    public static void y(ByteBuffer windowpos, int y) {
        windowpos.putInt(windowpos.position() + Y, y);
    }

    public static void cx(ByteBuffer windowpos, int cx) {
        windowpos.putInt(windowpos.position() + CX, cx);
    }

    public static void cy(ByteBuffer windowpos, int cy) {
        windowpos.putInt(windowpos.position() + CY, cy);
    }

    public static void flags(ByteBuffer windowpos, int flags) {
        windowpos.putInt(windowpos.position() + FLAGS, flags);
    }

    public static long hwnd(ByteBuffer windowpos) {
        return PointerBuffer.get(windowpos, windowpos.position() + HWND);
    }

    public static long hwndInsertAfter(ByteBuffer windowpos) {
        return PointerBuffer.get(windowpos, windowpos.position() + HWNDINSERTAFTER);
    }

    public static int x(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + X);
    }

    public static int y(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + Y);
    }

    public static int cx(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + CX);
    }

    public static int cy(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + CY);
    }

    public static int flags(ByteBuffer windowpos) {
        return windowpos.getInt(windowpos.position() + FLAGS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(7);
        SIZEOF = WINDOWPOS.offsets(MemoryUtil.memAddress(offsets));
        HWND = offsets.get(0);
        HWNDINSERTAFTER = offsets.get(1);
        X = offsets.get(2);
        Y = offsets.get(3);
        CX = offsets.get(4);
        CY = offsets.get(5);
        FLAGS = offsets.get(6);
    }
}

