/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XIButtonState
implements Pointer {
    public static final int SIZEOF;
    public static final int MASK_LEN;
    public static final int MASK;
    private final ByteBuffer struct;

    public XIButtonState() {
        this(XIButtonState.malloc());
    }

    public XIButtonState(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setMaskLen(int mask_len) {
        XIButtonState.mask_len(this.struct, mask_len);
    }

    public void setMask(long mask) {
        XIButtonState.mask(this.struct, mask);
    }

    public void setMask(ByteBuffer mask) {
        XIButtonState.mask(this.struct, mask);
    }

    public int getMaskLen() {
        return XIButtonState.mask_len(this.struct);
    }

    public long getMask() {
        return XIButtonState.mask(this.struct);
    }

    public ByteBuffer getMask(int byteLen) {
        return XIButtonState.mask(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int mask_len, ByteBuffer mask) {
        ByteBuffer xibuttonstate = XIButtonState.malloc();
        XIButtonState.mask_len(xibuttonstate, mask_len);
        XIButtonState.mask(xibuttonstate, mask);
        return xibuttonstate;
    }

    public static void mask_len(ByteBuffer xibuttonstate, int mask_len) {
        xibuttonstate.putInt(xibuttonstate.position() + MASK_LEN, mask_len);
    }

    public static void mask(ByteBuffer xibuttonstate, long mask) {
        PointerBuffer.put(xibuttonstate, xibuttonstate.position() + MASK, mask);
    }

    public static void mask(ByteBuffer xibuttonstate, ByteBuffer mask) {
        XIButtonState.mask(xibuttonstate, MemoryUtil.memAddressSafe(mask));
    }

    public static int mask_len(ByteBuffer xibuttonstate) {
        return xibuttonstate.getInt(xibuttonstate.position() + MASK_LEN);
    }

    public static long mask(ByteBuffer xibuttonstate) {
        return PointerBuffer.get(xibuttonstate, xibuttonstate.position() + MASK);
    }

    public static ByteBuffer mask(ByteBuffer xibuttonstate, int byteLen) {
        return MemoryUtil.memByteBuffer(XIButtonState.mask(xibuttonstate), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XIButtonState.offsets(MemoryUtil.memAddress(offsets));
        MASK_LEN = offsets.get(0);
        MASK = offsets.get(1);
    }
}

