/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.DynamicLinkLibrary;
import org.lwjgl.system.linux.LinuxLibrary;
import org.lwjgl.system.macosx.MacOSXLibrary;
import org.lwjgl.system.windows.WindowsLibrary;

public final class APIUtil {
    private static final ThreadLocal<APIBuffer> API_BUFFERS = new ThreadLocal<APIBuffer>(){

        @Override
        protected APIBuffer initialValue() {
            return new APIBuffer();
        }
    };

    private APIUtil() {
    }

    public static APIBuffer apiBuffer() {
        return API_BUFFERS.get().reset();
    }

    public static APIBuffer apiStack() {
        return API_BUFFERS.get().push();
    }

    public static DynamicLinkLibrary apiCreateLibrary(String name) {
        switch (LWJGLUtil.getPlatform()) {
            case WINDOWS: {
                return new WindowsLibrary(name);
            }
            case LINUX: {
                return new LinuxLibrary(name);
            }
            case MACOSX: {
                return MacOSXLibrary.create(name);
            }
        }
        throw new IllegalStateException();
    }

    public static APIVersion apiParseVersion(String version) {
        return APIUtil.apiParseVersion(version, null);
    }

    public static APIVersion apiParseVersion(String version, String prefix) {
        Matcher matcher;
        String pattern = "([0-9]+)[.]([0-9]+)([.]\\S+)?\\s*(.+)?";
        if (prefix != null) {
            pattern = prefix + "\\s+" + pattern;
        }
        if (!(matcher = Pattern.compile(pattern).matcher(version)).matches()) {
            throw new IllegalArgumentException(String.format("Malformed API version string [%s]", version));
        }
        return new APIVersion(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), matcher.group(3), matcher.group(4));
    }

    static {
        LWJGLUtil.initialize();
    }

    public static class APIVersion {
        public final int major;
        public final int minor;
        public final String revision;
        public final String implementation;

        public APIVersion(int major, int minor, String revision, String implementation) {
            this.major = major;
            this.minor = minor;
            this.revision = revision;
            this.implementation = implementation;
        }
    }
}

