/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GLXSGIXPBuffer {
    public static final int GLX_MAX_PBUFFER_WIDTH_SGIX = 32790;
    public static final int GLX_MAX_PBUFFER_HEIGHT_SGIX = 32791;
    public static final int GLX_MAX_PBUFFER_PIXELS_SGIX = 32792;
    public static final int GLX_OPTIMAL_PBUFFER_WIDTH_SGIX = 32793;
    public static final int GLX_OPTIMAL_PBUFFER_HEIGHT_SGIX = 32794;
    public static final int GLX_PBUFFER_BIT_SGIX = 4;
    public static final int GLX_PRESERVED_CONTENTS_SGIX = 32795;
    public static final int GLX_LARGEST_PBUFFER_SGIX = 32796;
    public static final int GLX_WIDTH_SGIX = 32797;
    public static final int GLX_HEIGHT_SGIX = 32798;
    public static final int GLX_EVENT_MASK_SGIX = 32799;
    public static final int GLX_BUFFER_CLOBBER_MASK_SGIX = 0x8000000;
    public static final int GLX_DAMAGED_SGIX = 32800;
    public static final int GLX_SAVED_SGIX = 32801;
    public static final int GLX_WINDOW_SGIX = 32802;
    public static final int GLX_PBUFFER_SGIX = 32803;
    public static final int GLX_FRONT_LEFT_BUFFER_BIT_SGIX = 1;
    public static final int GLX_FRONT_RIGHT_BUFFER_BIT_SGIX = 2;
    public static final int GLX_BACK_LEFT_BUFFER_BIT_SGIX = 4;
    public static final int GLX_BACK_RIGHT_BUFFER_BIT_SGIX = 8;
    public static final int GLX_AUX_BUFFERS_BIT_SGIX = 16;
    public static final int GLX_DEPTH_BUFFER_BIT_SGIX = 32;
    public static final int GLX_STENCIL_BUFFER_BIT_SGIX = 64;
    public static final int GLX_ACCUM_BUFFER_BIT_SGIX = 128;
    public static final int GLX_SAMPLE_BUFFERS_BIT_SGIX = 256;
    public final long CreateGLXPbufferSGIX;
    public final long DestroyGLXPbufferSGIX;
    public final long QueryGLXPbufferSGIX;
    public final long SelectEventSGIX;
    public final long GetSelectedEventSGIX;

    public GLXSGIXPBuffer(FunctionProvider provider) {
        this.CreateGLXPbufferSGIX = provider.getFunctionAddress("glXCreateGLXPbufferSGIX");
        this.DestroyGLXPbufferSGIX = provider.getFunctionAddress("glXDestroyGLXPbufferSGIX");
        this.QueryGLXPbufferSGIX = provider.getFunctionAddress("glXQueryGLXPbufferSGIX");
        this.SelectEventSGIX = provider.getFunctionAddress("glXSelectEventSGIX");
        this.GetSelectedEventSGIX = provider.getFunctionAddress("glXGetSelectedEventSGIX");
    }

    public static GLXSGIXPBuffer getInstance() {
        return GL.getCapabilities().__GLXSGIXPBuffer;
    }

    static GLXSGIXPBuffer create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_SGIX_pbuffer")) {
            return null;
        }
        GLXSGIXPBuffer funcs = new GLXSGIXPBuffer(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateGLXPbufferSGIX, funcs.DestroyGLXPbufferSGIX, funcs.QueryGLXPbufferSGIX, funcs.SelectEventSGIX, funcs.GetSelectedEventSGIX);
        return GL.checkExtension("GLX_SGIX_pbuffer", funcs, supported);
    }

    public static native long nglXCreateGLXPbufferSGIX(long var0, long var2, int var4, int var5, long var6, long var8);

    public static long nglXCreateGLXPbufferSGIX(long display, long config, int width, int height, long attrib_list) {
        long __functionAddress = GLXSGIXPBuffer.getInstance().CreateGLXPbufferSGIX;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLXSGIXPBuffer.nglXCreateGLXPbufferSGIX(display, config, width, height, attrib_list, __functionAddress);
    }

    public static long glXCreateGLXPbufferSGIX(long display, long config, int width, int height, ByteBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        return GLXSGIXPBuffer.nglXCreateGLXPbufferSGIX(display, config, width, height, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long glXCreateGLXPbufferSGIX(long display, long config, int width, int height, IntBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        return GLXSGIXPBuffer.nglXCreateGLXPbufferSGIX(display, config, width, height, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static native void nglXDestroyGLXPbufferSGIX(long var0, long var2, long var4);

    public static void glXDestroyGLXPbufferSGIX(long display, long pbuf) {
        long __functionAddress = GLXSGIXPBuffer.getInstance().DestroyGLXPbufferSGIX;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(pbuf);
        }
        GLXSGIXPBuffer.nglXDestroyGLXPbufferSGIX(display, pbuf, __functionAddress);
    }

    public static native void nglXQueryGLXPbufferSGIX(long var0, long var2, int var4, long var5, long var7);

    public static void nglXQueryGLXPbufferSGIX(long display, long pbuf, int attribute, long value) {
        long __functionAddress = GLXSGIXPBuffer.getInstance().QueryGLXPbufferSGIX;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(pbuf);
        }
        GLXSGIXPBuffer.nglXQueryGLXPbufferSGIX(display, pbuf, attribute, value, __functionAddress);
    }

    public static void glXQueryGLXPbufferSGIX(long display, long pbuf, int attribute, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GLXSGIXPBuffer.nglXQueryGLXPbufferSGIX(display, pbuf, attribute, MemoryUtil.memAddress(value));
    }

    public static void glXQueryGLXPbufferSGIX(long display, long pbuf, int attribute, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GLXSGIXPBuffer.nglXQueryGLXPbufferSGIX(display, pbuf, attribute, MemoryUtil.memAddress(value));
    }

    public static native void nglXSelectEventSGIX(long var0, long var2, long var4, long var6);

    public static void glXSelectEventSGIX(long display, long drawable, long mask) {
        long __functionAddress = GLXSGIXPBuffer.getInstance().SelectEventSGIX;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        GLXSGIXPBuffer.nglXSelectEventSGIX(display, drawable, mask, __functionAddress);
    }

    public static native void nglXGetSelectedEventSGIX(long var0, long var2, long var4, long var6);

    public static void nglXGetSelectedEventSGIX(long display, long drawable, long mask) {
        long __functionAddress = GLXSGIXPBuffer.getInstance().GetSelectedEventSGIX;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        GLXSGIXPBuffer.nglXGetSelectedEventSGIX(display, drawable, mask, __functionAddress);
    }

    public static void glXGetSelectedEventSGIX(long display, long drawable, ByteBuffer mask) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)mask, 1 << Pointer.POINTER_SHIFT);
        }
        GLXSGIXPBuffer.nglXGetSelectedEventSGIX(display, drawable, MemoryUtil.memAddress(mask));
    }

    public static void glXGetSelectedEventSGIX(long display, long drawable, PointerBuffer mask) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(mask, 1);
        }
        GLXSGIXPBuffer.nglXGetSelectedEventSGIX(display, drawable, MemoryUtil.memAddress(mask));
    }
}

