/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALContext;
import org.lwjgl.openal.ALDevice;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.DynamicLinkLibrary;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.MemoryUtil;

public final class ALC {
    private static FunctionProviderLocal functionProvider;

    private ALC() {
    }

    public static void create() {
        String libName;
        switch (LWJGLUtil.getPlatform()) {
            case WINDOWS: {
                libName = "OpenAL";
                break;
            }
            case LINUX: {
                libName = "openal";
                break;
            }
            case MACOSX: {
                libName = "openal";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ALC.create(System.getProperty("org.lwjgl.openal.libname", Pointer.BITS64 ? libName : libName + "32"));
    }

    public static void create(String libName) {
        if (functionProvider != null) {
            throw new IllegalStateException("OpenAL has already been created.");
        }
        final DynamicLinkLibrary OPENAL = LWJGLUtil.loadLibraryNative(libName);
        functionProvider = new FunctionProviderLocal.Default(){
            private final long alcGetProcAddress = this.getFunctionAddress("alcGetProcAddress");
            {
                if (this.alcGetProcAddress == 0L) {
                    OPENAL.release();
                    throw new RuntimeException("A core ALC function is missing. Make sure that OpenAL has been loaded.");
                }
            }

            @Override
            public long getFunctionAddress(CharSequence functionName) {
                long address = OPENAL.getFunctionAddress(functionName);
                if (address == 0L) {
                    LWJGLUtil.log("Failed to locate address for ALC function " + functionName);
                }
                return address;
            }

            @Override
            public long getFunctionAddress(long handle, CharSequence functionName) {
                APIBuffer __buffer = APIUtil.apiBuffer();
                __buffer.stringParamASCII(functionName, true);
                long address = ALC10.nalcGetProcAddress(handle, __buffer.address(), this.alcGetProcAddress);
                if (address == 0L) {
                    LWJGLUtil.log("Failed to locate address for ALC extension function " + functionName);
                }
                return address;
            }

            @Override
            protected void destroy() {
                OPENAL.release();
            }
        };
        AL.init();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.destroy();
        functionProvider.release();
        functionProvider = null;
    }

    public static FunctionProviderLocal getFunctionProvider() {
        return functionProvider;
    }

    public static ALCCapabilities getCapabilities() {
        ALContext context = AL.getCurrentContext();
        if (context != null) {
            return context.getDevice().getCapabilities();
        }
        return ALDevice.getLastDevice().getCapabilities();
    }

    public static List<String> getStringList(long deviceHandle, int token) {
        long __result = ALC10.nalcGetString(deviceHandle, token);
        if (__result == 0L) {
            return null;
        }
        ByteBuffer buffer = MemoryUtil.memByteBuffer(__result, Integer.MAX_VALUE);
        ArrayList<String> strings = new ArrayList<String>();
        int offset = 0;
        while (true) {
            if (buffer.get() != 0) {
                continue;
            }
            int limit = buffer.position() - 1;
            if (limit == offset) break;
            buffer.position(offset);
            buffer.limit(limit);
            strings.add(MemoryUtil.memDecodeUTF8(buffer));
            buffer.limit(Integer.MAX_VALUE);
            offset = limit + 1;
            buffer.position(offset);
        }
        return strings;
    }

    static ALCCapabilities createCapabilities(long device) {
        long GetIntegerv = functionProvider.getFunctionAddress("alcGetIntegerv");
        long GetString = functionProvider.getFunctionAddress("alcGetString");
        long IsExtensionPresent = functionProvider.getFunctionAddress("alcIsExtensionPresent");
        if (GetIntegerv == 0L || GetString == 0L || IsExtensionPresent == 0L) {
            throw new IllegalStateException("Core ALC functions could not be found. Make sure that OpenAL has been loaded.");
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        ALC10.nalcGetIntegerv(device, 4096, 1, __buffer.address(), GetIntegerv);
        ALC10.nalcGetIntegerv(device, 4097, 1, __buffer.address(4), GetIntegerv);
        int majorVersion = __buffer.intValue(0);
        int minorVersion = __buffer.intValue(4);
        int[][] ALC_VERSIONS = new int[][]{{0, 1}};
        HashSet<String> supportedExtensions = new HashSet<String>(16);
        for (int major = 1; major <= ALC_VERSIONS.length; ++major) {
            int[] minors;
            for (int minor : minors = ALC_VERSIONS[major - 1]) {
                if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                supportedExtensions.add("OpenALC" + Integer.toString(major) + Integer.toString(minor));
            }
        }
        String extensionsString = MemoryUtil.memDecodeUTF8(Checks.checkPointer(ALC10.nalcGetString(device, 4102, GetString)));
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            String extName = tokenizer.nextToken();
            __buffer.reset().stringParamASCII(extName, true);
            if (!ALC10.nalcIsExtensionPresent(device, __buffer.address(), IsExtensionPresent)) continue;
            supportedExtensions.add(extName);
        }
        return new ALCCapabilities(ALC.getFunctionProvider(), device, supportedExtensions);
    }

    static <T> T checkExtension(String extension, T functions, boolean supported) {
        if (supported) {
            return functions;
        }
        LWJGLUtil.log("[ALC] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    static {
        if (!Boolean.getBoolean("org.lwjgl.openal.explicitInit")) {
            ALC.create();
        }
    }
}

