/*
 * Decompiled with CFR 0.152.
 */
package entity;

import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.Texture;
import GLEngine.Vector3f;
import com.bulletphysics.collision.shapes.BoxShape;
import com.bulletphysics.collision.shapes.CompoundShape;
import com.bulletphysics.collision.shapes.CylinderShapeX;
import com.bulletphysics.dynamics.RigidBody;
import com.bulletphysics.dynamics.vehicle.DefaultVehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.RaycastVehicle;
import com.bulletphysics.dynamics.vehicle.VehicleRaycaster;
import com.bulletphysics.dynamics.vehicle.VehicleTuning;
import com.bulletphysics.dynamics.vehicle.WheelInfo;
import com.bulletphysics.linearmath.Transform;
import entity.Entity;
import entity.VehicleInfo;
import physics.Physics;

public class VehicleEntity
extends Entity {
    protected float wheelAxelDistance = 2.0f;
    protected float wheelFrontBackDistance = 2.2f;
    protected final int rightIndex = 0;
    protected final int upIndex = 1;
    protected final int forwardIndex = 2;
    protected final javax.vecmath.Vector3f wheelDirectionCS0 = new javax.vecmath.Vector3f(0.0f, -1.0f, 0.0f);
    protected final javax.vecmath.Vector3f wheelAxleCS = new javax.vecmath.Vector3f(-1.0f, 0.0f, 0.0f);
    public float gEngineForce = 0.0f;
    public float gBreakingForce = 0.0f;
    protected static float maxEngineForce = 5000.0f;
    protected static float maxBackwardForce = -500.0f;
    protected static float maxBreakingForce = 100.0f;
    protected float gVehicleSteering = 0.0f;
    protected float steeringIncrement = 0.1f;
    protected float steeringClamp = 0.6f;
    public float wheelRadius = 0.4f;
    public float wheelWidth = 0.6f;
    protected float wheelFriction = 3000.0f;
    protected float suspensionStiffness = 20.0f;
    protected float suspensionDamping = 2.3f;
    protected float suspensionCompression = 4.4f;
    protected float rollInfluence = 0.1f;
    protected float suspensionRestLength = 1.0f;
    protected RigidBody carChassis;
    protected VehicleTuning tuning = new VehicleTuning();
    protected VehicleRaycaster vehicleRayCaster;
    public RaycastVehicle vehicle;
    protected static int WHEEL_TEXTURE_ID = new Texture((String)"textures/wheel.png").textureID;

    public VehicleEntity(Physics physics, javax.vecmath.Vector3f position, javax.vecmath.Vector3f headingTarget, VehicleInfo vehicleInfo, int textureID, Mesh mesh) {
        super(physics);
        maxEngineForce = vehicleInfo.maxEngineForce;
        this.wheelFriction = vehicleInfo.wheelFriction;
        this.suspensionStiffness = vehicleInfo.suspensionStiffness;
        this.suspensionDamping = vehicleInfo.suspensionDamping;
        this.suspensionCompression = vehicleInfo.suspensionCompression;
        this.rollInfluence = vehicleInfo.rollInfluence;
        this.suspensionRestLength = vehicleInfo.suspensionRestLength;
        this.steeringIncrement = vehicleInfo.steeringIncrement;
        this.steeringClamp = vehicleInfo.steeringClamp;
        maxBackwardForce = vehicleInfo.maxBackwardForce;
        this.textureID = textureID;
        Transform tr = new Transform();
        tr.setIdentity();
        this.tuning.suspensionCompression = this.suspensionCompression;
        this.tuning.suspensionDamping = this.suspensionDamping;
        this.tuning.suspensionStiffness = this.suspensionStiffness;
        BoxShape chassisShape = new BoxShape(new javax.vecmath.Vector3f(1.0f, 0.75f, 2.5f));
        physics.getCollisionShapes().add(chassisShape);
        CompoundShape compound = new CompoundShape();
        physics.getCollisionShapes().add(compound);
        Transform localTrans = new Transform();
        localTrans.setIdentity();
        localTrans.origin.set(0.0f, 1.0f, 0.5f);
        compound.addChildShape(localTrans, chassisShape);
        tr.origin.set(position);
        float dx = position.x - headingTarget.x;
        float dz = position.z - headingTarget.z;
        float angle = (float)Math.atan2(-dz, dx);
        tr.basis.rotY(angle - 1.5f);
        this.carChassis = physics.localCreateRigidBody(vehicleInfo.weight, tr, compound);
        this.vehicleRayCaster = new DefaultVehicleRaycaster(physics.getDynamicsWorld());
        this.vehicle = new RaycastVehicle(this.tuning, this.carChassis, this.vehicleRayCaster);
        this.carChassis.setActivationState(4);
        physics.getDynamicsWorld().addVehicle(this.vehicle);
        float connectionHeight = 1.2f;
        boolean isFrontWheel = true;
        this.vehicle.setCoordinateSystem(0, 1, 2);
        javax.vecmath.Vector3f connectionPointCS0 = new javax.vecmath.Vector3f(this.wheelAxelDistance * 0.5f - 0.3f * this.wheelWidth, connectionHeight, 2.0f * this.wheelFrontBackDistance * 0.5f - this.wheelRadius);
        this.vehicle.addWheel(connectionPointCS0, this.wheelDirectionCS0, this.wheelAxleCS, this.suspensionRestLength, this.wheelRadius, this.tuning, isFrontWheel);
        connectionPointCS0.set(-this.wheelAxelDistance * 0.5f + 0.3f * this.wheelWidth, connectionHeight, 2.0f * this.wheelFrontBackDistance * 0.5f - this.wheelRadius);
        this.vehicle.addWheel(connectionPointCS0, this.wheelDirectionCS0, this.wheelAxleCS, this.suspensionRestLength, this.wheelRadius, this.tuning, isFrontWheel);
        connectionPointCS0.set(-this.wheelAxelDistance * 0.5f + 0.3f * this.wheelWidth, connectionHeight, -2.0f * this.wheelFrontBackDistance * 0.5f + this.wheelRadius);
        isFrontWheel = false;
        this.vehicle.addWheel(connectionPointCS0, this.wheelDirectionCS0, this.wheelAxleCS, this.suspensionRestLength, this.wheelRadius, this.tuning, isFrontWheel);
        connectionPointCS0.set(this.wheelAxelDistance * 0.5f - 0.3f * this.wheelWidth, connectionHeight, -2.0f * this.wheelFrontBackDistance * 0.5f + this.wheelRadius);
        this.vehicle.addWheel(connectionPointCS0, this.wheelDirectionCS0, this.wheelAxleCS, this.suspensionRestLength, this.wheelRadius, this.tuning, isFrontWheel);
        int i = 0;
        while (i < this.vehicle.getNumWheels()) {
            WheelInfo wheel = this.vehicle.getWheelInfo(i);
            wheel.suspensionStiffness = this.suspensionStiffness;
            wheel.wheelsDampingRelaxation = this.suspensionDamping;
            wheel.wheelsDampingCompression = this.suspensionCompression;
            wheel.frictionSlip = this.wheelFriction;
            wheel.rollInfluence = this.rollInfluence;
            ++i;
        }
        compound.setUserPointer(new Entity(null){

            @Override
            public void collidedWith(Entity entity) {
                System.out.println("comp " + entity);
            }
        });
        this.body = this.carChassis;
        this.mesh = mesh;
        this.setBodyUserPointer();
    }

    @Override
    public void update() {
        int wheelIndex = 0;
        this.vehicle.applyEngineForce(this.gEngineForce, wheelIndex);
        this.vehicle.setBrake(this.gBreakingForce, wheelIndex);
        wheelIndex = 1;
        this.vehicle.applyEngineForce(this.gEngineForce, wheelIndex);
        this.vehicle.setBrake(this.gBreakingForce, wheelIndex);
        wheelIndex = 0;
        this.vehicle.setSteeringValue(this.gVehicleSteering, wheelIndex);
        wheelIndex = 1;
        this.vehicle.setSteeringValue(this.gVehicleSteering, wheelIndex);
        this.gEngineForce = 0.0f;
        this.gBreakingForce = 0.0f;
    }

    public void forward() {
        this.gEngineForce = maxEngineForce * this.speedMul();
    }

    public void backward() {
        if (this.vehicle.getCurrentSpeedKmHour() > 1.0f) {
            this.gBreakingForce = maxBreakingForce;
        } else {
            this.gEngineForce = maxBackwardForce * this.speedMul();
        }
    }

    private float speedMul() {
        return Math.abs(this.vehicle.getCurrentSpeedKmHour()) < 40.0f ? 5 : 1;
    }

    public void steerLeft() {
        float frac = 1.0f - Math.abs(this.vehicle.getCurrentSpeedKmHour()) / 200.0f;
        frac = frac > 1.0f ? 1.0f : frac;
        frac = (double)frac < 0.3 ? 0.3f : frac;
        float clamp = this.steeringClamp * frac;
        this.gVehicleSteering += this.steeringIncrement;
        if (this.gVehicleSteering > clamp) {
            this.gVehicleSteering = clamp;
        }
    }

    public void steerRight() {
        float frac = 1.0f - Math.abs(this.vehicle.getCurrentSpeedKmHour()) / 200.0f;
        frac = frac > 1.0f ? 1.0f : frac;
        frac = (double)frac < 0.3 ? 0.3f : frac;
        float clamp = this.steeringClamp * frac;
        this.gVehicleSteering -= this.steeringIncrement;
        if (this.gVehicleSteering < -clamp) {
            this.gVehicleSteering = -clamp;
        }
    }

    @Override
    public void render(MeshBatch meshBatch) {
        this.renderChassi(meshBatch);
        this.renderWheels(meshBatch);
        this.renderShadow(meshBatch);
    }

    protected void renderChassi(MeshBatch meshBatch) {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        Matrix4f real = Matrix4f.identity();
        real.elements = new float[]{mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33};
        Matrix4f fix = Matrix4f.translate(new Vector3f(0.0f, 0.4f, 0.0f));
        real = real.multiply(fix);
        meshBatch.render(this.mesh, this.textureID, real);
    }

    protected void renderWheels(MeshBatch meshBatch) {
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        CylinderShapeX wheelShape = new CylinderShapeX(new javax.vecmath.Vector3f(this.wheelWidth, this.wheelRadius, this.wheelRadius));
        int i = 0;
        while (i < this.vehicle.getNumWheels()) {
            this.vehicle.updateWheelTransform(i, true);
            Transform trans = this.vehicle.getWheelInfo((int)i).worldTransform;
            float[] radius = new float[1];
            javax.vecmath.Vector3f center = new javax.vecmath.Vector3f();
            wheelShape.getBoundingSphere(center, radius);
            mat = new javax.vecmath.Matrix4f();
            trans.getMatrix(mat);
            mat.setScale(this.wheelRadius * 2.0f);
            meshBatch.render(Mesh.getMesh("objfiles/wheel.obj", 1.0f), WHEEL_TEXTURE_ID, mat);
            ++i;
        }
    }

    protected void renderShadow(MeshBatch meshBatch) {
    }

    public double getCurrentSpeedKmHour() {
        return this.vehicle.getCurrentSpeedKmHour();
    }
}

