/*
 * Decompiled with CFR 0.152.
 */
package entity;

import GLEngine.InputHandler;
import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.MeshBatch;
import GLEngine.SpriteBatch;
import GLEngine.Texture;
import GLEngine.Vector3f;
import com.bulletphysics.linearmath.Transform;
import entity.DynamicEntity;
import entity.Entity;
import entity.VehicleEntity;
import entity.VehicleInfo;
import game.Camera;
import game.Game;
import game.MissionHandler;
import physics.Physics;
import sound.Sound;

public class PlayerVehicle
extends VehicleEntity {
    private Sound sound;
    private Camera camera;
    private static VehicleInfo VEHICLE_INFO = new VehicleInfo();
    protected static int TEXTURE_ID = new Texture((String)"textures/cars/LP_Car_11_MAP_1.png").textureID;
    private float ticksTurned = 1.0f;
    private long lastTimeCrashPlayed;
    int scaleTime = 42;
    int scaleTick = -1;

    static {
        PlayerVehicle.VEHICLE_INFO.weight = 1000.0f;
        PlayerVehicle.VEHICLE_INFO.maxEngineForce = 2000.0f;
        PlayerVehicle.VEHICLE_INFO.maxBackwardForce = -2000.0f;
        PlayerVehicle.VEHICLE_INFO.wheelFriction = 100.0f;
        PlayerVehicle.VEHICLE_INFO.suspensionStiffness = 30.0f;
        PlayerVehicle.VEHICLE_INFO.suspensionDamping = 15.0f;
        PlayerVehicle.VEHICLE_INFO.suspensionCompression = 20.0f;
        PlayerVehicle.VEHICLE_INFO.rollInfluence = 1.0f;
        PlayerVehicle.VEHICLE_INFO.suspensionRestLength = 1.0f;
        PlayerVehicle.VEHICLE_INFO.steeringIncrement = 0.04f;
        PlayerVehicle.VEHICLE_INFO.steeringClamp = 0.4f;
    }

    public PlayerVehicle(Physics physics, javax.vecmath.Vector3f position, Sound sound, Camera camera) {
        super(physics, position, new javax.vecmath.Vector3f(30.0f, 0.0f, 30.0f), VEHICLE_INFO, TEXTURE_ID, Mesh.CAR_PLAYER);
        this.sound = sound;
        this.camera = camera;
    }

    @Override
    public void update() {
        super.update();
        --this.scaleTick;
        if (this.isAutoTurnAvailable()) {
            this.ticksTurned += 0.1f;
            javax.vecmath.Vector3f v = new javax.vecmath.Vector3f();
            this.vehicle.getForwardVector(v);
            v.normalize();
            v.scale(-4000.0f * this.ticksTurned);
            this.vehicle.getRigidBody().applyTorque(v);
            javax.vecmath.Vector3f force = new javax.vecmath.Vector3f(0.0f, 1.0f, 0.0f);
            force.scale(500000.0f * this.ticksTurned);
        } else {
            this.ticksTurned = 1.0f;
        }
    }

    private boolean isAutoTurnAvailable() {
        return Math.abs(this.vehicle.getCurrentSpeedKmHour()) < 5.0f && this.getUpVec().y < 0.0f;
    }

    public void render2D(SpriteBatch spriteBatch) {
    }

    public void updateInput() {
        javax.vecmath.Vector3f v;
        javax.vecmath.Vector3f v2;
        Transform t2;
        Transform t1;
        if (InputHandler.pressed(32) && Game.DEBUG_KEYS) {
            javax.vecmath.Vector3f force = new javax.vecmath.Vector3f(0.0f, 1.0f, 0.0f);
            force.scale(1000000.0f);
            this.vehicle.getRigidBody().applyCentralForce(force);
        }
        if (InputHandler.down(340) && Game.DEBUG_KEYS) {
            javax.vecmath.Vector3f vec = new javax.vecmath.Vector3f();
            this.vehicle.getForwardVector(vec);
            vec.scale(20000.0f);
            this.vehicle.getRigidBody().applyCentralForce(vec);
        }
        if (InputHandler.pressed(265)) {
            this.sound.play(Sound.START);
        }
        if (InputHandler.down(265)) {
            this.sound.setMusic(Sound.FULL);
        } else {
            this.sound.setMusic(Sound.IDLE);
        }
        if (InputHandler.down(265)) {
            this.forward();
        }
        if (InputHandler.down(264)) {
            this.backward();
        }
        if (InputHandler.down(263)) {
            this.steerLeft();
        }
        if (InputHandler.down(262)) {
            this.steerRight();
        }
        float torque = 2000.0f;
        if (InputHandler.down(87) && Game.DEBUG_KEYS) {
            t1 = new Transform();
            t2 = new Transform();
            this.vehicle.getWheelTransformWS(0, t1);
            this.vehicle.getWheelTransformWS(1, t2);
            v2 = new javax.vecmath.Vector3f(t1.origin.x - t2.origin.x, t1.origin.y - t2.origin.y, t1.origin.z - t2.origin.z);
            v2.normalize();
            v2.scale(torque);
            this.vehicle.getRigidBody().applyTorque(v2);
        }
        if (InputHandler.down(83) && Game.DEBUG_KEYS) {
            t1 = new Transform();
            t2 = new Transform();
            this.vehicle.getWheelTransformWS(0, t1);
            this.vehicle.getWheelTransformWS(1, t2);
            v2 = new javax.vecmath.Vector3f(t1.origin.x - t2.origin.x, t1.origin.y - t2.origin.y, t1.origin.z - t2.origin.z);
            v2.normalize();
            v2.scale(-torque);
            this.vehicle.getRigidBody().applyTorque(v2);
        }
        if (InputHandler.down(65) && Game.DEBUG_KEYS) {
            v = new javax.vecmath.Vector3f();
            this.vehicle.getForwardVector(v);
            v.normalize();
            v.scale(-torque);
            this.vehicle.getRigidBody().applyTorque(v);
        }
        if (InputHandler.down(68) && Game.DEBUG_KEYS) {
            v = new javax.vecmath.Vector3f();
            this.vehicle.getForwardVector(v);
            v.normalize();
            v.scale(torque);
            this.vehicle.getRigidBody().applyTorque(v);
        }
        if (InputHandler.up(263) && InputHandler.up(262)) {
            this.gVehicleSteering = 0.0f;
        }
    }

    public void boost() {
        javax.vecmath.Vector3f force = new javax.vecmath.Vector3f(0.0f, 1.0f, 0.0f);
        force.scale(1000000.0f);
        this.vehicle.getRigidBody().applyCentralForce(force);
    }

    public javax.vecmath.Vector3f getUpVec() {
        javax.vecmath.Vector3f forward = new javax.vecmath.Vector3f();
        this.vehicle.getForwardVector(forward);
        forward.normalize();
        Transform t1 = new Transform();
        Transform t2 = new Transform();
        this.vehicle.getWheelTransformWS(0, t1);
        this.vehicle.getWheelTransformWS(1, t2);
        javax.vecmath.Vector3f side = new javax.vecmath.Vector3f(t1.origin.x - t2.origin.x, t1.origin.y - t2.origin.y, t1.origin.z - t2.origin.z);
        side.normalize();
        javax.vecmath.Vector3f up = new javax.vecmath.Vector3f();
        up.cross(forward, side);
        return up;
    }

    public javax.vecmath.Vector3f getForwardVec() {
        javax.vecmath.Vector3f vec = new javax.vecmath.Vector3f();
        this.vehicle.getForwardVector(vec);
        return vec;
    }

    public float getRotY() {
        Transform t1 = new Transform();
        Transform t2 = new Transform();
        this.vehicle.getWheelTransformWS(0, t1);
        this.vehicle.getWheelTransformWS(1, t2);
        javax.vecmath.Vector3f forward = this.getForwardVec();
        forward.normalize();
        if (forward.y > -1.0f) {
            return (float)(Math.atan2(t1.origin.z - t2.origin.z, t1.origin.x - t2.origin.x) + 1.5707963267948966);
        }
        return (float)(Math.PI + Math.atan2(t1.origin.z - t2.origin.z, t1.origin.x - t2.origin.x) + 1.5707963267948966);
    }

    @Override
    public void collidedWith(Entity entity) {
        double vol;
        if (entity instanceof VehicleEntity && System.currentTimeMillis() - this.lastTimeCrashPlayed > 2000L) {
            this.lastTimeCrashPlayed = System.currentTimeMillis();
            VehicleEntity ve = (VehicleEntity)entity;
            vol = Math.min(1.0, 0.01 * (Math.abs(ve.getCurrentSpeedKmHour()) + Math.abs(this.getCurrentSpeedKmHour())));
            this.sound.play(Sound.CRASH, vol);
        }
        if (entity instanceof DynamicEntity && System.currentTimeMillis() - this.lastTimeCrashPlayed > 2000L) {
            DynamicEntity de = (DynamicEntity)entity;
            if (de.textureID == Texture.getTexture("textures/trashCan.png") || de.textureID == Texture.getTexture("textures/postbox.png")) {
                this.lastTimeCrashPlayed = System.currentTimeMillis();
                vol = Math.min(1.0, 0.01 * Math.abs(this.getCurrentSpeedKmHour()));
                this.sound.play(Sound.OBJECT_CRASH, vol);
            }
        }
    }

    public void updateStats(long tick, MissionHandler missionHandler) {
        int num = missionHandler.getCustomersInCar() + 0;
        maxEngineForce = 1700.0f + (float)(num * 800);
        maxBackwardForce = -1700 - num * 800;
        maxBreakingForce = 200 + num * 50;
        this.body.setGravity(new javax.vecmath.Vector3f(0.0f, -10 + num * -4, 0.0f));
    }

    public void pickUpCustomer() {
        this.scaleTick = this.scaleTime;
    }

    private float getScale() {
        if (this.scaleTick < 0) {
            return 1.0f;
        }
        return (float)(1.0 + 0.4 * Math.sin(Math.PI * (double)this.scaleTick / (double)this.scaleTime));
    }

    @Override
    protected void renderChassi(MeshBatch meshBatch) {
        Transform trans = new Transform();
        this.body.getWorldTransform(trans);
        javax.vecmath.Matrix4f mat = new javax.vecmath.Matrix4f();
        trans.getMatrix(mat);
        mat.setScale(mat.getScale() * this.getScale());
        Matrix4f real = Matrix4f.identity();
        real.elements = new float[]{mat.m00, mat.m01, mat.m02, mat.m03, mat.m10, mat.m11, mat.m12, mat.m13, mat.m20, mat.m21, mat.m22, mat.m23, mat.m30, mat.m31, mat.m32, mat.m33};
        Matrix4f fix = Matrix4f.translate(new Vector3f(0.0f, 0.4f, 0.0f));
        real = real.multiply(fix);
        meshBatch.render(this.mesh, this.textureID, real);
    }
}

