/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.InputHandler;
import java.nio.ByteBuffer;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWvidmode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class Window {
    private long windowID;
    public static int width = 1200;
    public static int height = 800;
    private String title;
    private boolean vsync = true;
    private GLFWKeyCallback keyCallback;
    private GLFWErrorCallback errorCallback;

    public Window(String title) {
        this.title = title;
    }

    public Window(String title, int w, int h) {
        this.title = title;
        width = w;
        height = h;
    }

    public void init(int antiAliasing, boolean fullscreen) {
        this.init(false, 0, 0, antiAliasing, fullscreen);
    }

    public void init(int locationX, int locationY, int antiAliasing, boolean fullscreen) {
        this.init(true, locationX, locationY, antiAliasing, fullscreen);
    }

    private void init(boolean customLocation, int locationX, int locationY, int antiAliasing, boolean fullscreen) {
        try {
            if (GLFW.glfwInit() != 1) {
                System.err.println("GLFW initialization failed!");
            }
            GLFW.glfwWindowHint(135181, antiAliasing);
            this.windowID = GLFW.glfwCreateWindow(width, height, this.title, fullscreen ? GLFW.glfwGetPrimaryMonitor() : 0L, 0L);
            if (fullscreen) {
                GLFW.glfwSetInputMode(this.windowID, 208897, 212994);
            }
            if (this.windowID == 0L) {
                System.err.println("Could not create our Window!");
            }
            ByteBuffer vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
            if (customLocation) {
                GLFW.glfwSetWindowPos(this.windowID, locationX, locationY);
            } else {
                GLFW.glfwSetWindowPos(this.windowID, (GLFWvidmode.width(vidmode) - width) / 2, (GLFWvidmode.height(vidmode) - height) / 2);
            }
            GLFW.glfwMakeContextCurrent(this.windowID);
            GLFW.glfwShowWindow(this.windowID);
            GLContext.createFromCurrent();
            GL11.glClearColor(0.1254902f, 0.1254902f, 0.1254902f, 0.0f);
            GL11.glEnable(2929);
            GL11.glBlendFunc(770, 771);
            System.out.println("OpenGL: " + GL11.glGetString(7938));
            this.keyCallback = new InputHandler();
            GLFW.glfwSetKeyCallback(this.windowID, this.keyCallback);
            this.errorCallback = Callbacks.errorCallbackPrint(System.err);
            GLFW.glfwSetErrorCallback(this.errorCallback);
            GLFW.glfwSwapInterval(this.vsync ? 1 : 0);
        }
        catch (Exception e) {
            System.out.println("Can not create window");
        }
    }

    public long getWindowID() {
        return this.windowID;
    }

    public void destroy() {
        GLFW.glfwDestroyWindow(this.windowID);
        this.keyCallback.release();
        GLFW.glfwTerminate();
        this.errorCallback.release();
    }

    public void swapBuffers() {
        GLFW.glfwSwapBuffers(this.windowID);
    }

    public boolean shouldClose() {
        return GLFW.glfwWindowShouldClose(this.windowID) == 1;
    }

    public void setShouldClose(boolean shouldClose) {
        GLFW.glfwSetWindowShouldClose(this.windowID, shouldClose ? 1 : 0);
    }

    public void pollEvents() {
        GLFW.glfwPollEvents();
    }

    public float getAspect() {
        return (float)width / (float)height;
    }

    public float getWidth() {
        return width;
    }

    public float getHeight() {
        return height;
    }
}

