/*
 * Decompiled with CFR 0.152.
 */
package GLEngine;

import GLEngine.FBO;
import GLEngine.GLSLProgram;
import GLEngine.Matrix4f;
import GLEngine.Mesh;
import GLEngine.OBJLoader;
import GLEngine.Utilities;
import GLEngine.Vector3f;
import GLEngine.Window;
import game.Camera;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class MeshBatch {
    private Map<Mesh, VAO> vaoMap = new HashMap<Mesh, VAO>();
    private ArrayList<Model> renderList = new ArrayList();
    private GLSLProgram activeShader;
    private GLSLProgram shadowProgram;
    public FBO fbo;
    private Camera camera;
    private Window window;
    private FloatBuffer[] floatBuffersA = new FloatBuffer[2000];
    private FloatBuffer[] floatBuffersB = new FloatBuffer[2000];
    private FloatBuffer[] floatBuffersC = new FloatBuffer[2000];
    private FloatBuffer[] floatBuffersD = new FloatBuffer[2000];
    private FloatBuffer[] floatBuffersE = new FloatBuffer[2000];

    public void preAllocateVAO(Mesh mesh) {
        VAO vao = new VAO();
        vao.VAO = GL30.glGenVertexArrays();
        GL30.glBindVertexArray(vao.VAO);
        if (mesh.vertices.length == 0 || mesh.textureCoords.length == 0 || mesh.normalCoords.length == 0 || mesh.indices.length == 0) {
            System.out.println("ERROR!");
        }
        vao.VBO = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, vao.VBO);
        GL15.glBufferData(34962, Utilities.createFloatBuffer(mesh.vertices), 35044);
        GL20.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(0);
        vao.UVBO = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, vao.UVBO);
        GL15.glBufferData(34962, Utilities.createFloatBuffer(mesh.textureCoords), 35044);
        GL20.glVertexAttribPointer(1, 2, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(1);
        vao.NBO = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, vao.NBO);
        GL15.glBufferData(34962, Utilities.createFloatBuffer(mesh.normalCoords), 35044);
        GL20.glVertexAttribPointer(2, 3, 5126, false, 0, 0L);
        GL20.glEnableVertexAttribArray(2);
        vao.IBO = GL15.glGenBuffers();
        GL15.glBindBuffer(34963, vao.IBO);
        GL15.glBufferData(34963, Utilities.createIntBuffer(mesh.indices), 35044);
        GL30.glBindVertexArray(0);
        GL15.glBindBuffer(34962, 0);
        GL15.glBindBuffer(34963, 0);
        this.vaoMap.put(mesh, vao);
    }

    public void freeMeshVAO(Mesh mesh) {
        if (!this.vaoMap.containsKey(mesh)) {
            return;
        }
        VAO vao = this.vaoMap.get(mesh);
        GL15.glDeleteBuffers(vao.VBO);
        GL15.glDeleteBuffers(vao.UVBO);
        GL15.glDeleteBuffers(vao.NBO);
        GL15.glDeleteBuffers(vao.IBO);
        GL30.glDeleteVertexArrays(vao.VAO);
        this.shadowProgram.free();
    }

    public void init() {
        this.shadowProgram = new GLSLProgram("/shaders/shadowVert.vert", "/shaders/shadowFrag.frag");
        this.fbo = new FBO(4000, 4000);
    }

    public void begin(GLSLProgram shader, Camera camera, Window window) {
        this.renderList.clear();
        this.activeShader = shader;
        this.camera = camera;
        this.window = window;
    }

    public void render(Mesh mesh, int textureID, javax.vecmath.Matrix4f m) {
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.elements = new float[]{m.m00, m.m01, m.m02, m.m03, m.m10, m.m11, m.m12, m.m13, m.m20, m.m21, m.m22, m.m23, m.m30, m.m31, m.m32, m.m33};
        this.render(mesh, textureID, modelMatrix);
    }

    public void render(Mesh mesh, int textureID, javax.vecmath.Matrix4f m, Vector3f color) {
        Matrix4f modelMatrix = new Matrix4f();
        modelMatrix.elements = new float[]{m.m00, m.m01, m.m02, m.m03, m.m10, m.m11, m.m12, m.m13, m.m20, m.m21, m.m22, m.m23, m.m30, m.m31, m.m32, m.m33};
        this.render(mesh, textureID, modelMatrix, color);
    }

    public void render(Mesh mesh, int textureID, Matrix4f modelMatrix, Vector3f color) {
        if (!this.vaoMap.containsKey(mesh)) {
            this.preAllocateVAO(mesh);
        }
        Model m = new Model();
        m.mesh = mesh;
        m.textureID = textureID;
        m.modelMatrix = modelMatrix;
        m.material = mesh.material;
        m.color = color;
        this.renderList.add(m);
    }

    public void render(Mesh mesh, int textureID, Matrix4f modelMatrix) {
        if (!this.vaoMap.containsKey(mesh)) {
            this.preAllocateVAO(mesh);
        }
        Model m = new Model();
        m.mesh = mesh;
        m.textureID = textureID;
        m.modelMatrix = modelMatrix;
        m.material = mesh.material;
        m.color = new Vector3f(1.0f, 1.0f, 1.0f);
        this.renderList.add(m);
    }

    public MeshBatch() {
        this.allocateFloatBuffers();
    }

    private void allocateFloatBuffers() {
        int i = 0;
        while (i < this.floatBuffersA.length) {
            this.floatBuffersA[i] = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ++i;
        }
        i = 0;
        while (i < this.floatBuffersB.length) {
            this.floatBuffersB[i] = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ++i;
        }
        i = 0;
        while (i < this.floatBuffersC.length) {
            this.floatBuffersC[i] = ByteBuffer.allocateDirect(12).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ++i;
        }
        i = 0;
        while (i < this.floatBuffersD.length) {
            this.floatBuffersD[i] = ByteBuffer.allocateDirect(64).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ++i;
        }
        i = 0;
        while (i < this.floatBuffersE.length) {
            this.floatBuffersE[i] = ByteBuffer.allocateDirect(16).order(ByteOrder.nativeOrder()).asFloatBuffer();
            ++i;
        }
    }

    private void renderMeshBatch() {
        while (this.renderList.size() >= this.floatBuffersA.length) {
            this.floatBuffersA = new FloatBuffer[this.floatBuffersA.length * 2];
            this.floatBuffersB = new FloatBuffer[this.floatBuffersB.length * 2];
            this.floatBuffersC = new FloatBuffer[this.floatBuffersC.length * 2];
            this.floatBuffersD = new FloatBuffer[this.floatBuffersD.length * 2];
            this.floatBuffersE = new FloatBuffer[this.floatBuffersD.length * 2];
            this.allocateFloatBuffers();
        }
        int i = 0;
        GL30.glBindFramebuffer(36160, this.fbo.fbo);
        GL11.glViewport(0, 0, this.fbo.width, this.fbo.height);
        GL11.glClear(16640);
        this.shadowProgram.enable();
        Vector3f lightInvDir = new Vector3f(-0.2f, 1.0f, 0.2f);
        Vector3f tp = this.camera.target.subtract(this.camera.pos);
        float dot = tp.x / (float)Math.sqrt(tp.x * tp.x + tp.y * tp.y);
        dot = 1.0f - Math.abs(dot);
        Matrix4f depthProjectionMatrix = Matrix4f.orthoProjection(100.0f, -100.0f, 100.0f, -100.0f, -100.0f, 100.0f);
        Vector3f c = this.camera.target;
        Matrix4f depthViewMatrix = Matrix4f.lookAt(c.add(lightInvDir), c, new Vector3f(1.0f, 0.0f, 0.0f));
        i = 0;
        for (Model model : this.renderList) {
            Matrix4f depthModelMatrix = model.modelMatrix;
            Matrix4f depthMVP = depthProjectionMatrix.multiply(depthViewMatrix).multiply(depthModelMatrix);
            int m = this.shadowProgram.getUniform("depthMVP");
            this.floatBuffersA[++i].put(depthMVP.elements).flip();
            GL20.glUniformMatrix4fv(m, true, this.floatBuffersA[i]);
            VAO vao = this.vaoMap.get(model.mesh);
            GL30.glBindVertexArray(vao.VAO);
            GL11.glDrawElements(4, model.mesh.indices.length, 5125, 0L);
        }
        GL30.glBindVertexArray(0);
        this.shadowProgram.disable();
        GL30.glBindFramebuffer(36160, 0);
        GL11.glViewport(0, 0, (int)this.window.getWidth(), (int)this.window.getHeight());
        GL11.glClear(16640);
        this.activeShader.enable();
        int pv = this.activeShader.getUniform("PV");
        GL20.glUniformMatrix4fv(pv, true, this.getProjectionViewMatrix().toFloatBuffer());
        int cam = this.activeShader.getUniform("camPos");
        GL20.glUniform3f(cam, this.camera.pos.x, this.camera.pos.y, this.camera.pos.z);
        int tid = this.activeShader.getUniform("texSampler");
        int sid = this.activeShader.getUniform("shadowMap");
        int spid = this.activeShader.getUniform("specularColor");
        int m = this.activeShader.getUniform("M");
        int did = this.activeShader.getUniform("DepthBiasMVP");
        int cid = this.activeShader.getUniform("color");
        i = 0;
        int currentTexture = -1;
        GL13.glActiveTexture(33985);
        GL11.glBindTexture(3553, this.fbo.shadowmap);
        GL20.glUniform1i(sid, 1);
        GL13.glActiveTexture(33984);
        for (Model model : this.renderList) {
            ++i;
            if (currentTexture != model.textureID) {
                GL11.glBindTexture(3553, model.textureID);
                GL20.glUniform1i(tid, 0);
                currentTexture = model.textureID;
            }
            this.floatBuffersB[i].put(model.modelMatrix.elements).flip();
            GL20.glUniformMatrix4fv(m, true, this.floatBuffersB[i]);
            float[] fb = new float[]{model.material.specular.x, model.material.specular.y, model.material.specular.z};
            this.floatBuffersC[i].put(fb).flip();
            GL20.glUniform3fv(spid, this.floatBuffersC[i]);
            Matrix4f depthModelMatrix = model.modelMatrix;
            Matrix4f depthMVP = Matrix4f.bias().multiply(depthProjectionMatrix).multiply(depthViewMatrix).multiply(depthModelMatrix);
            this.floatBuffersD[i].put(depthMVP.elements).flip();
            GL20.glUniformMatrix4fv(did, true, this.floatBuffersD[i]);
            float[] col = new float[]{model.color.x, model.color.y, model.color.z, 1.0f};
            this.floatBuffersE[i].put(col).flip();
            GL20.glUniform4fv(cid, this.floatBuffersE[i]);
            VAO vao = this.vaoMap.get(model.mesh);
            GL30.glBindVertexArray(vao.VAO);
            GL11.glDrawElements(4, model.mesh.indices.length, 5125, 0L);
        }
        GL30.glBindVertexArray(0);
        GL11.glBindTexture(3553, 0);
        this.activeShader.disable();
    }

    public void end() {
        Collections.sort(this.renderList);
        this.renderMeshBatch();
    }

    public Matrix4f getProjectionViewMatrix() {
        Matrix4f proj = Matrix4f.perspective(90.0f, this.window.getAspect(), 1.0f, 10000.0f);
        return proj.multiply(this.camera.getViewMatrix());
    }

    private void initPerspective() {
        this.activeShader.enable();
        int pv = this.activeShader.getUniform("PV");
        GL20.glUniformMatrix4fv(pv, true, this.getProjectionViewMatrix().toFloatBuffer());
        int cam = this.activeShader.getUniform("camPos");
        GL20.glUniform3f(cam, this.camera.pos.x, this.camera.pos.y, this.camera.pos.z);
    }

    public void free() {
        Iterator<Map.Entry<Mesh, VAO>> it = this.vaoMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Mesh, VAO> pair = it.next();
            Mesh mesh = pair.getKey();
            this.freeMeshVAO(mesh);
            it.remove();
        }
        this.fbo.free();
    }

    private class Model
    implements Comparable<Model> {
        public Mesh mesh;
        public int textureID;
        public Matrix4f modelMatrix;
        public OBJLoader.Material material;
        public Vector3f color;

        private Model() {
        }

        @Override
        public int compareTo(Model r) {
            if (this.textureID < r.textureID) {
                return -1;
            }
            if (this.textureID > r.textureID) {
                return 1;
            }
            return 0;
        }
    }

    public class VAO {
        public int VAO;
        public int VBO;
        public int IBO;
        public int UVBO;
        public int NBO;
    }
}

