/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XkbNamesRec;

public final class XkbDescRec
implements Pointer {
    public static final int SIZEOF;
    public static final int DPY;
    public static final int DEVICE_SPEC;
    public static final int MIN_KEY_CODE;
    public static final int MAX_KEY_CODE;
    public static final int NAMES;
    private final ByteBuffer struct;

    public XkbDescRec() {
        this(XkbDescRec.malloc());
    }

    public XkbDescRec(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setDpy(long dpy) {
        XkbDescRec.dpy(this.struct, dpy);
    }

    public void setDeviceSpec(int device_spec) {
        XkbDescRec.device_spec(this.struct, device_spec);
    }

    public void setMinKeyCode(int min_key_code) {
        XkbDescRec.min_key_code(this.struct, min_key_code);
    }

    public void setMaxKeyCode(int max_key_code) {
        XkbDescRec.max_key_code(this.struct, max_key_code);
    }

    public void setNames(long names) {
        XkbDescRec.names(this.struct, names);
    }

    public void setNames(ByteBuffer names) {
        XkbDescRec.names(this.struct, names);
    }

    public long getDpy() {
        return XkbDescRec.dpy(this.struct);
    }

    public int getDeviceSpec() {
        return XkbDescRec.device_spec(this.struct);
    }

    public int getMinKeyCode() {
        return XkbDescRec.min_key_code(this.struct);
    }

    public int getMaxKeyCode() {
        return XkbDescRec.max_key_code(this.struct);
    }

    public long getNames() {
        return XkbDescRec.names(this.struct);
    }

    public ByteBuffer getNamesBuffer() {
        return XkbDescRec.namesBuffer(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long dpy, int device_spec, int min_key_code, int max_key_code, ByteBuffer names) {
        ByteBuffer xkbdescrec = XkbDescRec.malloc();
        XkbDescRec.dpy(xkbdescrec, dpy);
        XkbDescRec.device_spec(xkbdescrec, device_spec);
        XkbDescRec.min_key_code(xkbdescrec, min_key_code);
        XkbDescRec.max_key_code(xkbdescrec, max_key_code);
        XkbDescRec.names(xkbdescrec, names);
        return xkbdescrec;
    }

    public static void dpy(ByteBuffer xkbdescrec, long dpy) {
        PointerBuffer.put(xkbdescrec, xkbdescrec.position() + DPY, dpy);
    }

    public static void device_spec(ByteBuffer xkbdescrec, int device_spec) {
        xkbdescrec.putShort(xkbdescrec.position() + DEVICE_SPEC, (short)device_spec);
    }

    public static void min_key_code(ByteBuffer xkbdescrec, int min_key_code) {
        xkbdescrec.put(xkbdescrec.position() + MIN_KEY_CODE, (byte)min_key_code);
    }

    public static void max_key_code(ByteBuffer xkbdescrec, int max_key_code) {
        xkbdescrec.put(xkbdescrec.position() + MAX_KEY_CODE, (byte)max_key_code);
    }

    public static void names(ByteBuffer xkbdescrec, long names) {
        PointerBuffer.put(xkbdescrec, xkbdescrec.position() + NAMES, names);
    }

    public static void names(ByteBuffer xkbdescrec, ByteBuffer names) {
        XkbDescRec.names(xkbdescrec, MemoryUtil.memAddressSafe(names));
    }

    public static long dpy(ByteBuffer xkbdescrec) {
        return PointerBuffer.get(xkbdescrec, xkbdescrec.position() + DPY);
    }

    public static int device_spec(ByteBuffer xkbdescrec) {
        return xkbdescrec.getShort(xkbdescrec.position() + DEVICE_SPEC) & 0xFFFF;
    }

    public static int min_key_code(ByteBuffer xkbdescrec) {
        return xkbdescrec.get(xkbdescrec.position() + MIN_KEY_CODE) & 0xFF;
    }

    public static int max_key_code(ByteBuffer xkbdescrec) {
        return xkbdescrec.get(xkbdescrec.position() + MAX_KEY_CODE) & 0xFF;
    }

    public static long names(ByteBuffer xkbdescrec) {
        return PointerBuffer.get(xkbdescrec, xkbdescrec.position() + NAMES);
    }

    public static ByteBuffer namesBuffer(ByteBuffer xkbdescrec) {
        return MemoryUtil.memByteBuffer(XkbDescRec.names(xkbdescrec), XkbNamesRec.SIZEOF);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(5);
        SIZEOF = XkbDescRec.offsets(MemoryUtil.memAddress(offsets));
        DPY = offsets.get(0);
        DEVICE_SPEC = offsets.get(1);
        MIN_KEY_CODE = offsets.get(2);
        MAX_KEY_CODE = offsets.get(3);
        NAMES = offsets.get(4);
    }
}

