/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.BufferUtils;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MathUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.PointerWrapper;

public class APIBuffer {
    private static final int DEFAULT_CAPACITY = 1024;
    private ByteBuffer buffer;
    private long address;
    private int offset;
    private int stackDepth;
    private int[] stack = new int[4];

    public APIBuffer() {
        this.buffer = BufferUtils.createAlignedByteBufferPage(1024);
        this.address = MemoryUtil.memAddress(this.buffer);
    }

    public APIBuffer reset() {
        this.offset = 0;
        return this;
    }

    public APIBuffer push() {
        if (this.stackDepth == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stack.length << 1);
        }
        this.stack[this.stackDepth++] = this.offset;
        this.offset = this.offset + (Pointer.POINTER_SIZE - 1) & -Pointer.POINTER_SIZE;
        return this;
    }

    public APIBuffer pop() {
        this.offset = this.stack[--this.stackDepth];
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long address() {
        return this.address;
    }

    public long address(int offset) {
        return this.address + (long)offset;
    }

    public long addressSafe(Object value, int offset) {
        return value == null ? 0L : this.address(offset);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    private void ensureCapacity(int capacity) {
        if (capacity <= this.buffer.capacity()) {
            return;
        }
        ByteBuffer resized = BufferUtils.createAlignedByteBufferPage(MathUtil.mathRoundPoT(capacity));
        resized.put(this.buffer);
        resized.clear();
        this.buffer = resized;
        this.address = MemoryUtil.memAddress(resized);
    }

    private int param(int bytes) {
        return this.param(bytes, bytes);
    }

    private int param(int bytes, int alignment) {
        int param = this.offset + (alignment - 1) & -alignment;
        this.offset = param + bytes;
        this.ensureCapacity(this.offset);
        return param;
    }

    public int booleanParam() {
        return this.param(1);
    }

    public int byteParam() {
        return this.param(1);
    }

    public int shortParam() {
        return this.param(2);
    }

    public int intParam() {
        return this.param(4);
    }

    public int longParam() {
        return this.param(8);
    }

    public int floatParam() {
        return this.param(4);
    }

    public int doubleParam() {
        return this.param(8);
    }

    public int pointerParam() {
        return this.param(Pointer.POINTER_SIZE);
    }

    public int bufferParam(int size) {
        return this.param(size, Pointer.POINTER_SIZE);
    }

    public int booleanParam(boolean value) {
        int offset = this.booleanParam();
        this.buffer.put(offset, value ? (byte)1 : 0);
        return offset;
    }

    public int byteParam(byte value) {
        int offset = this.byteParam();
        this.buffer.put(offset, value);
        return offset;
    }

    public int shortParam(short value) {
        int offset = this.shortParam();
        this.buffer.putShort(offset, value);
        return offset;
    }

    public int intParam(int value) {
        int offset = this.intParam();
        this.buffer.putInt(offset, value);
        return offset;
    }

    public int longParam(long value) {
        int offset = this.longParam();
        this.buffer.putLong(offset, value);
        return offset;
    }

    public int floatParam(float value) {
        int offset = this.floatParam();
        this.buffer.putFloat(offset, value);
        return offset;
    }

    public int doubleParam(double value) {
        int offset = this.doubleParam();
        this.buffer.putDouble(offset, value);
        return offset;
    }

    public int pointerParam(long value) {
        int offset = this.pointerParam();
        PointerBuffer.put(this.buffer, offset, value);
        return offset;
    }

    public int pointerParam(PointerWrapper value) {
        return this.pointerParam(value.getPointer());
    }

    public void intParam(int offset, int index, int value) {
        this.buffer.putInt(offset + (index << 2), value);
    }

    public void pointerParam(int offset, int index, long value) {
        PointerBuffer.put(this.buffer, offset + (index << Pointer.POINTER_SHIFT), value);
    }

    public int stringParamASCII(CharSequence value, boolean nullTerminated) {
        if (value == null) {
            return -1;
        }
        int offset = this.bufferParam(value.length() + (nullTerminated ? 1 : 0));
        MemoryUtil.memEncodeASCII(value, nullTerminated, this.buffer, offset);
        return offset;
    }

    public int stringParamUTF8(CharSequence value, boolean nullTerminated) {
        if (value == null) {
            return -1;
        }
        int encodedLen = MemoryUtil.memEncodedLengthUTF8(value);
        int offset = this.bufferParam(encodedLen + (nullTerminated ? 1 : 0));
        MemoryUtil.memEncodeUTF8(value, nullTerminated, this.buffer, offset);
        return offset;
    }

    public int stringParamUTF16(CharSequence value, boolean nullTerminated) {
        if (value == null) {
            return -1;
        }
        int offset = this.bufferParam(value.length() + (nullTerminated ? 1 : 0) << 1);
        MemoryUtil.memEncodeUTF16(value, nullTerminated, this.buffer, offset);
        return offset;
    }

    public boolean booleanValue(int offset) {
        return this.buffer.get(offset) != 0;
    }

    public byte byteValue(int offset) {
        return this.buffer.get(offset);
    }

    public short shortValue(int offset) {
        return this.buffer.getShort(offset);
    }

    public int intValue(int offset) {
        return this.buffer.getInt(offset);
    }

    public long longValue(int offset) {
        return this.buffer.getLong(offset);
    }

    public float floatValue(int offset) {
        return this.buffer.getFloat(offset);
    }

    public double doubleValue(int offset) {
        return this.buffer.getDouble(offset);
    }

    public long pointerValue(int offset) {
        return PointerBuffer.get(this.buffer, offset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValueASCII(int offset, int limit) {
        this.buffer.position(offset);
        this.buffer.limit(limit);
        try {
            String string = MemoryUtil.memDecodeASCII(this.buffer);
            return string;
        }
        finally {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValueUTF8(int offset, int limit) {
        this.buffer.position(offset);
        this.buffer.limit(limit);
        try {
            String string = MemoryUtil.memDecodeUTF8(this.buffer);
            return string;
        }
        finally {
            this.buffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stringValueUTF16(int offset, int limit) {
        this.buffer.position(offset);
        this.buffer.limit(limit);
        try {
            String string = MemoryUtil.memDecodeUTF16(this.buffer);
            return string;
        }
        finally {
            this.buffer.clear();
        }
    }
}

