/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GL12 {
    public static final int GL_ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int GL_ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int GL_SMOOTH_POINT_SIZE_RANGE = 2834;
    public static final int GL_SMOOTH_POINT_SIZE_GRANULARITY = 2835;
    public static final int GL_SMOOTH_LINE_WIDTH_RANGE = 2850;
    public static final int GL_SMOOTH_LINE_WIDTH_GRANULARITY = 2851;
    public static final int GL_PACK_SKIP_IMAGES = 32875;
    public static final int GL_PACK_IMAGE_HEIGHT = 32876;
    public static final int GL_UNPACK_SKIP_IMAGES = 32877;
    public static final int GL_UNPACK_IMAGE_HEIGHT = 32878;
    public static final int GL_TEXTURE_3D = 32879;
    public static final int GL_PROXY_TEXTURE_3D = 32880;
    public static final int GL_TEXTURE_DEPTH = 32881;
    public static final int GL_TEXTURE_WRAP_R = 32882;
    public static final int GL_MAX_3D_TEXTURE_SIZE = 32883;
    public static final int GL_BGR = 32992;
    public static final int GL_BGRA = 32993;
    public static final int GL_UNSIGNED_BYTE_3_3_2 = 32818;
    public static final int GL_UNSIGNED_BYTE_2_3_3_REV = 33634;
    public static final int GL_UNSIGNED_SHORT_5_6_5 = 33635;
    public static final int GL_UNSIGNED_SHORT_5_6_5_REV = 33636;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4 = 32819;
    public static final int GL_UNSIGNED_SHORT_4_4_4_4_REV = 33637;
    public static final int GL_UNSIGNED_SHORT_5_5_5_1 = 32820;
    public static final int GL_UNSIGNED_SHORT_1_5_5_5_REV = 33638;
    public static final int GL_UNSIGNED_INT_8_8_8_8 = 32821;
    public static final int GL_UNSIGNED_INT_8_8_8_8_REV = 33639;
    public static final int GL_UNSIGNED_INT_10_10_10_2 = 32822;
    public static final int GL_UNSIGNED_INT_2_10_10_10_REV = 33640;
    public static final int GL_RESCALE_NORMAL = 32826;
    public static final int GL_LIGHT_MODEL_COLOR_CONTROL = 33272;
    public static final int GL_SINGLE_COLOR = 33273;
    public static final int GL_SEPARATE_SPECULAR_COLOR = 33274;
    public static final int GL_CLAMP_TO_EDGE = 33071;
    public static final int GL_TEXTURE_MIN_LOD = 33082;
    public static final int GL_TEXTURE_MAX_LOD = 33083;
    public static final int GL_TEXTURE_BASE_LEVEL = 33084;
    public static final int GL_TEXTURE_MAX_LEVEL = 33085;
    public static final int GL_MAX_ELEMENTS_VERTICES = 33000;
    public static final int GL_MAX_ELEMENTS_INDICES = 33001;
    public final long TexImage3D;
    public final long TexSubImage3D;
    public final long CopyTexSubImage3D;
    public final long DrawRangeElements;

    public GL12(FunctionProvider provider) {
        this.TexImage3D = provider.getFunctionAddress("glTexImage3D");
        this.TexSubImage3D = provider.getFunctionAddress("glTexSubImage3D");
        this.CopyTexSubImage3D = provider.getFunctionAddress("glCopyTexSubImage3D");
        this.DrawRangeElements = provider.getFunctionAddress("glDrawRangeElements");
    }

    public static GL12 getInstance() {
        return GL.getCapabilities().__GL12;
    }

    static GL12 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL12")) {
            return null;
        }
        GL12 funcs = new GL12(provider);
        boolean supported = Checks.checkFunctions(funcs.TexImage3D, funcs.TexSubImage3D, funcs.CopyTexSubImage3D, funcs.DrawRangeElements);
        return GL.checkExtension("OpenGL12", funcs, supported);
    }

    public static native void nglTexImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9, long var11);

    public static void nglTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixels) {
        long __functionAddress = GL12.getInstance().TexImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL12.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixels, __functionAddress);
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL12.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, pixelsOffset);
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static void glTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexImage3D(target, level, internalformat, width, height, depth, border, format, type, MemoryUtil.memAddressSafe(pixels));
    }

    public static native void nglTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, long var10, long var12);

    public static void nglTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixels) {
        long __functionAddress = GL12.getInstance().TexSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels, __functionAddress);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, true);
        }
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixelsOffset);
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35055, false);
        }
        GL12.nglTexSubImage3D(target, level, xoffset, yoffset, zoffset, width, height, depth, format, type, MemoryUtil.memAddress(pixels));
    }

    public static native void nglCopyTexSubImage3D(int var0, int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, long var9);

    public static void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        long __functionAddress = GL12.getInstance().CopyTexSubImage3D;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL12.nglCopyTexSubImage3D(target, level, xoffset, yoffset, zoffset, x, y, width, height, __functionAddress);
    }

    public static native void nglDrawRangeElements(int var0, int var1, int var2, int var3, int var4, long var5, long var7);

    public static void nglDrawRangeElements(int mode, int start, int end, int count, int type, long indices) {
        long __functionAddress = GL12.getInstance().DrawRangeElements;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL12.nglDrawRangeElements(mode, start, end, count, type, indices, __functionAddress);
    }

    public static void glDrawRangeElements(int mode, int start, int end, int count, int type, ByteBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count / GLChecks.typeToBytes(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        GL12.nglDrawRangeElements(mode, start, end, count, type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, int count, int type, long indicesOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL12.nglDrawRangeElements(mode, start, end, count, type, indicesOffset);
    }

    public static void glDrawRangeElements(int mode, int start, int end, int type, ByteBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL12.nglDrawRangeElements(mode, start, end, indices.remaining() * GLChecks.typeToBytes(type), type, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, ByteBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL12.nglDrawRangeElements(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, ShortBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL12.nglDrawRangeElements(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices));
    }

    public static void glDrawRangeElements(int mode, int start, int end, IntBuffer indices) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL12.nglDrawRangeElements(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices));
    }
}

