/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class CLBufferRegion
implements Pointer {
    public static final int SIZEOF;
    public static final int ORIGIN;
    public static final int SIZE;
    private final ByteBuffer struct;

    public CLBufferRegion() {
        this(CLBufferRegion.malloc());
    }

    public CLBufferRegion(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setOrigin(long origin) {
        CLBufferRegion.origin(this.struct, origin);
    }

    public void setSize(long size) {
        CLBufferRegion.size(this.struct, size);
    }

    public long getOrigin() {
        return CLBufferRegion.origin(this.struct);
    }

    public long getSize() {
        return CLBufferRegion.size(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long origin, long size) {
        ByteBuffer cl_buffer_region = CLBufferRegion.malloc();
        CLBufferRegion.origin(cl_buffer_region, origin);
        CLBufferRegion.size(cl_buffer_region, size);
        return cl_buffer_region;
    }

    public static void origin(ByteBuffer cl_buffer_region, long origin) {
        PointerBuffer.put(cl_buffer_region, cl_buffer_region.position() + ORIGIN, origin);
    }

    public static void size(ByteBuffer cl_buffer_region, long size) {
        PointerBuffer.put(cl_buffer_region, cl_buffer_region.position() + SIZE, size);
    }

    public static long origin(ByteBuffer cl_buffer_region) {
        return PointerBuffer.get(cl_buffer_region, cl_buffer_region.position() + ORIGIN);
    }

    public static long size(ByteBuffer cl_buffer_region) {
        return PointerBuffer.get(cl_buffer_region, cl_buffer_region.position() + SIZE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = CLBufferRegion.offsets(MemoryUtil.memAddress(offsets));
        ORIGIN = offsets.get(0);
        SIZE = offsets.get(1);
    }
}

