; Intro program "Fractal Trees" by uav1606. 2015 year.

.186
.model tiny
.code

	org 100h
start:

	jmp begin

; ___---___---___ Data ___---___---___

X		dw 00h ; current x coordinate
Y		dw 00h ; current y coordinate
Color		db 00h ; color

Buf1Addr	dw ? ; first buffer segment
Buf2Addr	dw ? ; second buffer segment

Seed		dw ? ; random number

CurAngle	dw 270 ; current angle

AngleStep	dw 30 ; step of angle inc/dec

MainCounter	dw 0  ; counter in render proc


BaseStep	dw 4  ; base line length

SequenceSize 	dw ?  ; size of current L-sequence

CurSequenceAddr dw ?  ; address of current L-sequence

; offsets of axioms 1-4
axiomTableAddr	dw offset axiom1
		dw offset axiom2
		dw offset axiom3
		dw offset axiom4
		dw offset axiom5

; sizes of axioms 1-4
axiomSizeTable	db 20
		db 18
		db 16
		db 18
		db 16
	

; Axioms
axiom1 		db "FF-[-F+F+F]+[+F-F-F]"

axiom2 		db "FF[-F+F+F][+F-F-F]"

axiom3 		db "FF-[-F+F]+[+F-F]"

axiom4 		db "F[-F][+F]F[-F][+F]"

axiom5 		db "FF[F+F+F][F-F-F]"

CosTable db 4, 4, 3, 2, 0, -2, -3, -4, -4, -4, -3, -2,  0,  2,  3,  4, 4 ; cosinus table
SinTable db 0, 2, 3, 4, 4,  4,  3,  2,  0, -2, -3, -4, -4, -4, -3, -2, 0 ; sinus table


; ---+++---+++---+++ Procedures ---+++---+++---+++
;--------------------------------------------------

; ............Draw line..........
F proc near
	mov ax, CurAngle
	mov cx, BaseStep
	call putline
	ret
F endp
;.................................


;############# Angle+ #############
plus  proc near
	mov ax, AngleStep
	add CurAngle, ax
	cmp CurAngle, 360
	jng EndPlus
	sub CurAngle, 360
EndPlus:
	ret
plus endp
;#################################


;############# Angle- #############
minus  proc near
	mov ax, AngleStep
	sub CurAngle, ax
	cmp CurAngle, 0
	jnl EndMinus
	add CurAngle, 360
EndMinus:
	ret
minus endp
;##################################


; ++++++++++++++++++ Random initialization of variables+++++++++++++++
init proc near

	mov ah,2ch ; system time
	int 21h
	mov seed, dx
	
	call Rnd ; random generator
	
	xor dx,dx
	mov ax, seed
	mov bx, 15
	div bx
	inc dx
	mov Color, dl ; color
	
	xor dx,dx
	mov ax, seed
	mov bx, 80
	div bx
	mov y, 350
	add y, dx ; start y coordinate
	
	xor dx,dx
	mov ax, seed
	mov bx, 20
	div bx
	add dx, 15
	mov AngleStep, dx  ; angle inc/dec step
	
	xor dx,dx
	mov ax, seed
	mov bx, 5
	div bx
	add dx,1
	mov BaseStep, dx ; line length
	
	ret
init endp
; ++++++++++++++++++ Random variables initialization end +++++++++++++++


;*******************************************************************
;* Replacement proc. cx - length, ds:si - buffer1, es:di - buffer2 *
;*******************************************************************
PChange proc near
change:
	cmp byte ptr [si],'F'
	jne copy
	push cx
	push si
	cld
	mov cx,SequenceSize
	mov si, CurSequenceAddr
	rep movsb 
	pop si
	pop cx
	jmp EndChange
copy:
	mov al, [si]
	mov es:[di],al

	inc di
EndChange:
	inc si
	loop change
	ret
PChange endp
;********************************************************



;--------------- Rendering proc-----------------------
Render proc near

	mov ax, Buf1Addr
	mov es, ax
	mov di, 0
	shl bx,1
	mov si, axiomTableAddr[bx]
	mov CurSequenceAddr, si
	
	call PChange
	
	mov SequenceSize, di
	
	
	
	mov cx, SequenceSize
	
	mov ax, Buf2Addr
	mov es, ax
	
	mov di, 0
	mov si, 0
	
	push ds
	mov ax, Buf1Addr
	mov ds, ax
	
	mov CurSequenceAddr, 0
	
	
	call PChange
	
	pop ds
	
	mov SequenceSize, di
		
	
	
	mov ax, Buf2Addr
	mov es, ax
	
	
	mov di, 0
	mov cx, SequenceSize
	
	
	
	
renderLoop:
	mov MainCounter, cx
	cmp byte ptr es:[di], 'F'
	jne NextSym1
	call F
	jmp EndSym
NextSym1:
	cmp byte ptr es:[di], '['
	jne NextSym2
	push CurAngle
	push x
	push y
	jmp EndSym
NextSym2:
	cmp byte ptr es:[di], ']'
	jne NextSym3
	pop y
	pop x
	pop CurAngle
	jmp EndSym
NextSym3:
	cmp byte ptr es:[di], '+'
	jne NextSym4
	call plus
	jmp EndSym
NextSym4:
	cmp byte ptr es:[di], '-'
	jne EndSym
	call minus
EndSym:
	inc di
	mov cx, MainCounter
	loop renderLoop
	
	ret

Render endp
;------------- Rendering end ----------------



;************* Delay ************
delay proc
	push ax
	push cx
	push dx
	push si
	push di
	mov ah,0
	int 1ah
	mov si,cx
	mov di,dx
pm1:    mov ah,0
	int 1ah
	sub dx,di
	sbb cx,si
	cmp dx,bx
	jnz pm1 
	pop di
	pop si
	pop dx
	pop cx
	pop ax
	ret
delay endp
;*******************************


;========= Cosinus calculating (very approximate :-)==============
cos proc near
	push bx
	push dx
	xor dx,dx
	mov bx,22
	div bx
	mov bx,ax
	mov al, CosTable[bx]
	pop dx
	pop bx
	ret
cos endp
;==================================================================


;||||||||||||| Sinus calculating (very approximate :-)||||||||||||
sin proc near
	push bx
	push dx
	xor dx,dx
	mov bx,22
	div bx
	mov bx,ax
	mov al, SinTable[bx]
	pop dx
	pop bx
	ret
sin endp
;|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||


;*****	random number generator *****
Rnd proc 
	push dx 
	mov ax,Seed 
	add ax,7 
	mov dx,13 
	mul dx 
	mov Seed,ax 
	pop dx 
	ret 
Rnd endp 
;************************************


; ----------------- Put Pixel proc. X,Y and Color (0-15) -------------------
putpixel   proc NEAR
	push ax
	push bx
	push cx
	push dx
	push es

	cmp  x,639
	jg endPutPixel
	cmp  x,0
	jl endPutPixel
	cmp  y,479
	jg endPutPixel
	cmp  y,0
	jl endPutPixel

	mov  ax,0A000h
	mov  es,ax

	mov  ax,cs:Y                 ; calculate offset
	mov  dx,80                   ;
	mul  dx                      ; ax = y * 80
	mov  bx,cs:X                    ;
	mov  cl,bl                   ; save low byte ptr for below
	shr  bx,03                   ; div by 8
	add  bx,ax                   ; bx = offset this group of 8 pixels

	mov  dx,03CEh                ; set to video hardware controller

	and  cl,07h                  ; Compute bit mask from X-coordinates
	xor  cl,07h                  ;  and put in ah
	mov  ah,01h                  ;
	shl  ah,cl                   ;
	mov  al,08h                  ; bit mask register
	out  dx,ax                   ;

	mov  ax,0205h                ; read mode 0, write mode 2
	out  dx,ax                   ;
           
	mov  al,es:[bx]              ; load to latch register
	mov  al,cs:Color
	mov  es:[bx],al              ; write to register

EndPutPixel:

	pop es
	pop dx
	pop cx
	pop bx
	pop ax

	ret
putpixel   endp
;------------------- end of PutPixel -------------------------------------------



;_-_-_-_-_-_-_-_-_-_-_- Drawing line proc _-_-_-_-_-_-_-_-_-_-_-

putline proc near ;cx - length, ax - angle



	push ax
	call cos
	mov bx,ax
	pop ax
	call sin
	mov dx,ax




LineLoop2:
		push bx
		push dx

	LoopXY:
		cmp bl,0
		je skip2Y
		cmp bl,0
		jl negXstep
		inc  x
		dec bl
		jmp skip2Y
	negXstep:
		dec  x
		add bl,1
	skip2Y:
		cmp dl,0
		je EndLine2
		cmp dl,0
		jl negYstep
		inc  y
		dec dl
		jmp EndLine2
	negYstep:
		dec  y
		add dl,1
	EndLine2:
		call putpixel
		cmp bl,0
		je DLCheck
		jmp LoopXY
	DLCheck:
		cmp dl,0
		jne skip2Y
		
		pop dx
		pop bx
	loop LineLoop2

	ret
putline endp

;_-_-_-_-_-_-_-_-_-_-_- end of drawing line proc _-_-_-_-_-_-_-_-_-_-_-





;--------------------------------------------------------------------
;**************** Beginning of the program **************************
;--------------------------------------------------------------------


begin:
	
; ____________ memory allocation____________

	push ds
	mov ah,4ah 
	mov bx, 1000h
	int 21h
	
	mov ah, 48h
	mov bx, 100
	int 21h
	
	mov Buf1Addr, ax
	
	mov ah, 48h
	mov bx, 1000
	int 21h
	
	mov Buf2Addr, ax
	
	pop ds

;____________________________________________

	mov  ax,0012h                ; 640x480x16
	int  10h

beginDraw:

; Clear screen
	mov dx, 3ceh
	mov ax, 0ff08h
	out dx, ax


	mov ax, 0a000h          
	mov es, ax             

	xor di, di             
	xor ax,ax            
	mov cx, 32000           
	rep stosw

	call init ; random initialization of variables

; Select the number (2-6) of trees (random)

 
	xor dx,dx
	mov ax, seed
	mov bx, 6
	div bx
	inc dx
	inc dx
	mov cx,dx
	mov x, 100

mainloop:
	push cx

	call init ; random initialization of variables

	xor dx,dx ;select x (less or more random)
	mov ax, seed
	mov bx, 40
	div bx
	add x, dx

	call Rnd ; random generator

	xor dx,dx ;select axiom (random)
	mov ax, seed
	mov bx, 5
	div bx
	mov bx,dx

	xor cx,cx
	mov cl, axiomSizeTable[bx]
	mov SequenceSize, cx

	call Render

	add x, 100

	mov bx, 2
	call delay

	pop cx
	loop mainloop

	mov bx, 25
	call delay

	mov ah,11h
	int 16h
	jnz exit

	jmp beginDraw
	


;************************************

exit:

	mov  ax,0003                 ; return to text mode
	int  10h


;_______________Free memory__________________

	mov ax, Buf1Addr
	mov es,ax
	mov ah, 49h
	int 21h
	
	mov ax, Buf2Addr
	mov es,ax
	mov ah, 49h
	int 21h
;____________________________________________

	int 20h                       ; exit to DOS



end start

;**************** end of program ********************