
uniform float time;
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;
out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for(int i = 0; i<4; ++i) {
		if(joint_indices[i]!=-1 && time>.0f) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if(weight>.0)
		pos /= weight;
	else
		pos = joint[0]*vec4(position, .0, 1.0);
	vec3 wpos = (object_to_clip*pos).xyz;
	wpos.z += .6;
	gl_Position = vec4(wpos, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image;

out vec4 out_color;

void main() {
	float hoerpel = .1*smoothstep(164.0, 150.0, time-uv.x*5.0);
	vec2 coord = vec2(uv.x+cos(uv.y)*hoerpel*10.0, .5+(uv.y-sin(uv.x)*hoerpel*10.0-.5)/(1.0+hoerpel*100000.0));
	out_color = vec4(sin(coord.x), cos(coord.y), sin(coord.y), (1.0-texture(image, coord).x)*smoothstep(145.0, 150.0, time-uv.y*10.0));
}

#endif
