
#ifdef vertex

buffer pose{
	mat4 joint[];
};

in vec2 position;
in vec4 joint_weights;
in ivec4 joint_indices;

out vec2 uv;

uniform mat4 object_to_clip;

uniform int asd;
out vec3 worldpos;

void main() {
	uv = position;
	float weight = .0;
	vec4 pos = vec4(.0);
	for (int i = 0; i<4; ++i) {
		if (joint_indices[i] != -1) {
			pos += joint_weights[i] * joint[joint_indices[i]] * vec4(position, .0, 1.0);
			weight += joint_weights[i];
		}
	}
	if (weight>.0)
		pos /= weight;
	else
		pos = joint[0] * vec4(position, .0, 1.0);
	worldpos = (object_to_clip*pos).xyz;
	worldpos.z -= .97;
	gl_Position = vec4(worldpos, 1.0);
}

#endif

#ifdef fragment

in vec2 uv;

uniform sampler2D image;

uniform float time;

out vec4 out_color;
in vec3 worldpos;

void main() {
	vec2 new_uv = uv;
	new_uv.y = max(.0, new_uv.y);
	vec4 col = texture(image, new_uv);
	col = (col.r>col.b - .0001&&col.r != .0) ? vec4(vec3(float(pow(col.r, 1.0/2.2)*24.0>(time - 113.0))), 1.0) : col;
	float ltime = time + .2*cos(4.0*(worldpos.x + uv.x + sin(uv.y))) + sin(9.0*(worldpos.y + uv.y + cos(uv.x)));
	out_color = mix(vec4(col.xyz, .0), col, max(.0, min(1.0, min(126.0 - ltime, ltime - 115.0))));
}

#endif
